/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_642;
import net.minecraft.class_7417;
import net.minecraft.class_742;
import net.wurstclient.Category;
import net.wurstclient.SearchTags;
import net.wurstclient.clickgui.screens.WaypointsScreen;
import net.wurstclient.events.ChatInputListener;
import net.wurstclient.events.DeathListener;
import net.wurstclient.events.GUIRenderListener;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.SliderSetting;
import net.wurstclient.settings.WaypointsSetting;
import net.wurstclient.util.RenderUtils;
import net.wurstclient.waypoints.Waypoint;
import net.wurstclient.waypoints.WaypointDimension;
import net.wurstclient.waypoints.WaypointsManager;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

@SearchTags(value={"waypoint", "waypoints", "marker"})
public final class WaypointsHack
extends Hack
implements RenderListener,
DeathListener,
UpdateListener,
ChatInputListener,
GUIRenderListener {
    private final WaypointsManager manager;
    private static final DateTimeFormatter TIME_FMT = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final double DISTANCE_SLIDER_INFINITE = 10001.0;
    private static final String[] BOSS_HUD_METHOD_NAMES = new String[]{"getBossOverlay", "getBossHud", "getBossBarHud", "getBossBars"};
    private static final String[] BOSS_BAR_FIELD_NAMES = new String[]{"events", "bossBars"};
    private static Method bossHudMethod;
    private static boolean bossHudMethodResolved;
    private static Field bossBarsField;
    private static boolean bossBarsFieldResolved;
    private static final double PORTAL_DUPLICATE_RADIUS = 5.0;
    private static final double PORTAL_DUPLICATE_RADIUS_SQ = 25.0;
    private static final long PORTAL_PAIR_TIMEOUT_MS = 30000L;
    private static final Pattern PORTAL_NAME_PATTERN;
    private static final Pattern END_PORTAL_NAME_PATTERN;
    private static final long PORTAL_RECORD_COOLDOWN_MS = 2000L;
    private String worldId = "default";
    private boolean hasLoadedWorldData;
    private class_2338 lastDeathAt;
    private long lastDeathCreatedMs;
    private final Map<UUID, Long> otherDeathCooldown = new HashMap<UUID, Long>();
    private final Set<UUID> knownDead = new HashSet<UUID>();
    private boolean sendingOwnChat = false;
    private final SliderSetting waypointRenderDistance = new SliderSetting("Waypoint render distance", 127.0, 0.0, 10001.0, 1.0, SliderSetting.ValueDisplay.INTEGER.withLabel(10001.0, "Infinite"));
    private final SliderSetting fadeDistance = new SliderSetting("Waypoint fade distance", 20.0, 0.0, 1000.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting maxDeathPositions = new SliderSetting("Max death positions", 4.0, 0.0, 20.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting labelScale = new SliderSetting("Label scale", 1.0, 0.5, 5.0, 0.1, SliderSetting.ValueDisplay.DECIMAL);
    private final CheckboxSetting chatOnDeath = new CheckboxSetting("Say death position in chat", true);
    private final CheckboxSetting createDeathWaypoints = new CheckboxSetting("Create death waypoints", true);
    private final CheckboxSetting trackOtherDeaths = new CheckboxSetting("Track other players' deaths", false);
    private final CheckboxSetting deathWaypointLines = new CheckboxSetting("Death waypoint lines", true){

        @Override
        public void update() {
            super.update();
            WaypointsHack.this.applyDeathWaypointLinesSetting();
        }
    };
    private final ColorSetting deathColor = new ColorSetting("Death waypoint color", new Color(0xFF4444));
    private final CheckboxSetting compassMode = new CheckboxSetting("Compass mode (top bar)", false);
    private final SliderSetting compassIconRange = new SliderSetting("Compass icon range", 5000.0, 0.0, 10001.0, 1.0, SliderSetting.ValueDisplay.INTEGER.withLabel(10001.0, "Infinite"));
    private final SliderSetting compassBackgroundOpacity = new SliderSetting("Compass background opacity", 50.0, 0.0, 100.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting compassOpacity = new SliderSetting("Compass text opacity", 100.0, 0.0, 100.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting beaconRenderDistance = new SliderSetting("Beacon render distance", 1000.0, 0.0, 10001.0, 1.0, SliderSetting.ValueDisplay.INTEGER.withLabel(10001.0, "Infinite"));
    private final SliderSetting compassXPercent = new SliderSetting("Compass X %", 50.0, 0.0, 100.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting compassYPercent = new SliderSetting("Compass Y %", 3.0, 0.0, 100.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final CheckboxSetting showPlayerCoordsAboveCompass = new CheckboxSetting("Show player XYZ above compass", false);
    private final CheckboxSetting recordPortals = new CheckboxSetting("Record portals", "Automatically create a waypoint whenever you travel through a portal.", true);
    private final ColorSetting portalWaypointColor = new ColorSetting("Portal waypoint color", new Color(12026111));
    private final Set<UUID> tempWaypoints = new HashSet<UUID>();
    private class_2338 lastPortalRecordedPos;
    private long lastPortalRecordedMs;
    private class_2338 lastPortalDetectionPos;
    private String pendingPortalName;
    private PortalKind pendingPortalKind;
    private WaypointDimension pendingPortalOrigin;
    private long pendingPortalStartMs;

    public WaypointsHack() {
        super("Waypoints");
        this.setCategory(Category.RENDER);
        this.manager = new WaypointsManager(WURST.getWurstFolder());
        this.addSetting(new WaypointsSetting("Manage waypoints", this.manager));
        this.addSetting(this.waypointRenderDistance);
        this.addSetting(this.fadeDistance);
        this.addSetting(this.beaconRenderDistance);
        this.addSetting(this.labelScale);
        this.addSetting(this.compassMode);
        this.addSetting(this.showPlayerCoordsAboveCompass);
        this.addSetting(this.compassIconRange);
        this.addSetting(this.compassXPercent);
        this.addSetting(this.compassYPercent);
        this.addSetting(this.compassOpacity);
        this.addSetting(this.compassBackgroundOpacity);
        this.addSetting(this.createDeathWaypoints);
        this.addSetting(this.chatOnDeath);
        this.addSetting(this.deathWaypointLines);
        this.addSetting(this.trackOtherDeaths);
        this.addSetting(this.maxDeathPositions);
        this.addSetting(this.deathColor);
        this.addSetting(this.recordPortals);
        this.addSetting(this.portalWaypointColor);
    }

    @Override
    protected void onEnable() {
        this.ensureWorldData();
        EVENTS.add(RenderListener.class, this);
        EVENTS.add(UpdateListener.class, this);
        EVENTS.add(DeathListener.class, this);
        EVENTS.add(ChatInputListener.class, this);
        EVENTS.add(GUIRenderListener.class, this);
        this.otherDeathCooldown.clear();
        this.knownDead.clear();
    }

    @Override
    protected void onDisable() {
        this.saveExcludingTemporaries();
        EVENTS.remove(RenderListener.class, this);
        EVENTS.remove(UpdateListener.class, this);
        EVENTS.remove(DeathListener.class, this);
        EVENTS.remove(ChatInputListener.class, this);
        EVENTS.remove(GUIRenderListener.class, this);
        this.otherDeathCooldown.clear();
        this.knownDead.clear();
    }

    public UUID addTemporaryWaypoint(Waypoint w) {
        this.ensureWorldData();
        this.manager.addOrUpdate(w);
        this.tempWaypoints.add(w.getUuid());
        this.saveExcludingTemporaries();
        return w.getUuid();
    }

    public void removeTemporaryWaypoint(UUID uuid) {
        this.ensureWorldData();
        Waypoint toRemove = null;
        for (Waypoint wp : new ArrayList<Waypoint>(this.manager.all())) {
            if (!wp.getUuid().equals(uuid)) continue;
            toRemove = wp;
            break;
        }
        if (toRemove != null) {
            this.manager.remove(toRemove);
            this.tempWaypoints.remove(uuid);
            this.saveExcludingTemporaries();
        }
    }

    public void addWaypointFromCommand(Waypoint waypoint) {
        if (waypoint == null) {
            return;
        }
        this.ensureWorldData();
        this.manager.addOrUpdate(waypoint);
        this.saveExcludingTemporaries();
    }

    private void saveExcludingTemporaries() {
        if (this.tempWaypoints.isEmpty()) {
            this.manager.save(this.worldId);
            return;
        }
        ArrayList<Waypoint> backups = new ArrayList<Waypoint>();
        for (Waypoint w : new ArrayList<Waypoint>(this.manager.all())) {
            if (!this.tempWaypoints.contains(w.getUuid())) continue;
            backups.add(w);
        }
        for (Waypoint w : backups) {
            this.manager.remove(w);
        }
        this.manager.save(this.worldId);
        for (Waypoint w : backups) {
            this.manager.addOrUpdate(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate() {
        this.ensureWorldData();
        this.updatePortalAutoRecording();
        if (this.trackOtherDeaths.isChecked() && WaypointsHack.MC.field_1687 != null && WaypointsHack.MC.field_1724 != null) {
            long now = System.currentTimeMillis();
            for (class_742 p : WaypointsHack.MC.field_1687.method_18456()) {
                if (p == WaypointsHack.MC.field_1724) continue;
                UUID id = p.method_5667();
                boolean deadNow = p.method_6032() <= 0.0f || p.method_29504();
                boolean wasDead = this.knownDead.contains(id);
                if (deadNow && !wasDead) {
                    this.knownDead.add(id);
                    long last = this.otherDeathCooldown.getOrDefault(id, 0L);
                    if (now - last < 10000L) continue;
                    class_2338 at = p.method_24515().method_10086(2);
                    Waypoint w = new Waypoint(UUID.randomUUID(), now);
                    String name = p.method_5477().getString();
                    w.setName("Death of " + name + " " + TIME_FMT.format(LocalTime.now()));
                    w.setIcon("skull");
                    w.setColor(this.deathColor.getColorI());
                    w.setPos(at);
                    w.setDimension(this.currentDim());
                    w.setActionWhenNear(Waypoint.ActionWhenNear.DELETE);
                    w.setActionWhenNearDistance(4);
                    w.setLines(this.deathWaypointLines.isChecked());
                    this.manager.addOrUpdate(w);
                    this.pruneDeaths();
                    this.saveExcludingTemporaries();
                    if (this.chatOnDeath.isChecked()) {
                        this.sendingOwnChat = true;
                        try {
                            WaypointsHack.MC.field_1724.method_7353((class_2561)class_2561.method_43470((String)(name + " died at " + at.method_10263() + ", " + at.method_10264() + ", " + at.method_10260())), false);
                        }
                        finally {
                            this.sendingOwnChat = false;
                        }
                    }
                    this.otherDeathCooldown.put(id, now);
                    continue;
                }
                if (deadNow || !wasDead) continue;
                this.knownDead.remove(id);
            }
        }
    }

    @Override
    public void onReceivedMessage(ChatInputListener.ChatInputEvent event) {
        if (this.sendingOwnChat) {
            return;
        }
        if (!this.trackOtherDeaths.isChecked() || WaypointsHack.MC.field_1687 == null || WaypointsHack.MC.field_1724 == null) {
            return;
        }
        String msg = event.getComponent().getString();
        if (msg == null || msg.isEmpty()) {
            return;
        }
        String lower = msg.toLowerCase(Locale.ROOT);
        if (lower.contains("left the game") || lower.contains("joined the game")) {
            return;
        }
        if (lower.contains("made the achievement") || lower.contains("made the advancement") || lower.contains("got the achievement") || lower.contains("got the advancement") || lower.contains("earned the achievement") || lower.contains("earned the advancement") || lower.contains("has made the advancement") || lower.contains("has made the achievement") || lower.contains("advancement") && lower.contains("completed") || lower.contains("completed") && (lower.contains("challenge") || lower.contains("advancement") || lower.contains("achievement"))) {
            return;
        }
        long now = System.currentTimeMillis();
        for (class_742 p : WaypointsHack.MC.field_1687.method_18456()) {
            String name;
            if (p == WaypointsHack.MC.field_1724 || (name = p.method_5477().getString()) == null || name.isEmpty() || !msg.startsWith(name + " ")) continue;
            UUID id = p.method_5667();
            long last = this.otherDeathCooldown.getOrDefault(id, 0L);
            if (now - last < 10000L) {
                return;
            }
            class_2338 at = p.method_24515().method_10086(2);
            Waypoint w = new Waypoint(UUID.randomUUID(), now);
            w.setName("Death of " + name + " " + TIME_FMT.format(LocalTime.now()));
            w.setIcon("skull");
            w.setColor(this.deathColor.getColorI());
            w.setPos(at);
            w.setDimension(this.currentDim());
            w.setActionWhenNear(Waypoint.ActionWhenNear.DELETE);
            w.setActionWhenNearDistance(4);
            w.setLines(this.deathWaypointLines.isChecked());
            this.manager.addOrUpdate(w);
            this.pruneDeaths();
            this.saveExcludingTemporaries();
            this.otherDeathCooldown.put(id, now);
            if (this.chatOnDeath.isChecked()) {
                class_5250 oldText = (class_5250)event.getComponent();
                class_5250 newText = class_5250.method_43477((class_7417)oldText.method_10851());
                newText.method_10862(oldText.method_10866());
                oldText.method_10855().forEach(arg_0 -> ((class_5250)newText).method_10852(arg_0));
                newText.method_27693(" at " + at.method_10263() + ", " + at.method_10264() + ", " + at.method_10260());
                event.setComponent((class_2561)newText);
            }
            return;
        }
    }

    private void updatePortalAutoRecording() {
        if (!this.recordPortals.isChecked()) {
            this.lastPortalDetectionPos = null;
            this.clearPendingPortal();
            return;
        }
        class_2338 portal = this.detectPortalBlockNearPlayer();
        if (portal == null) {
            this.lastPortalDetectionPos = null;
            this.clearPendingPortalIfExpired();
            return;
        }
        if (this.lastPortalDetectionPos != null && this.lastPortalDetectionPos.equals((Object)portal)) {
            return;
        }
        this.lastPortalDetectionPos = portal;
        this.recordPortalWaypoint(portal);
    }

    private void clearPendingPortal() {
        this.pendingPortalName = null;
        this.pendingPortalKind = null;
        this.pendingPortalOrigin = null;
        this.pendingPortalStartMs = 0L;
    }

    private void clearPendingPortalIfExpired() {
        if (this.pendingPortalName == null) {
            return;
        }
        if (System.currentTimeMillis() - this.pendingPortalStartMs > 30000L) {
            this.clearPendingPortal();
        }
    }

    private class_2338 detectPortalBlockNearPlayer() {
        if (WaypointsHack.MC.field_1724 == null || WaypointsHack.MC.field_1687 == null) {
            return null;
        }
        class_238 box = WaypointsHack.MC.field_1724.method_5829().method_1014(0.05);
        int minX = (int)Math.floor(box.field_1323);
        int minY = (int)Math.floor(box.field_1322);
        int minZ = (int)Math.floor(box.field_1321);
        int maxX = (int)Math.floor(box.field_1320);
        int maxY = (int)Math.floor(box.field_1325);
        int maxZ = (int)Math.floor(box.field_1324);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    if (this.classifyPortal(pos) != null) {
                        return pos.method_10062();
                    }
                    class_2338 below = pos.method_10074();
                    if (this.classifyPortal(below) == null) continue;
                    return below.method_10062();
                }
            }
        }
        return null;
    }

    private void recordPortalWaypoint(class_2338 portalPos) {
        boolean isEndDimension;
        if (!this.recordPortals.isChecked() || portalPos == null) {
            return;
        }
        if (WaypointsHack.MC.field_1724 == null || WaypointsHack.MC.field_1687 == null) {
            return;
        }
        PortalKind kind = this.classifyPortal(portalPos);
        if (kind == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (this.lastPortalRecordedPos != null && this.lastPortalRecordedPos.method_10262((class_2382)portalPos) <= 1.0 && now - this.lastPortalRecordedMs < 2000L) {
            return;
        }
        this.ensureWorldData();
        WaypointDimension dim = this.currentDim();
        class_2338 immutable = portalPos.method_10062();
        boolean linkingPending = this.pendingPortalName != null && this.pendingPortalKind == kind && this.pendingPortalOrigin != null && this.pendingPortalOrigin != dim && now - this.pendingPortalStartMs <= 30000L;
        String prefix = kind == PortalKind.END ? "End Portal" : "Portal";
        boolean bl = isEndDimension = dim == WaypointDimension.END;
        Object name = linkingPending ? this.pendingPortalName : (kind == PortalKind.END && isEndDimension ? "End Portal" : prefix + " " + this.nextPortalIndex(prefix, dim));
        if (this.hasNearbyPortalWaypoint(immutable, dim)) {
            if (linkingPending) {
                this.clearPendingPortal();
            }
            return;
        }
        Waypoint waypoint = new Waypoint(UUID.randomUUID(), now);
        waypoint.setName((String)name);
        waypoint.setPos(immutable);
        waypoint.setDimension(dim);
        waypoint.setColor(this.portalWaypointColor.getColorI());
        waypoint.setOpposite(false);
        waypoint.setIcon("diamond");
        waypoint.setLines(false);
        waypoint.setBeaconMode(Waypoint.BeaconMode.OFF);
        this.manager.addOrUpdate(waypoint);
        this.saveExcludingTemporaries();
        this.lastPortalRecordedPos = immutable;
        this.lastPortalRecordedMs = now;
        if (linkingPending) {
            this.clearPendingPortal();
        } else if (kind == PortalKind.NETHER) {
            this.pendingPortalName = name;
            this.pendingPortalKind = kind;
            this.pendingPortalOrigin = dim;
            this.pendingPortalStartMs = now;
        }
    }

    @Override
    public void onRender(class_4587 matrices, float partialTicks) {
        if (WaypointsHack.MC.field_1724 == null || WaypointsHack.MC.field_1687 == null) {
            return;
        }
        ArrayList<Waypoint> list = new ArrayList<Waypoint>(this.manager.all());
        double beaconRange = this.beaconRenderDistance.getValue();
        boolean beaconInfinite = beaconRange >= 10001.0;
        boolean beaconsEnabled = beaconInfinite || beaconRange > 0.0;
        double beaconRangeSq = beaconInfinite ? Double.POSITIVE_INFINITY : beaconRange * beaconRange;
        for (Waypoint w : list) {
            class_243 cam;
            class_243 target;
            class_243 dir;
            double len;
            boolean needAnchor;
            boolean beyondMaxVisible;
            class_2338 wp;
            if (!w.isVisible() || (wp = this.worldSpace(w)) == null) continue;
            double distSq = WaypointsHack.MC.field_1724.method_5649((double)wp.method_10263() + 0.5, (double)wp.method_10264() + 0.5, (double)wp.method_10260() + 0.5);
            double dist = Math.sqrt(distSq);
            double trd = this.waypointRenderDistance.getValue();
            boolean infiniteLabels = trd >= 10001.0;
            boolean allowBySlider = trd > 0.0 && dist <= trd;
            boolean renderLabel = infiniteLabels || allowBySlider;
            boolean bl = beyondMaxVisible = distSq > (double)(w.getMaxVisible() * w.getMaxVisible());
            if (beyondMaxVisible && !renderLabel && !w.isLines()) continue;
            if (w.isLines()) {
                RenderUtils.drawTracer(matrices, partialTicks, new class_243((double)wp.method_10263() + 0.5, (double)wp.method_10264() + 0.5, (double)wp.method_10260() + 0.5), this.applyFade(w.getColor(), distSq), false);
                RenderUtils.drawOutlinedBoxes(matrices, List.of(new class_238(wp)), this.applyFade(w.getColor(), distSq), false);
            }
            if (!beyondMaxVisible) {
                if (System.currentTimeMillis() - w.getCreatedAt() >= 1000L && distSq <= (double)(w.getActionWhenNearDistance() * w.getActionWhenNearDistance())) {
                    switch (w.getActionWhenNear()) {
                        case HIDE: {
                            w.setVisible(false);
                            break;
                        }
                        case DELETE: {
                            this.manager.remove(w);
                            break;
                        }
                    }
                }
                Waypoint.BeaconMode beaconMode = this.waypointBeaconMode(w);
                if (beaconsEnabled && beaconMode != Waypoint.BeaconMode.OFF && (beaconInfinite || distSq <= beaconRangeSq)) {
                    this.drawBeaconBeam(matrices, wp, this.applyFade(w.getColor(), distSq), beaconMode);
                }
            }
            if (!renderLabel) continue;
            Object title = w.getName() == null ? "" : w.getName();
            String icon = this.iconChar(w.getIcon());
            if (!icon.isEmpty()) {
                title = icon + (String)(((String)title).isEmpty() ? "" : " " + (String)title);
            }
            String distanceText = (int)dist + " blocks";
            double baseY = (double)wp.method_10264() + 1.2;
            double lx = (double)wp.method_10263() + 0.5;
            double ly = baseY;
            double lz = (double)wp.method_10260() + 0.5;
            boolean bl2 = needAnchor = infiniteLabels || dist > 256.0;
            if (needAnchor && (len = (dir = (target = new class_243(lx, ly, lz)).method_1020(cam = RenderUtils.getCameraPos())).method_1033()) > 0.001) {
                double anchor = Math.min(len, 12.0);
                class_243 anchored = cam.method_1019(dir.method_1021(anchor / len));
                lx = anchored.field_1352;
                ly = anchored.field_1351;
                lz = anchored.field_1350;
            }
            float scale = (float)this.labelScale.getValue();
            boolean anchored = needAnchor;
            if (!anchored) {
                class_243 cam2 = RenderUtils.getCameraPos();
                double dLabel = cam2.method_1022(new class_243(lx, ly, lz));
                double compensate = Math.max(1.0, dLabel * 0.1);
                scale *= (float)compensate;
            }
            float sepPx = 10.0f;
            this.drawWorldLabel(matrices, (String)title, lx, ly, lz, this.applyFade(w.getColor(), distSq), scale, -sepPx);
            this.drawWorldLabel(matrices, distanceText, lx, ly, lz, this.applyFade(w.getColor(), distSq), scale * 0.9f, 0.0f);
        }
    }

    @Override
    public void onDeath() {
        if (WaypointsHack.MC.field_1724 == null) {
            return;
        }
        class_2338 at = WaypointsHack.MC.field_1724.method_24515().method_10086(2);
        long now = System.currentTimeMillis();
        if (this.lastDeathAt != null && this.lastDeathAt.equals((Object)at) && now - this.lastDeathCreatedMs < 10000L) {
            return;
        }
        if (this.chatOnDeath.isChecked()) {
            WaypointsHack.MC.field_1724.method_7353((class_2561)class_2561.method_43470((String)("Died at " + at.method_10263() + ", " + at.method_10264() + ", " + at.method_10260())), false);
        }
        if (this.createDeathWaypoints.isChecked()) {
            Waypoint w = new Waypoint(UUID.randomUUID(), now);
            w.setName("Death " + TIME_FMT.format(LocalTime.now()));
            w.setIcon("skull");
            w.setColor(this.deathColor.getColorI());
            w.setPos(at);
            w.setDimension(this.currentDim());
            w.setActionWhenNear(Waypoint.ActionWhenNear.DELETE);
            w.setActionWhenNearDistance(4);
            w.setLines(this.deathWaypointLines.isChecked());
            this.manager.addOrUpdate(w);
            this.pruneDeaths();
            this.saveExcludingTemporaries();
        }
        this.lastDeathAt = at;
        this.lastDeathCreatedMs = now;
    }

    private WaypointDimension currentDim() {
        String key;
        if (WaypointsHack.MC.field_1687 == null) {
            return WaypointDimension.OVERWORLD;
        }
        return switch (key = WaypointsHack.MC.field_1687.method_27983().method_29177().method_12832()) {
            case "the_nether" -> WaypointDimension.NETHER;
            case "the_end" -> WaypointDimension.END;
            default -> WaypointDimension.OVERWORLD;
        };
    }

    private String resolveWorldId() {
        class_642 s = MC.method_1558();
        if (s != null && s.field_3761 != null && !s.field_3761.isEmpty()) {
            return s.field_3761.replace(':', '_');
        }
        return "singleplayer";
    }

    private void ensureWorldData() {
        String wid = this.resolveWorldId();
        if (!this.hasLoadedWorldData) {
            this.worldId = wid;
            this.manager.load(this.worldId);
            this.applyDeathWaypointLinesSetting();
            this.lastPortalDetectionPos = null;
            this.clearPendingPortal();
            this.hasLoadedWorldData = true;
            return;
        }
        if (!wid.equals(this.worldId)) {
            this.saveExcludingTemporaries();
            this.worldId = wid;
            this.manager.load(this.worldId);
            this.applyDeathWaypointLinesSetting();
            this.lastPortalDetectionPos = null;
            this.clearPendingPortal();
        }
    }

    private class_2338 worldSpace(Waypoint w) {
        WaypointDimension pd = this.currentDim();
        WaypointDimension wd = w.getDimension();
        class_2338 p = w.getPos();
        if (pd == wd) {
            return p;
        }
        if (!w.isOpposite()) {
            return null;
        }
        if (pd == WaypointDimension.OVERWORLD && wd == WaypointDimension.NETHER) {
            return new class_2338(p.method_10263() * 8, p.method_10264(), p.method_10260() * 8);
        }
        if (pd == WaypointDimension.NETHER && wd == WaypointDimension.OVERWORLD) {
            return new class_2338(p.method_10263() / 8, p.method_10264(), p.method_10260() / 8);
        }
        return null;
    }

    private PortalKind classifyPortal(class_2338 pos) {
        if (pos == null || WaypointsHack.MC.field_1687 == null) {
            return null;
        }
        class_2680 state = WaypointsHack.MC.field_1687.method_8320(pos);
        if (state.method_27852(class_2246.field_10316)) {
            return PortalKind.NETHER;
        }
        if (state.method_27852(class_2246.field_10027) || state.method_27852(class_2246.field_10613)) {
            return PortalKind.END;
        }
        return null;
    }

    private boolean hasNearbyPortalWaypoint(class_2338 pos, WaypointDimension dim) {
        double maxSq = 25.0;
        for (Waypoint w : this.manager.all()) {
            if (w.getDimension() != dim || !(pos.method_10262((class_2382)w.getPos()) <= maxSq)) continue;
            return true;
        }
        return false;
    }

    private int nextPortalIndex(String prefix, WaypointDimension targetDim) {
        Pattern pattern = "End Portal".equals(prefix) ? END_PORTAL_NAME_PATTERN : PORTAL_NAME_PATTERN;
        int max = 0;
        for (Waypoint w : this.manager.all()) {
            Matcher matcher;
            String name = w.getName();
            if (name == null || "End Portal".equals(prefix) && targetDim != WaypointDimension.END && w.getDimension() == WaypointDimension.END || !(matcher = pattern.matcher(name)).matches()) continue;
            try {
                int num = Integer.parseInt(matcher.group(1));
                if (num <= max) continue;
                max = num;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return max + 1;
    }

    private void pruneDeaths() {
        List<Waypoint> all = this.manager.all();
        ArrayList<Waypoint> deaths = new ArrayList<Waypoint>();
        for (Waypoint w : all) {
            if (w.getName() == null || !w.getName().startsWith("Death ")) continue;
            deaths.add(w);
        }
        if (deaths.size() <= this.maxDeathPositions.getValueI()) {
            return;
        }
        deaths.sort((a, b) -> Long.compare(a.getCreatedAt(), b.getCreatedAt()));
        int remove = deaths.size() - this.maxDeathPositions.getValueI();
        for (int i = 0; i < remove; ++i) {
            this.manager.remove((Waypoint)deaths.get(i));
        }
    }

    private void applyDeathWaypointLinesSetting() {
        if (this.manager == null) {
            return;
        }
        boolean linesEnabled = this.deathWaypointLines.isChecked();
        boolean changed = false;
        for (Waypoint w : this.manager.all()) {
            String name = w.getName();
            if (name == null || !name.startsWith("Death ") && !name.startsWith("Death of ") || w.isLines() == linesEnabled) continue;
            w.setLines(linesEnabled);
            changed = true;
        }
        if (changed) {
            this.saveExcludingTemporaries();
        }
    }

    private void drawWorldLabel(class_4587 matrices, String text, double x, double y, double z, int argb, float scale, float offsetPx) {
        matrices.method_22903();
        class_243 cam = RenderUtils.getCameraPos();
        matrices.method_22904(x - cam.field_1352, y - cam.field_1351, z - cam.field_1350);
        matrices.method_22907((Quaternionfc)MC.method_1561().method_24197());
        float s = 0.025f * scale;
        matrices.method_22905(s, -s, s);
        matrices.method_46416(0.0f, offsetPx, 0.0f);
        class_327 tr = WaypointsHack.MC.field_1772;
        class_4597.class_4598 vcp = RenderUtils.getVCP();
        float w = (float)tr.method_1727(text) / 2.0f;
        int bg = (int)(WaypointsHack.MC.field_1690.method_19343(0.25f) * 255.0f) << 24;
        Matrix4f matrix = matrices.method_23760().method_23761();
        tr.method_27521(text, -w, 0.0f, argb, false, matrix, (class_4597)vcp, class_327.class_6415.field_33994, bg, 0xF000F0);
        vcp.method_22993();
        matrices.method_22909();
    }

    private void drawBeaconBeam(class_4587 matrices, class_2338 pos, int color, Waypoint.BeaconMode mode) {
        Waypoint.BeaconMode safeMode;
        if (WaypointsHack.MC.field_1687 == null) {
            return;
        }
        Waypoint.BeaconMode beaconMode = safeMode = mode == null ? Waypoint.BeaconMode.OFF : mode;
        if (safeMode == Waypoint.BeaconMode.OFF) {
            return;
        }
        int minY = WaypointsHack.MC.field_1687.method_31607();
        int maxY = WaypointsHack.MC.field_1687.method_31600() + 1;
        double baseX = pos.method_10263();
        double baseZ = pos.method_10260();
        double centerX = baseX + 0.5;
        double centerZ = baseZ + 0.5;
        boolean depthTest = safeMode != Waypoint.BeaconMode.ESP;
        int rgb = color & 0xFFFFFF;
        int alpha = color >>> 24 & 0xFF;
        if (alpha <= 0) {
            alpha = 64;
        }
        ArrayList<RenderUtils.ColoredBox> boxes = new ArrayList<RenderUtils.ColoredBox>();
        boxes.add(new RenderUtils.ColoredBox(new class_238(centerX - 0.18, (double)minY, centerZ - 0.18, centerX + 0.18, (double)maxY, centerZ + 0.18), WaypointsHack.withAlpha(rgb, Math.min(255, alpha + 100))));
        boxes.add(new RenderUtils.ColoredBox(new class_238(centerX - 0.32, (double)minY, centerZ - 0.05, centerX + 0.32, (double)maxY, centerZ + 0.05), WaypointsHack.withAlpha(rgb, alpha / 2)));
        boxes.add(new RenderUtils.ColoredBox(new class_238(centerX - 0.05, (double)minY, centerZ - 0.32, centerX + 0.05, (double)maxY, centerZ + 0.32), WaypointsHack.withAlpha(rgb, alpha / 2)));
        boxes.add(new RenderUtils.ColoredBox(new class_238(baseX, (double)minY, baseZ, baseX + 1.0, (double)maxY, baseZ + 1.0), WaypointsHack.withAlpha(rgb, Math.max(30, alpha / 6))));
        RenderUtils.drawSolidBoxes(matrices, boxes, depthTest);
        if (safeMode == Waypoint.BeaconMode.ESP) {
            RenderUtils.drawOutlinedBoxes(matrices, List.of(new class_238(baseX, (double)minY, baseZ, baseX + 1.0, (double)maxY, baseZ + 1.0)), WaypointsHack.withAlpha(rgb, Math.max(alpha, 120)), false);
        }
    }

    private Waypoint.BeaconMode waypointBeaconMode(Waypoint waypoint) {
        Waypoint.BeaconMode mode = waypoint.getBeaconMode();
        return mode == null ? Waypoint.BeaconMode.OFF : mode;
    }

    private static int withAlpha(int rgb, int alpha) {
        int clamped = Math.max(0, Math.min(255, alpha));
        return clamped << 24 | rgb & 0xFFFFFF;
    }

    private int applyFade(int argb, double distSq) {
        double fade = this.fadeDistance.getValue();
        if (fade <= 0.0) {
            return argb;
        }
        double dist = Math.sqrt(distSq);
        if (dist >= fade) {
            return argb;
        }
        int a = argb >>> 24 & 0xFF;
        int r = argb >>> 16 & 0xFF;
        int g = argb >>> 8 & 0xFF;
        int b = argb & 0xFF;
        int na = (int)Math.max(0.0, Math.min((double)a, (double)a * (dist / fade)));
        return na << 24 | r << 16 | g << 8 | b;
    }

    private String iconChar(String icon) {
        if (icon == null) {
            return "";
        }
        switch (icon.toLowerCase()) {
            case "square": {
                return "\u25a0";
            }
            case "circle": {
                return "\u25cf";
            }
            case "triangle": {
                return "\u25b2";
            }
            case "triangle_down": {
                return "\u25bc";
            }
            case "star": {
                return "\u2605";
            }
            case "diamond": {
                return "\u2666";
            }
            case "skull": {
                return "\u2620";
            }
            case "heart": {
                return "\u2665";
            }
            case "check": {
                return "\u2713";
            }
            case "x": {
                return "\u2717";
            }
            case "arrow_down": {
                return "\u2193";
            }
            case "sun": {
                return "\u2600";
            }
            case "snowflake": {
                return "\u2744";
            }
        }
        return "";
    }

    public void openManager() {
        this.ensureWorldData();
        MC.method_1507((class_437)new WaypointsScreen(WaypointsHack.MC.field_1755, this.manager));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onRenderGUI(class_332 context, float partialTicks) {
        if (!this.compassMode.isChecked() || WaypointsHack.MC.field_1724 == null || WaypointsHack.MC.field_1687 == null) {
            return;
        }
        class_327 tr = WaypointsHack.MC.field_1772;
        int sw = context.method_51421();
        int sh = context.method_51443();
        int centerX = (int)Math.round((double)sw * (this.compassXPercent.getValue() / 100.0));
        int baseBarY = (int)Math.round((double)sh * (this.compassYPercent.getValue() / 100.0));
        int barY = this.adjustCompassYForOverlays(context, baseBarY);
        int barH = 8;
        int pad = 6;
        int halfWidth = Math.min(120, Math.max(60, sw / 4));
        double visibleAngle = 90.0;
        double selectFov = 6.0;
        double bgOpacity = Math.max(0.0, Math.min(1.0, this.compassBackgroundOpacity.getValue() / 100.0));
        int bgAlpha = (int)Math.round(255.0 * bgOpacity);
        int bgColor = bgAlpha << 24;
        context.method_25294(centerX - halfWidth - pad, barY - 2, centerX + halfWidth + pad, barY + barH + 2, bgColor);
        if (this.showPlayerCoordsAboveCompass.isChecked()) {
            String dir = WaypointsHack.cardinalFromYaw(WaypointsHack.MC.field_1724.method_36454());
            int ix = (int)Math.floor(WaypointsHack.MC.field_1724.method_23317());
            int iy = (int)Math.floor(WaypointsHack.MC.field_1724.method_23318());
            int iz = (int)Math.floor(WaypointsHack.MC.field_1724.method_23321());
            String coords = dir + ": " + ix + " " + iy + " " + iz;
            int cw = tr.method_1727(coords);
            int cx = centerX - cw / 2;
            int cy = Math.max(2, barY - 13);
            context.method_51433(tr, coords, cx, cy, -1, false);
        }
        ArrayList<Waypoint> list = new ArrayList<Waypoint>(this.manager.all());
        ArrayList<WaypointEntry> entries = new ArrayList<WaypointEntry>();
        double iconRange = this.compassIconRange.getValue();
        boolean infiniteIconRange = iconRange >= 10001.0;
        double iconRangeSq = iconRange * iconRange;
        double bestAbs = Double.MAX_VALUE;
        WaypointEntry best = null;
        double px = WaypointsHack.MC.field_1724.method_23317();
        double pz = WaypointsHack.MC.field_1724.method_23321();
        double playerYaw = WaypointsHack.MC.field_1724.method_36454();
        for (Waypoint waypoint : list) {
            double dot;
            double fz;
            double len;
            int waypointMax;
            double waypointMaxSq;
            boolean beyondWaypointMax;
            class_2338 wpb;
            if (!waypoint.isVisible() || (wpb = this.worldSpace(waypoint)) == null) continue;
            double dx = (double)wpb.method_10263() + 0.5 - px;
            double dz = (double)wpb.method_10260() + 0.5 - pz;
            double distSq = WaypointsHack.MC.field_1724.method_5649((double)wpb.method_10263() + 0.5, (double)wpb.method_10264() + 0.5, (double)wpb.method_10260() + 0.5);
            boolean bl = beyondWaypointMax = distSq > (waypointMaxSq = (double)((waypointMax = waypoint.getMaxVisible()) * waypointMax));
            if (!infiniteIconRange && (iconRange <= 0.0 && distSq > 0.0 || iconRange > 0.0 && distSq > iconRangeSq || iconRange <= (double)waypointMax && beyondWaypointMax) || (len = Math.sqrt(dx * dx + dz * dz)) < 1.0E-6) continue;
            double nx = dx / len;
            double nz = dz / len;
            double yawRad = Math.toRadians(playerYaw);
            double fx = -Math.sin(yawRad);
            double cross = fx * nz - (fz = Math.cos(yawRad)) * nx;
            double delta = Math.toDegrees(Math.atan2(cross, dot = fx * nx + fz * nz));
            if (Math.abs(delta) > visibleAngle) continue;
            double x = (double)centerX + delta / visibleAngle * (double)halfWidth;
            WaypointEntry e = new WaypointEntry(waypoint, x, delta);
            entries.add(e);
            double ad = Math.abs(delta);
            if (!(ad < bestAbs)) continue;
            bestAbs = ad;
            best = e;
        }
        WaypointEntry selected = null;
        if (best != null && Math.abs(best.delta) <= selectFov) {
            selected = best;
        }
        for (WaypointEntry e : entries) {
            String icon;
            int ix = (int)Math.round(e.x);
            if (selected != null && e.w.getUuid().equals(selected.w.getUuid())) {
                ix = centerX;
            }
            if ((icon = this.iconChar(e.w.getIcon())) == null) {
                icon = "";
            }
            int color = e.w.getColor();
            int iconW = tr.method_1727(icon);
            double d = (double)barY + (double)barH / 2.0;
            Objects.requireNonNull(tr);
            int iconY = (int)Math.round(d - 9.0 / 2.0);
            context.method_51433(tr, icon, ix - iconW / 2, iconY, color, false);
        }
        if (selected != null) {
            void var37_39;
            String string = selected.w.getName() == null ? "" : selected.w.getName();
            String icon = this.iconChar(selected.w.getIcon());
            if (icon != null && !icon.isEmpty()) {
                String string2 = icon + (String)(string.isEmpty() ? "" : " " + string);
            }
            class_2338 wpb = this.worldSpace(selected.w);
            int distBlocks = 0;
            if (wpb != null) {
                distBlocks = (int)Math.round(Math.sqrt(WaypointsHack.MC.field_1724.method_5649((double)wpb.method_10263() + 0.5, (double)wpb.method_10264() + 0.5, (double)wpb.method_10260() + 0.5)));
            }
            String distText = distBlocks + " blocks";
            int tw = tr.method_1727((String)var37_39);
            int dw = tr.method_1727(distText);
            int titleX = centerX - tw / 2;
            int distX = centerX - dw / 2;
            int titleY = barY + barH + 2;
            int distY = titleY + 10;
            double opaText = Math.max(0.0, Math.min(1.0, this.compassOpacity.getValue() / 100.0));
            int aText = (int)Math.round(255.0 * opaText);
            int textColor = aText << 24 | 0xFFFFFF;
            context.method_51433(tr, (String)var37_39, titleX, titleY, textColor, false);
            context.method_51433(tr, distText, distX, distY, textColor, false);
        }
    }

    private int adjustCompassYForOverlays(class_332 context, int baseY) {
        int adjusted = baseY;
        int bossBarBottom = this.getBossBarBottom(context);
        if (bossBarBottom > 0) {
            int margin = this.showPlayerCoordsAboveCompass.isChecked() ? 10 : 2;
            adjusted = Math.max(adjusted, bossBarBottom + margin);
        }
        return adjusted;
    }

    private int getBossBarBottom(class_332 context) {
        if (WaypointsHack.MC.field_1705 == null) {
            return 0;
        }
        Object bossBarHud = WaypointsHack.getBossHud();
        if (bossBarHud == null) {
            return 0;
        }
        int barCount = WaypointsHack.getBossBarCount(bossBarHud);
        if (barCount == 0) {
            return 0;
        }
        int screenHeight = context.method_51443();
        int maxY = screenHeight / 3;
        int y = 12;
        for (int i = 0; i < barCount; ++i) {
            if (y >= maxY) {
                return maxY;
            }
            y += 10;
        }
        return Math.min(y, maxY);
    }

    private static Object getBossHud() {
        Method method = WaypointsHack.getBossHudMethod();
        if (method == null || WaypointsHack.MC.field_1705 == null) {
            return null;
        }
        try {
            return method.invoke((Object)WaypointsHack.MC.field_1705, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Method getBossHudMethod() {
        if (bossHudMethodResolved) {
            return bossHudMethod;
        }
        bossHudMethodResolved = true;
        if (WaypointsHack.MC.field_1705 == null) {
            return null;
        }
        for (String name : BOSS_HUD_METHOD_NAMES) {
            try {
                Method method = WaypointsHack.MC.field_1705.getClass().getMethod(name, new Class[0]);
                method.setAccessible(true);
                bossHudMethod = method;
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    private static int getBossBarCount(Object bossHud) {
        Field field = WaypointsHack.getBossBarsField(bossHud);
        if (field == null) {
            return 0;
        }
        try {
            Object value = field.get(bossHud);
            if (value instanceof Map) {
                Map map = (Map)value;
                return map.size();
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                return collection.size();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return 0;
    }

    private static Field getBossBarsField(Object bossHud) {
        if (bossBarsFieldResolved) {
            return bossBarsField;
        }
        bossBarsFieldResolved = true;
        if (bossHud == null) {
            return null;
        }
        Class<?> cls = bossHud.getClass();
        for (String name : BOSS_BAR_FIELD_NAMES) {
            try {
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                bossBarsField = field;
                return field;
            }
            catch (NoSuchFieldException field) {
            }
        }
        for (Field field : cls.getDeclaredFields()) {
            Class<?> type = field.getType();
            if (!Map.class.isAssignableFrom(type) && !Collection.class.isAssignableFrom(type)) continue;
            field.setAccessible(true);
            bossBarsField = field;
            return field;
        }
        return null;
    }

    private static String cardinalFromYaw(double yaw) {
        double norm = yaw % 360.0;
        if (norm < 0.0) {
            norm += 360.0;
        }
        int idx = (int)Math.floor((norm + 22.5) / 45.0) % 8;
        switch (idx) {
            case 0: {
                return "S";
            }
            case 1: {
                return "SW";
            }
            case 2: {
                return "W";
            }
            case 3: {
                return "NW";
            }
            case 4: {
                return "N";
            }
            case 5: {
                return "NE";
            }
            case 6: {
                return "E";
            }
            case 7: {
                return "SE";
            }
        }
        return "?";
    }

    static {
        PORTAL_NAME_PATTERN = Pattern.compile("^Portal (\\d+)$", 2);
        END_PORTAL_NAME_PATTERN = Pattern.compile("^End Portal (\\d+)$", 2);
    }

    private static enum PortalKind {
        NETHER,
        END;

    }

    private static final class WaypointEntry {
        final Waypoint w;
        final double x;
        final double delta;

        WaypointEntry(Waypoint w, double x, double delta) {
            this.w = w;
            this.x = x;
            this.delta = delta;
        }
    }
}

