/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hacks.itemhandler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.widgets.MultiSelectEntryListWidget;
import net.wurstclient.hacks.itemhandler.ItemHandlerHack;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.ItemUtils;
import net.wurstclient.util.RenderUtils;

public class ItemHandlerScreen
extends class_437 {
    private final class_437 previous;
    private final ItemHandlerHack hack;
    private ListGui listGui;
    private class_4185 pickButton;
    private class_4185 closeButton;
    private class_4185 traceButton;
    private class_4185 rejectButton;

    public ItemHandlerScreen(class_437 prev, ItemHandlerHack hack) {
        super((class_2561)class_2561.method_43473());
        this.previous = prev;
        this.hack = hack;
    }

    protected void method_25426() {
        int top = 40;
        int listHeight = this.field_22790 - 96;
        this.listGui = new ListGui(class_310.method_1551(), this.field_22789, listHeight, top, 36);
        this.method_25429((class_364)this.listGui);
        int gap = 10;
        int wReject = 140;
        int wPick = 140;
        int wTrace = 140;
        int wClose = 100;
        int total = wReject + wPick + wTrace + wClose + gap * 3;
        int startX = (this.field_22789 - total) / 2;
        this.rejectButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reject Selected Items"), b -> this.rejectSelected()).method_46434(startX, this.field_22790 - 40, wReject, 20).method_46431();
        this.method_37063((class_364)this.rejectButton);
        this.pickButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Pick Selected Items"), b -> this.pickSelected()).method_46434(startX + wReject + gap, this.field_22790 - 40, wPick, 20).method_46431();
        this.method_37063((class_364)this.pickButton);
        this.traceButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Trace Selected Items"), b -> this.traceSelected()).method_46434(startX + wReject + gap + wPick + gap, this.field_22790 - 40, wTrace, 20).method_46431();
        this.method_37063((class_364)this.traceButton);
        this.closeButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Close"), b -> this.method_25419()).method_46434(startX + wReject + gap + wPick + gap + wTrace + gap, this.field_22790 - 40, wClose, 20).method_46431();
        this.method_37063((class_364)this.closeButton);
        this.listGui.ensureSelection();
        this.updateButtons();
    }

    private void pickSelected() {
        List selected = this.listGui.getSelectedEntries();
        if (selected.isEmpty()) {
            return;
        }
        LinkedHashSet<String> desired = new LinkedHashSet<String>();
        for (ListGui.Entry e : selected) {
            String k = e.selectionKey();
            if (k == null) continue;
            desired.add(k);
        }
        this.hack.beginPickFilterSession(desired);
        ChatUtils.message("Pick filter: drop non-targets until selected is picked.");
        this.method_25419();
    }

    private void rejectSelected() {
        List selected = this.listGui.getSelectedEntries();
        if (selected.isEmpty()) {
            return;
        }
        List<ItemHandlerHack.GroundItem> items = selected.stream().flatMap(e -> e.groundItems().stream()).collect(Collectors.toList());
        this.hack.addRejectedRulesFromItems(items);
        ChatUtils.message("Reject rules added for " + items.size() + " stacks.");
        this.method_25419();
    }

    private void traceSelected() {
        List selected = this.listGui.getSelectedEntries();
        if (selected.isEmpty()) {
            return;
        }
        int enabled = 0;
        int disabled = 0;
        for (ListGui.Entry e : selected) {
            String id = e.selectionKey();
            if (id == null) continue;
            boolean was = this.hack.isTraced(id);
            this.hack.toggleTracedItem(id);
            if (was) {
                ++disabled;
                continue;
            }
            ++enabled;
        }
        ChatUtils.message("Tracing: +" + enabled + "  -" + disabled);
        this.listGui.reloadFromHack();
        this.updateButtons();
    }

    public void method_25419() {
        this.field_22787.method_1507(this.previous);
    }

    public void method_25393() {
        super.method_25393();
        this.listGui.reloadFromHack();
        this.updateButtons();
    }

    private void updateButtons() {
        boolean has;
        this.pickButton.field_22763 = has = this.listGui.hasSelection();
        this.rejectButton.field_22763 = has;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTicks) {
        this.listGui.method_25394(context, mouseX, mouseY, partialTicks);
        context.method_25300(this.field_22793, "Item Handler", this.field_22789 / 2, 12, -1);
        for (class_4068 r : this.field_33816) {
            r.method_25394(context, mouseX, mouseY, partialTicks);
        }
        if (this.pickButton.method_25367() && !this.pickButton.field_22763) {
            context.method_51434(this.field_22793, Arrays.asList(class_2561.method_43470((String)"Select items to pick.")), mouseX, mouseY);
        }
    }

    public boolean method_25421() {
        return false;
    }

    private static final class ListGui
    extends MultiSelectEntryListWidget<Entry> {
        private final ItemHandlerHack hack;

        public ListGui(class_310 client, int width, int height, int top, int itemHeight) {
            super(client, width, height, top, itemHeight);
            this.hack = WurstClient.INSTANCE.getHax().itemHandlerHack;
            this.reloadFromHack();
            this.ensureSelection();
        }

        public void reloadFromHack() {
            MultiSelectEntryListWidget.SelectionState prev = this.captureState();
            this.method_25339();
            List<ItemHandlerHack.GroundItem> raw = this.hack.getTrackedItems().stream().filter(g -> g.distance() <= this.hack.getPopupRange()).toList();
            LinkedHashMap<Object, Aggregated> groups = new LinkedHashMap<Object, Aggregated>();
            int syntheticIndex = 0;
            for (ItemHandlerHack.GroundItem gi : raw) {
                String baseId = ItemUtils.getStackId(gi.stack());
                if (baseId == null) {
                    baseId = class_7923.field_41178.method_10221((Object)gi.stack().method_7909()).toString();
                }
                boolean isXp = false;
                int xpAmount = -1;
                try {
                    if (ItemUtils.isSyntheticXp(gi.stack())) {
                        isXp = true;
                        xpAmount = ItemUtils.getXpAmount(gi.stack());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!isXp) {
                    Aggregated a2 = (Aggregated)groups.get(baseId);
                    if (a2 == null) {
                        a2 = new Aggregated(baseId, baseId, gi.stack().method_7972());
                        groups.put(baseId, a2);
                    }
                    a2.add(gi);
                    continue;
                }
                Aggregated match = null;
                for (Aggregated a3 : groups.values()) {
                    if (!a3.itemId.equals(baseId)) continue;
                    int repXp = -1;
                    if (!a3.items.isEmpty()) {
                        repXp = ItemUtils.getXpAmount(a3.items.get(0).stack());
                    }
                    if (repXp != xpAmount) continue;
                    boolean close = false;
                    for (ItemHandlerHack.GroundItem existing : a3.items) {
                        if (!(existing.position().method_1022(gi.position()) <= 5.0)) continue;
                        close = true;
                        break;
                    }
                    if (!close) continue;
                    match = a3;
                    break;
                }
                if (match != null) {
                    match.add(gi);
                    continue;
                }
                String key = baseId + ":xp:" + xpAmount + ":" + syntheticIndex++;
                String selId = baseId + ":xp:" + xpAmount;
                Aggregated a4 = new Aggregated(baseId, selId, gi.stack().method_7972());
                groups.put(key, a4);
                a4.add(gi);
            }
            groups.values().stream().sorted(Comparator.comparingDouble(Aggregated::closestDistance)).map(a -> new Entry(this, (Aggregated)a)).forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
            if (prev != null) {
                this.restoreState(prev);
            } else {
                this.ensureSelection();
            }
        }

        @Override
        protected String getSelectionKey(Entry entry) {
            return entry.selectionKey();
        }

        private static final class Aggregated {
            final String itemId;
            final String selectionId;
            final class_1799 rep;
            final List<ItemHandlerHack.GroundItem> items = new ArrayList<ItemHandlerHack.GroundItem>();
            int total;
            double closest = Double.MAX_VALUE;

            Aggregated(String itemId, String selectionId, class_1799 rep) {
                this.itemId = itemId;
                this.selectionId = selectionId;
                this.rep = rep;
                this.total = 0;
            }

            void add(ItemHandlerHack.GroundItem gi) {
                this.items.add(gi);
                this.total += gi.stack().method_7947();
                if (gi.distance() < this.closest) {
                    this.closest = gi.distance();
                }
            }

            double closestDistance() {
                return this.closest;
            }
        }

        private final class Entry
        extends MultiSelectEntryListWidget.Entry<Entry> {
            private final ListGui parent;
            private final Aggregated group;

            Entry(ListGui parent, Aggregated group) {
                super(parent);
                this.parent = parent;
                this.group = group;
            }

            @Override
            public String selectionKey() {
                return this.group.selectionId != null ? this.group.selectionId : this.group.itemId;
            }

            public class_2561 method_37006() {
                String name = this.group.rep.method_7964().getString();
                return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{name + " x" + this.group.total});
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                String traceId;
                int contentX = x + 1;
                int contentY = y + 1;
                RenderUtils.drawItem(context, this.group.rep, contentX, contentY, true);
                class_327 tr = ((ListGui)ListGui.this).field_22740.field_1772;
                context.method_51433(tr, this.group.rep.method_7964().getString(), contentX + 36, contentY + 2, -1, false);
                String regId = ItemUtils.getStackId(this.group.rep);
                if (regId == null) {
                    regId = class_7923.field_41178.method_10221((Object)this.group.rep.method_7909()).toString();
                }
                context.method_51433(tr, regId, contentX + 36, contentY + 12, -7303024, false);
                String dist = (int)Math.round(this.group.closest) + " blocks";
                int distX = contentX + this.parent.method_25322() - (int)Math.round((double)tr.method_1727(dist) * 0.9) - 4;
                RenderUtils.drawScaledText(context, tr, dist, distX, contentY + 2, -4473925, false, 0.9);
                String cnt = String.valueOf(this.group.total);
                int iconX = contentX;
                int iconY = contentY;
                int cW = tr.method_1727(cnt);
                int textX = iconX + 24 - cW + 2;
                int textY = iconY + 24 - 4;
                context.method_51433(tr, cnt, textX + 1, textY + 1, -16777216, false);
                context.method_51433(tr, cnt, textX, textY, -1, false);
                String string = traceId = this.group.selectionId != null ? this.group.selectionId : this.group.itemId;
                if (ListGui.this.hack.isTraced(traceId)) {
                    float[] r = RenderUtils.getRainbowColor();
                    int col = RenderUtils.toIntColor(r, 1.0f);
                    RenderUtils.drawBorder2D(context, iconX - 1, iconY - 1, iconX + 25, iconY + 25, col);
                    RenderUtils.drawBorder2D(context, iconX, iconY, iconX + 24, iconY + 24, col);
                    context.method_51433(tr, "TRACED", contentX + 36, contentY + 22, -11141291, false);
                }
            }

            List<Integer> entityIds() {
                return this.group.items.stream().map(g -> g.entityId()).collect(Collectors.toList());
            }

            List<ItemHandlerHack.GroundItem> groundItems() {
                return this.group.items;
            }
        }
    }
}

