/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.hud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.wurstclient.WurstClient;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.other_features.HackListOtf;
import net.wurstclient.ui.UiScale;
import net.wurstclient.util.RenderUtils;

public final class HackListHUD
implements UpdateListener {
    private final ArrayList<HackListEntry> activeHax = new ArrayList();
    private final HackListOtf otf;
    private int posY;
    private int textColor;
    private boolean usePerHackColors;

    public HackListHUD() {
        this.otf = WurstClient.INSTANCE.getOtfs().hackListOtf;
        WurstClient.INSTANCE.getEventManager().add(UpdateListener.class, this);
    }

    public void render(class_332 context, float partialTicks) {
        if (this.otf.getMode() == HackListOtf.Mode.HIDDEN) {
            return;
        }
        boolean isBottom = this.otf.getPosition() == HackListOtf.Position.BOTTOM_LEFT || this.otf.getPosition() == HackListOtf.Position.BOTTOM_RIGHT;
        int lineHeight = (int)Math.round(9.0 * this.getScale() * this.otf.getFontSize());
        int spacing = this.otf.getEntrySpacing();
        int count = this.activeHax.size();
        int height = count == 0 ? 0 : count * lineHeight + Math.max(0, count - 1) * spacing;
        int baseY = isBottom ? context.method_51443() - height - 2 : 2;
        boolean isLeft = this.otf.getPosition() == HackListOtf.Position.TOP_LEFT || this.otf.getPosition() == HackListOtf.Position.BOTTOM_LEFT;
        this.posY = isLeft && WurstClient.INSTANCE.getOtfs().wurstLogoOtf.isVisible() ? Math.max(baseY, 22) : baseY;
        boolean rainbowUi = WurstClient.INSTANCE.getHax().rainbowUiHack.isEnabled();
        if (rainbowUi) {
            float[] acColor = WurstClient.INSTANCE.getGui().getAcColor();
            this.textColor = 0x4000000 | (int)(acColor[0] * 255.0f) << 16 | (int)(acColor[1] * 255.0f) << 8 | (int)(acColor[2] * 255.0f);
        } else {
            this.textColor = this.otf.getColor(4);
        }
        this.usePerHackColors = this.otf.useHackColors() && !rainbowUi;
        int totalHeight = height + this.posY;
        if (this.otf.getMode() == HackListOtf.Mode.COUNT || totalHeight > context.method_51443()) {
            this.drawCounter(context);
        } else {
            this.drawHackList(context, partialTicks, lineHeight, spacing);
        }
    }

    private void drawCounter(class_332 context) {
        long size;
        String s = size + " hack" + ((size = this.activeHax.stream().filter(e -> e.hack.isEnabled()).count()) != 1L ? "s" : "") + " active";
        this.drawString(context, s, (int)Math.round(9.0 * this.getScale() * this.otf.getFontSize()), 0);
    }

    private void drawHackList(class_332 context, float partialTicks, int lineHeight, int spacing) {
        if (this.otf.isAnimations()) {
            for (HackListEntry e : this.activeHax) {
                this.drawWithOffset(context, e, partialTicks, lineHeight, spacing);
            }
        } else {
            for (HackListEntry e : this.activeHax) {
                this.drawString(context, e.hack, e.hack.getRenderName(), lineHeight, spacing);
            }
        }
    }

    public void updateState(Hack hack) {
        int offset = this.otf.isAnimations() ? 4 : 0;
        HackListEntry entry = new HackListEntry(hack, offset);
        if (hack.isEnabled()) {
            if (this.activeHax.contains(entry)) {
                return;
            }
            this.activeHax.add(entry);
            this.sort();
        } else if (!this.otf.isAnimations()) {
            this.activeHax.remove(entry);
        }
    }

    private void sort() {
        Comparator<HackListEntry> comparator = Comparator.comparing(hle -> hle.hack, this.otf.getComparator());
        Collections.sort(this.activeHax, comparator);
    }

    @Override
    public void onUpdate() {
        if (this.otf.shouldSort()) {
            this.sort();
        }
        if (!this.otf.isAnimations()) {
            return;
        }
        Iterator<HackListEntry> itr = this.activeHax.iterator();
        while (itr.hasNext()) {
            HackListEntry e = itr.next();
            boolean enabled = e.hack.isEnabled();
            e.prevOffset = e.offset;
            if (enabled && e.offset > 0) {
                --e.offset;
                continue;
            }
            if (!enabled && e.offset < 4) {
                ++e.offset;
                continue;
            }
            if (enabled || e.offset < 4) continue;
            itr.remove();
        }
    }

    private void drawString(class_332 context, String s, int lineHeight, int spacing) {
        int posX;
        boolean isLeft;
        class_327 tr = WurstClient.MC.field_1772;
        int yDraw = this.posY + this.otf.getYOffset();
        double scale = this.getScale() * this.otf.getFontSize();
        int stringWidth = (int)((double)tr.method_1727(s) * scale);
        boolean bl = isLeft = this.otf.getPosition() == HackListOtf.Position.TOP_LEFT || this.otf.getPosition() == HackListOtf.Position.BOTTOM_LEFT;
        if (isLeft) {
            posX = 2 + this.otf.getXOffset();
        } else {
            int screenWidth = context.method_51421();
            posX = screenWidth - stringWidth - 2 + this.otf.getXOffset();
        }
        int alpha = (int)(this.otf.getTransparency() * 255.0) << 24;
        double eps = 1.0E-6;
        int baseSX = (int)Math.round((double)posX / scale + eps);
        int baseSY = (int)Math.round((double)yDraw / scale + eps);
        int mainX = (int)Math.round((double)baseSX * scale);
        int mainY = (int)Math.round((double)baseSY * scale);
        int shadowX = (int)Math.round((double)(baseSX + 1) * scale);
        int shadowY = (int)Math.round((double)(baseSY + 1) * scale);
        int lineColor = this.textColor;
        if (WurstClient.INSTANCE.getOtfs().hackListOtf.useShadowBox()) {
            int pad = (int)Math.max(1L, Math.round(2.0 * scale));
            int boxX1 = mainX - pad;
            int boxY1 = mainY;
            int boxX2 = mainX + stringWidth + pad;
            int boxY2 = mainY + lineHeight;
            int fillAlpha = (int)(WurstClient.INSTANCE.getOtfs().hackListOtf.getShadowBoxAlpha() * this.otf.getTransparency() * 255.0);
            int boxColor = fillAlpha << 24;
            context.method_25294(boxX1, boxY1, boxX2, boxY2, boxColor);
        } else {
            RenderUtils.drawScaledText(context, tr, s, shadowX, shadowY, 0x4000000 | alpha, false, scale);
        }
        context.field_59826.method_71067();
        RenderUtils.drawScaledText(context, tr, s, mainX, mainY, lineColor | alpha, false, scale);
        this.posY += lineHeight + spacing;
    }

    private void drawString(class_332 context, Hack hack, String s, int lineHeight, int spacing) {
        int c;
        int posX;
        boolean isLeft;
        class_327 tr = WurstClient.MC.field_1772;
        int yDraw = this.posY + this.otf.getYOffset();
        double scale = this.getScale() * this.otf.getFontSize();
        int stringWidth = (int)((double)tr.method_1727(s) * scale);
        boolean bl = isLeft = this.otf.getPosition() == HackListOtf.Position.TOP_LEFT || this.otf.getPosition() == HackListOtf.Position.BOTTOM_LEFT;
        if (isLeft) {
            posX = 2 + this.otf.getXOffset();
        } else {
            int screenWidth = context.method_51421();
            posX = screenWidth - stringWidth - 2 + this.otf.getXOffset();
        }
        int alpha = (int)(this.otf.getTransparency() * 255.0) << 24;
        double eps = 1.0E-6;
        int baseSX = (int)Math.round((double)posX / scale + eps);
        int baseSY = (int)Math.round((double)yDraw / scale + eps);
        int mainX = (int)Math.round((double)baseSX * scale);
        int mainY = (int)Math.round((double)baseSY * scale);
        int shadowX = (int)Math.round((double)(baseSX + 1) * scale);
        int shadowY = (int)Math.round((double)(baseSY + 1) * scale);
        int lineColor = this.textColor;
        if (this.usePerHackColors && (c = hack.getHackListColorI(4)) != -1) {
            lineColor = c;
        }
        if (WurstClient.INSTANCE.getOtfs().hackListOtf.useShadowBox()) {
            int pad = (int)Math.max(1L, Math.round(2.0 * scale));
            int boxX1 = mainX - pad;
            int boxY1 = mainY;
            int boxX2 = mainX + stringWidth + pad;
            int boxY2 = mainY + lineHeight;
            int fillAlpha = (int)(WurstClient.INSTANCE.getOtfs().hackListOtf.getShadowBoxAlpha() * this.otf.getTransparency() * 255.0);
            int boxColor = fillAlpha << 24;
            context.method_25294(boxX1, boxY1, boxX2, boxY2, boxColor);
        } else {
            RenderUtils.drawScaledText(context, tr, s, shadowX, shadowY, 0x4000000 | alpha, false, scale);
        }
        context.field_59826.method_71067();
        RenderUtils.drawScaledText(context, tr, s, mainX, mainY, lineColor | alpha, false, scale);
        this.posY += lineHeight + spacing;
    }

    private void drawWithOffset(class_332 context, HackListEntry e, float partialTicks, int lineHeight, int spacing) {
        int c;
        float posX;
        boolean isLeft;
        class_327 tr = WurstClient.MC.field_1772;
        String s = e.hack.getRenderName();
        float offset = (float)e.offset * partialTicks + (float)e.prevOffset * (1.0f - partialTicks);
        double scale = this.getScale() * this.otf.getFontSize();
        int stringWidth = (int)((double)tr.method_1727(s) * scale);
        boolean bl = isLeft = this.otf.getPosition() == HackListOtf.Position.TOP_LEFT || this.otf.getPosition() == HackListOtf.Position.BOTTOM_LEFT;
        if (isLeft) {
            posX = 2 - (int)((double)(5.0f * offset) * scale) + this.otf.getXOffset();
        } else {
            int screenWidth = context.method_51421();
            posX = screenWidth - stringWidth - 2 + (int)((double)(5.0f * offset) * scale) + this.otf.getXOffset();
        }
        int yDraw = this.posY + this.otf.getYOffset();
        int alpha = (int)((double)(255.0f * (1.0f - offset / 4.0f)) * this.otf.getTransparency()) << 24;
        double eps2 = 1.0E-6;
        int baseSX2 = (int)Math.round((double)posX / scale + eps2);
        int baseSY2 = (int)Math.round((double)yDraw / scale + eps2);
        int mainX2 = (int)Math.round((double)baseSX2 * scale);
        int mainY2 = (int)Math.round((double)baseSY2 * scale);
        int shadowX2 = (int)Math.round((double)(baseSX2 + 1) * scale);
        int shadowY2 = (int)Math.round((double)(baseSY2 + 1) * scale);
        int lineColor = this.textColor;
        if (this.usePerHackColors && (c = e.hack.getHackListColorI(4)) != -1) {
            lineColor = c;
        }
        if (WurstClient.INSTANCE.getOtfs().hackListOtf.useShadowBox()) {
            int pad2 = (int)Math.max(1L, Math.round(2.0 * scale));
            int boxX12 = mainX2 - pad2;
            int boxY12 = mainY2;
            int boxX22 = mainX2 + stringWidth + pad2;
            int boxY22 = mainY2 + lineHeight;
            int fillAlpha2 = (int)(WurstClient.INSTANCE.getOtfs().hackListOtf.getShadowBoxAlpha() * this.otf.getTransparency() * 255.0);
            int boxColor2 = fillAlpha2 << 24;
            context.method_25294(boxX12, boxY12, boxX22, boxY22, boxColor2);
        } else {
            RenderUtils.drawScaledText(context, tr, s, shadowX2, shadowY2, 0x4000000 | alpha, false, scale);
        }
        context.field_59826.method_71067();
        RenderUtils.drawScaledText(context, tr, s, mainX2, mainY2, lineColor | alpha, false, scale);
        this.posY += lineHeight + spacing;
    }

    private double getScale() {
        return UiScale.OVERRIDE_SCALE != 1.0 ? UiScale.OVERRIDE_SCALE : UiScale.getScale();
    }

    private static final class HackListEntry {
        private final Hack hack;
        private int offset;
        private int prevOffset;

        public HackListEntry(Hack mod, int offset) {
            this.hack = mod;
            this.offset = offset;
            this.prevOffset = offset;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HackListEntry)) {
                return false;
            }
            HackListEntry other = (HackListEntry)obj;
            return this.hack == other.hack;
        }

        public int hashCode() {
            return this.hack.hashCode();
        }
    }
}

