/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.keybinds;

import java.util.Locale;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.ClickGui;
import net.wurstclient.clickgui.screens.ClickGuiScreen;
import net.wurstclient.clickgui.screens.WaypointsScreen;
import net.wurstclient.command.CmdProcessor;
import net.wurstclient.events.KeyPressListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hack.HackList;
import net.wurstclient.hacks.itemhandler.ItemHandlerScreen;
import net.wurstclient.keybinds.KeybindList;
import net.wurstclient.navigator.NavigatorMainScreen;
import net.wurstclient.util.ChatUtils;

public final class KeybindProcessor
implements KeyPressListener {
    private final HackList hax;
    private final KeybindList keybinds;
    private final CmdProcessor cmdProcessor;

    public KeybindProcessor(HackList hax, KeybindList keybinds, CmdProcessor cmdProcessor) {
        this.hax = hax;
        this.keybinds = keybinds;
        this.cmdProcessor = cmdProcessor;
    }

    @Override
    public void onKeyPress(KeyPressListener.KeyPressEvent event) {
        String keyName;
        String cmds;
        if (event.getAction() != 1) {
            return;
        }
        if (class_3675.method_15987((long)WurstClient.MC.method_22683().method_4490(), (int)292)) {
            return;
        }
        class_437 screen = WurstClient.MC.field_1755;
        if (!(screen == null || screen instanceof ClickGuiScreen || screen instanceof WaypointsScreen || screen instanceof ItemHandlerScreen)) {
            return;
        }
        if (screen instanceof ClickGuiScreen) {
            ClickGui gui = WurstClient.INSTANCE.getGui();
            if (gui != null && gui.isKeyboardInputCaptured()) {
                return;
            }
            String ch = this.mapPrintableChar(event.getKeyCode(), event.getModifiers());
            if (ch != null) {
                WurstClient.MC.method_1507((class_437)new NavigatorMainScreen());
                return;
            }
        }
        if ((cmds = this.keybinds.getCommands(keyName = this.getKeyName(event))) == null) {
            return;
        }
        this.processCmds(cmds);
    }

    private String mapPrintableChar(int keyCode, int modifiers) {
        if (keyCode >= 65 && keyCode <= 90) {
            char c = (char)(97 + (keyCode - 65));
            return String.valueOf(c);
        }
        if (keyCode >= 48 && keyCode <= 57) {
            char c = (char)(48 + (keyCode - 48));
            return String.valueOf(c);
        }
        if (keyCode == 32) {
            return " ";
        }
        return null;
    }

    private String getKeyName(KeyPressListener.KeyPressEvent event) {
        int keyCode = event.getKeyCode();
        int scanCode = event.getScanCode();
        return class_3675.method_15985((int)keyCode, (int)scanCode).method_1441();
    }

    private void processCmds(String cmds) {
        cmds = cmds.replace(";", "\u00a7").replace("\u00a7\u00a7", ";");
        for (String cmd : cmds.split("\u00a7")) {
            this.processCmd(cmd.trim());
        }
    }

    private void processCmd(String cmd) {
        String trimmed = cmd.trim();
        if (trimmed.equalsIgnoreCase(".waypoints")) {
            if (class_310.method_1551().field_1755 instanceof WaypointsScreen) {
                class_310.method_1551().method_1507(null);
                return;
            }
            WurstClient.INSTANCE.getHax().waypointsHack.openManager();
            return;
        }
        if (cmd.startsWith(".")) {
            this.cmdProcessor.process(cmd.substring(1));
        } else if (cmd.contains(" ")) {
            String lower = cmd.toLowerCase(Locale.ROOT).trim();
            if (lower.equals("itemhandler gui")) {
                class_437 s = class_310.method_1551().field_1755;
                if (s instanceof ItemHandlerScreen) {
                    class_310.method_1551().method_1507(null);
                    return;
                }
                WurstClient.INSTANCE.getHax().itemHandlerHack.openScreen();
                return;
            }
            this.cmdProcessor.process(cmd);
        } else {
            Hack hack = this.hax.getHackByName(cmd);
            if (hack == null) {
                this.cmdProcessor.process(cmd);
                return;
            }
            if (!hack.isEnabled() && this.hax.tooManyHaxHack.isEnabled() && this.hax.tooManyHaxHack.isBlocked(hack)) {
                ChatUtils.error(hack.getName() + " is blocked by TooManyHax.");
                return;
            }
            hack.setEnabled(!hack.isEnabled());
        }
    }
}

