/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.mixin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_3544;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_419;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8021;
import net.minecraft.class_8667;
import net.minecraft.class_9812;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.screens.ClickGuiScreen;
import net.wurstclient.hacks.AutoReconnectHack;
import net.wurstclient.hacks.OfflineSettingsHack;
import net.wurstclient.mixinterface.LoginOverlayAccessor;
import net.wurstclient.navigator.NavigatorListScreen;
import net.wurstclient.nochatreports.ForcedChatReportsScreen;
import net.wurstclient.nochatreports.NcrModRequiredScreen;
import net.wurstclient.options.EnterProfileNameScreen;
import net.wurstclient.util.LastServerRememberer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_419.class}, remap=false)
public class DisconnectedScreenMixin
extends class_437
implements LoginOverlayAccessor {
    private int autoReconnectTimer;
    private class_4185 autoReconnectButton;
    private boolean showLoginOverlay;
    private class_4185 overlayAutoButton;
    private class_4185 overlayRandomButton;
    private class_4185 overlayRejoinButton;
    private class_4185 overlayPickPlayerButton;
    private class_4185 overlayCommandButton;
    private OfflineSettingsHack overlayHack;
    private String overlayReasonText;
    private class_2561 overlayReasonComponent;
    private List<class_5481> overlayLines = Collections.emptyList();
    private int overlayWidth;
    private int overlayHeight;
    private int overlayX;
    private int overlayY;
    private class_4185 reconnectButton;
    @Shadow
    @Final
    private class_9812 field_52131;
    @Shadow
    @Final
    @Mutable
    private class_437 field_2456;
    @Shadow
    @Final
    private class_8667 field_44552;

    private void ensureValidParent() {
        if (this.field_2456 != null && !(this.field_2456 instanceof ClickGuiScreen)) {
            return;
        }
        this.field_2456 = new class_500((class_437)new class_442());
    }

    private DisconnectedScreenMixin(WurstClient wurst, class_2561 title) {
        super(title);
    }

    @Inject(at={@At(value="TAIL")}, method={"method_25426()V"})
    private void onInit(CallbackInfo ci) {
        if (!WurstClient.INSTANCE.isEnabled()) {
            return;
        }
        class_2561 reason = this.field_52131.comp_2853();
        System.out.println("Disconnected: " + String.valueOf(reason));
        if (ForcedChatReportsScreen.isCausedByNoChatReports(reason)) {
            this.field_22787.method_1507((class_437)new ForcedChatReportsScreen(this.field_2456));
            return;
        }
        if (NcrModRequiredScreen.isCausedByLackOfNCR(reason)) {
            this.field_22787.method_1507((class_437)new NcrModRequiredScreen(this.field_2456));
            return;
        }
        this.addReconnectButtons(reason);
    }

    private void addReconnectButtons(class_2561 reason) {
        Object posString;
        this.ensureValidParent();
        OfflineSettingsHack offlineSettingsHack = WurstClient.INSTANCE.getHax().offlineSettingsHack;
        this.reconnectButton = (class_4185)this.field_44552.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reconnect"), b -> LastServerRememberer.reconnect(this.field_2456)).method_46432(200).method_46431());
        this.autoReconnectButton = (class_4185)this.field_44552.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)"AutoReconnect"), b -> this.pressAutoReconnect()).method_46432(200).method_46431());
        if (this.field_22787.field_1724 != null) {
            class_2338 ppos = this.field_22787.field_1724.method_24515();
            posString = ppos.method_10263() + ", " + ppos.method_10264() + ", " + ppos.method_10260();
        } else {
            posString = "Unknown";
        }
        class_4185 copyLocButton = (class_4185)this.field_44552.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Copy location: " + (String)posString)), arg_0 -> this.lambda$addReconnectButtons$2((String)posString, arg_0)).method_46432(200).method_46431());
        this.field_44552.method_48222();
        Stream.of(this.reconnectButton, this.autoReconnectButton, copyLocButton).filter(Objects::nonNull).forEach(x$0 -> {
            class_4185 cfr_ignored_0 = (class_4185)this.method_37063((class_364)x$0);
        });
        offlineSettingsHack.handleDisconnect(reason);
        boolean loginElsewhere = DisconnectedScreenMixin.isLoginElsewhere(reason);
        boolean crackedServer = offlineSettingsHack.wasLastServerCracked();
        if (loginElsewhere || crackedServer) {
            class_2561 overlayReason = reason;
            if (overlayReason == null) {
                overlayReason = class_2561.method_43470((String)(crackedServer ? "Cracked server detected" : "Disconnected"));
            }
            this.showLoginOverlay(offlineSettingsHack, overlayReason);
            if (loginElsewhere && offlineSettingsHack.consumeAutoReconnectRequest()) {
                offlineSettingsHack.performAutoReconnect(this.field_2456);
            }
        } else {
            this.hideLoginOverlay();
        }
        AutoReconnectHack autoReconnect = WurstClient.INSTANCE.getHax().autoReconnectHack;
        if (autoReconnect.isEnabled()) {
            this.autoReconnectTimer = autoReconnect.getWaitTicks();
        }
    }

    private void pressAutoReconnect() {
        AutoReconnectHack autoReconnect;
        autoReconnect.setEnabled(!(autoReconnect = WurstClient.INSTANCE.getHax().autoReconnectHack).isEnabled());
        if (autoReconnect.isEnabled()) {
            this.autoReconnectTimer = autoReconnect.getWaitTicks();
        }
    }

    private void layoutOverlay() {
        int buttonX;
        if (!this.showLoginOverlay || this.overlayReasonText == null) {
            return;
        }
        class_327 font = this.field_22787.field_1772;
        int maxWidth = Math.min(this.field_22789 - 40, 360);
        this.overlayLines = font.method_1728((class_5348)class_2561.method_43470((String)this.overlayReasonText), maxWidth - 20);
        int textWidth = this.overlayLines.stream().mapToInt(arg_0 -> ((class_327)font).method_30880(arg_0)).max().orElse(font.method_27525((class_5348)class_2561.method_43470((String)this.overlayReasonText)));
        this.overlayWidth = Math.max(textWidth + 20, 260);
        this.overlayWidth = Math.min(this.overlayWidth, this.field_22789 - 40);
        int padding = 10;
        int n = this.overlayLines.size();
        Objects.requireNonNull(font);
        int textHeight = n * (9 + 2);
        int buttonSpacing = 6;
        int buttonHeightSum = 0;
        int buttonCount = 0;
        if (this.overlayAutoButton != null && this.overlayAutoButton.field_22764) {
            buttonHeightSum += this.overlayAutoButton.method_25364();
            ++buttonCount;
        }
        if (this.overlayRejoinButton != null && this.overlayRejoinButton.field_22764) {
            buttonHeightSum += this.overlayRejoinButton.method_25364();
            ++buttonCount;
        }
        if (this.overlayRandomButton != null && this.overlayRandomButton.field_22764) {
            buttonHeightSum += this.overlayRandomButton.method_25364();
            ++buttonCount;
        }
        if (this.overlayCommandButton != null && this.overlayCommandButton.field_22764) {
            buttonHeightSum += this.overlayCommandButton.method_25364();
            ++buttonCount;
        }
        if (this.overlayPickPlayerButton != null && this.overlayPickPlayerButton.field_22764) {
            buttonHeightSum += this.overlayPickPlayerButton.method_25364();
            ++buttonCount;
        }
        int totalButtonSpacing = Math.max(0, buttonCount - 1) * buttonSpacing;
        int textButtonGap = this.overlayLines.isEmpty() ? 0 : 8;
        this.overlayHeight = padding + textHeight + textButtonGap + buttonHeightSum + totalButtonSpacing + padding;
        if (this.overlayHeight < padding * 2 + 20) {
            this.overlayHeight = padding * 2 + 20;
        }
        this.overlayX = (this.field_22789 - this.overlayWidth) / 2;
        this.overlayY = 30;
        if (this.overlayY + this.overlayHeight > this.field_22790 - 20) {
            this.overlayY = Math.max(20, this.field_22790 - this.overlayHeight - 20);
        }
        int currentY = this.overlayY + padding + textHeight;
        if (!this.overlayLines.isEmpty()) {
            currentY += textButtonGap;
        }
        int placedButtons = 0;
        if (this.overlayAutoButton != null && this.overlayAutoButton.field_22764) {
            buttonX = this.overlayX + (this.overlayWidth - this.overlayAutoButton.method_25368()) / 2;
            this.overlayAutoButton.method_48229(buttonX, currentY);
            currentY += this.overlayAutoButton.method_25364();
            if (++placedButtons < buttonCount) {
                currentY += buttonSpacing;
            }
        }
        if (this.overlayRejoinButton != null && this.overlayRejoinButton.field_22764) {
            buttonX = this.overlayX + (this.overlayWidth - this.overlayRejoinButton.method_25368()) / 2;
            this.overlayRejoinButton.method_48229(buttonX, currentY);
            currentY += this.overlayRejoinButton.method_25364();
            if (++placedButtons < buttonCount) {
                currentY += buttonSpacing;
            }
        }
        if (this.overlayRandomButton != null && this.overlayRandomButton.field_22764) {
            buttonX = this.overlayX + (this.overlayWidth - this.overlayRandomButton.method_25368()) / 2;
            this.overlayRandomButton.method_48229(buttonX, currentY);
            currentY += this.overlayRandomButton.method_25364();
            if (++placedButtons < buttonCount) {
                currentY += buttonSpacing;
            }
        }
        if (this.overlayCommandButton != null && this.overlayCommandButton.field_22764) {
            buttonX = this.overlayX + (this.overlayWidth - this.overlayCommandButton.method_25368()) / 2;
            this.overlayCommandButton.method_48229(buttonX, currentY);
            currentY += this.overlayCommandButton.method_25364();
            if (++placedButtons < buttonCount) {
                currentY += buttonSpacing;
            }
        }
        if (this.overlayPickPlayerButton != null && this.overlayPickPlayerButton.field_22764) {
            buttonX = this.overlayX + (this.overlayWidth - this.overlayPickPlayerButton.method_25368()) / 2;
            this.overlayPickPlayerButton.method_48229(buttonX, currentY);
            currentY += this.overlayPickPlayerButton.method_25364();
            if (++placedButtons < buttonCount) {
                currentY += buttonSpacing;
            }
        }
    }

    @Override
    public boolean isLoginOverlayVisible() {
        return this.showLoginOverlay;
    }

    @Override
    public List<class_5481> getOverlayLines() {
        return this.overlayLines;
    }

    @Override
    public int getOverlayWidth() {
        return this.overlayWidth;
    }

    @Override
    public int getOverlayHeight() {
        return this.overlayHeight;
    }

    @Override
    public int getOverlayX() {
        return this.overlayX;
    }

    @Override
    public int getOverlayY() {
        return this.overlayY;
    }

    @Override
    public void layoutLoginOverlay(class_327 font, int width, int height) {
        this.layoutOverlay();
    }

    private class_4185 createOverlayButton(class_2561 text, Runnable action, int width) {
        return class_4185.method_46430((class_2561)text, b -> action.run()).method_46432(width).method_46431();
    }

    private void ensureOverlayButtons(OfflineSettingsHack hack) {
        this.overlayHack = hack;
        if (this.overlayRandomButton == null) {
            this.overlayRandomButton = this.createOverlayButton((class_2561)class_2561.method_43470((String)"Reconnect as random user"), () -> {
                this.hideLoginOverlay();
                hack.reconnectWithRandomName(this.field_2456);
            }, 220);
            this.overlayRandomButton.field_22764 = false;
            this.method_37063((class_364)this.overlayRandomButton);
        }
        if (this.overlayRejoinButton == null) {
            this.overlayRejoinButton = this.createOverlayButton((class_2561)class_2561.method_43470((String)"Reconnect with selected name"), () -> this.promptReconnectWithCustomName(hack), 220);
            this.overlayRejoinButton.field_22764 = false;
            this.method_37063((class_364)this.overlayRejoinButton);
        }
        if (this.overlayAutoButton == null) {
            this.overlayAutoButton = this.createOverlayButton(this.getAutoReconnectLabel(), this::toggleAutoReconnect, 200);
            this.overlayAutoButton.field_22764 = false;
            this.method_37063((class_364)this.overlayAutoButton);
        } else {
            this.overlayAutoButton.method_25355(this.getAutoReconnectLabel());
        }
        if (this.overlayCommandButton == null) {
            this.overlayCommandButton = this.createOverlayButton((class_2561)class_2561.method_43470((String)"Reconnect & run command"), () -> this.showReconnectCommandPrompt(hack), 220);
            this.overlayCommandButton.field_22764 = false;
            this.method_37063((class_364)this.overlayCommandButton);
        }
        if (this.overlayPickPlayerButton == null) {
            this.overlayPickPlayerButton = this.createOverlayButton((class_2561)class_2561.method_43470((String)"Reconnect as specific player"), () -> this.showPlayerPicker(hack), 220);
            this.overlayPickPlayerButton.field_22764 = false;
            this.method_37063((class_364)this.overlayPickPlayerButton);
        }
    }

    private void toggleAutoReconnect() {
        if (this.overlayHack == null) {
            return;
        }
        boolean enabled = !this.overlayHack.isAutoReconnectEnabled();
        this.overlayHack.setAutoReconnectEnabled(enabled);
        if (this.overlayAutoButton != null) {
            this.overlayAutoButton.method_25355(this.getAutoReconnectLabel());
        }
        if (enabled) {
            this.hideLoginOverlay();
            this.overlayHack.reconnectWithSelectedName(this.field_2456);
        }
    }

    private class_2561 getAutoReconnectLabel() {
        boolean enabled = this.overlayHack != null && this.overlayHack.isAutoReconnectEnabled();
        String text = enabled ? "AutoReconnect ON" : "AutoReconnect OFF";
        return class_2561.method_43470((String)text).method_27694(style -> style.method_27703(enabled ? class_5251.method_27717((int)65280) : class_5251.method_27717((int)0xFF0000)));
    }

    private void showLoginOverlay(OfflineSettingsHack hack, class_2561 reason) {
        this.showLoginOverlay = true;
        this.overlayReasonText = class_3544.method_15440((String)reason.getString());
        this.overlayReasonComponent = reason;
        this.overlayLines = Collections.emptyList();
        this.ensureOverlayButtons(hack);
        this.overlayRandomButton.field_22764 = true;
        if (this.overlayAutoButton != null) {
            this.overlayAutoButton.field_22764 = true;
            this.overlayAutoButton.method_25355(this.getAutoReconnectLabel());
        }
        if (this.overlayRejoinButton != null) {
            this.overlayRejoinButton.field_22764 = true;
        }
        if (this.overlayPickPlayerButton != null) {
            this.overlayPickPlayerButton.field_22764 = true;
        }
        if (this.overlayCommandButton != null) {
            this.overlayCommandButton.field_22764 = true;
        }
        this.layoutOverlay();
    }

    private void hideLoginOverlay() {
        this.showLoginOverlay = false;
        if (this.overlayRandomButton != null) {
            this.overlayRandomButton.field_22764 = false;
        }
        if (this.overlayRejoinButton != null) {
            this.overlayRejoinButton.field_22764 = false;
        }
        if (this.overlayPickPlayerButton != null) {
            this.overlayPickPlayerButton.field_22764 = false;
        }
        if (this.overlayAutoButton != null) {
            this.overlayAutoButton.field_22764 = false;
        }
        if (this.overlayCommandButton != null) {
            this.overlayCommandButton.field_22764 = false;
        }
        this.overlayReasonText = null;
        this.overlayLines = Collections.emptyList();
    }

    private static boolean isLoginElsewhere(class_2561 reason) {
        if (reason == null) {
            return false;
        }
        String text = class_3544.method_15440((String)reason.getString());
        return "You logged in from another location".equals(text);
    }

    private void promptReconnectWithCustomName(OfflineSettingsHack hack) {
        if (this.field_22787 == null || hack == null) {
            return;
        }
        class_437 returnScreen = this;
        this.field_22787.method_1507((class_437)new EnterProfileNameScreen(returnScreen, input -> {
            if (input == null) {
                return;
            }
            String trimmed = input.trim();
            if (trimmed.isEmpty() || !OfflineSettingsHack.isValidOfflineNameFormat(trimmed)) {
                return;
            }
            this.hideLoginOverlay();
            hack.reconnectWithCustomName(trimmed, this.field_2456);
        }, (class_2561)class_2561.method_43470((String)"Enter offline name"), value -> {
            if (value == null) {
                return false;
            }
            String trimmed = value.trim();
            return !trimmed.isEmpty() && OfflineSettingsHack.isValidOfflineNameFormat(trimmed);
        }));
    }

    private void showPlayerPicker(OfflineSettingsHack hack) {
        if (this.field_22787 == null || hack == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        if (this.field_22787.field_1724 != null && this.field_22787.field_1724.field_3944 != null) {
            this.field_22787.field_1724.field_3944.method_2880().forEach(info -> {
                if (info == null || info.method_2966() == null || info.method_2966().getName() == null) {
                    return;
                }
                String name = info.method_2966().getName().trim();
                if (!name.isEmpty() && !names.contains(name)) {
                    names.add(name);
                }
            });
        }
        if (names.isEmpty()) {
            names.addAll(hack.getCapturedPlayerNames());
        }
        if (names.isEmpty()) {
            return;
        }
        class_2561 reason = this.overlayReasonComponent != null ? this.overlayReasonComponent : class_2561.method_43470((String)"Disconnected");
        Runnable restoreOverlay = () -> {
            if (this.overlayHack != null) {
                this.showLoginOverlay(this.overlayHack, reason);
            }
        };
        this.hideLoginOverlay();
        this.field_22787.method_1507((class_437)new NavigatorListScreen((class_2561)class_2561.method_43470((String)"Select player"), names, selected -> {
            if (selected != null && !selected.trim().isEmpty()) {
                hack.reconnectWithCustomName(selected.trim(), this.field_2456);
            }
        }, (player, command) -> {
            if (player == null || player.trim().isEmpty()) {
                return;
            }
            if (command == null || command.trim().isEmpty()) {
                return;
            }
            hack.queueReconnectCommand(command.trim());
            hack.reconnectWithCustomName(player.trim(), this.field_2456);
        }, this, restoreOverlay));
    }

    private void showReconnectCommandPrompt(OfflineSettingsHack hack) {
        if (this.field_22787 == null || hack == null) {
            return;
        }
        class_437 returnScreen = this;
        this.field_22787.method_1507((class_437)new EnterProfileNameScreen(returnScreen, input -> {
            if (input == null) {
                return;
            }
            String trimmed = input.trim();
            if (trimmed.isEmpty()) {
                return;
            }
            this.hideLoginOverlay();
            hack.queueReconnectCommand(trimmed);
            hack.reconnectWithSelectedName(this.field_2456);
        }, (class_2561)class_2561.method_43470((String)"Enter reconnect command"), value -> value != null && !value.trim().isEmpty()));
    }

    public void method_25393() {
        if (!WurstClient.INSTANCE.isEnabled() || this.autoReconnectButton == null) {
            return;
        }
        AutoReconnectHack autoReconnect = WurstClient.INSTANCE.getHax().autoReconnectHack;
        if (!autoReconnect.isEnabled()) {
            this.autoReconnectButton.method_25355((class_2561)class_2561.method_43470((String)"AutoReconnect"));
            return;
        }
        this.autoReconnectButton.method_25355((class_2561)class_2561.method_43470((String)("AutoReconnect (" + (int)Math.ceil((double)this.autoReconnectTimer / 20.0) + ")")));
        if (this.autoReconnectTimer > 0) {
            --this.autoReconnectTimer;
            return;
        }
        LastServerRememberer.reconnect(this.field_2456);
    }

    private /* synthetic */ void lambda$addReconnectButtons$2(String posString, class_4185 b) {
        this.field_22787.field_1774.method_1455(posString);
    }
}

