/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.mixin;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.class_11226;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public class InGameHudLocatorProbeMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"WurstLocator");
    private static long lastProbeLogMs = 0L;

    @Inject(method={"method_55804(Lnet/minecraft/class_332;Lnet/minecraft/class_9779;)V"}, at={@At(value="HEAD")})
    private void onAnyHudRender(class_332 ctx, class_9779 rtc, CallbackInfo ci) {
        long now = System.currentTimeMillis();
        if (now - lastProbeLogMs < 5000L) {
            return;
        }
        lastProbeLogMs = now;
        InGameHudLocatorProbeMixin self = this;
        for (Class<?> cls = self.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
            for (Field f : cls.getDeclaredFields()) {
                try {
                    f.setAccessible(true);
                    Object v = f.get(self);
                    if (v == null || !(v instanceof Map)) continue;
                    Map map = (Map)v;
                    int count = 0;
                    for (Object val : map.values()) {
                        if (!(val instanceof class_11226)) continue;
                        ++count;
                        InGameHudLocatorProbeMixin.reflectLocatorBar(val);
                    }
                    if (count <= 0) continue;
                    LOGGER.info("[WurstLocator] InGameHud bars map '{}' contains {} LocatorBar instance(s)", (Object)f.getName(), (Object)count);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private static void reflectLocatorBar(Object locatorBar) {
        try {
            int logged = 0;
            for (Class<?> c = locatorBar.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
                for (Field f : c.getDeclaredFields()) {
                    try {
                        f.setAccessible(true);
                        Object v = f.get(locatorBar);
                        String type = f.getType().getName();
                        String summary = InGameHudLocatorProbeMixin.summarizeValue(v, 4);
                        LOGGER.info("[WurstLocator] LB field={} type={} value= {}", new Object[]{f.getName(), type, summary});
                        InGameHudLocatorProbeMixin.verboseElements(f.getName(), v);
                        ++logged;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            if (logged == 0) {
                LOGGER.info("[WurstLocator] LB no fields via reflection");
            }
        }
        catch (Throwable t) {
            LOGGER.warn("[WurstLocator] LB reflect error: {}", (Object)t.toString());
        }
    }

    private static void verboseElements(String fieldName, Object v) {
        block11: {
            try {
                int limit = 6;
                if (v instanceof Collection) {
                    Collection col = (Collection)v;
                    int i = 0;
                    for (Object e : col) {
                        if (i++ >= limit) break;
                        LOGGER.info("[WurstLocator] LB verbose field={} elemClass={} sample={}", new Object[]{fieldName, e == null ? "null" : e.getClass().getName(), InGameHudLocatorProbeMixin.pretty(e)});
                    }
                    if (col.size() > limit) {
                        LOGGER.info("[WurstLocator] LB verbose field={} has {}+ elements", (Object)fieldName, (Object)col.size());
                    }
                    break block11;
                }
                if (v instanceof Map) {
                    Map map = (Map)v;
                    int i = 0;
                    for (Map.Entry en : map.entrySet()) {
                        if (i++ < limit) {
                            Object val = en.getValue();
                            LOGGER.info("[WurstLocator] LB verbose field={} map valClass={} sample={}", new Object[]{fieldName, val == null ? "null" : val.getClass().getName(), InGameHudLocatorProbeMixin.pretty(val)});
                            continue;
                        }
                        break block11;
                    }
                    break block11;
                }
                if (v != null && v.getClass().isArray()) {
                    int len = Array.getLength(v);
                    for (int i = 0; i < Math.min(len, limit); ++i) {
                        Object e = Array.get(v, i);
                        LOGGER.info("[WurstLocator] LB verbose field={} elemClass={} sample={}", new Object[]{fieldName, e == null ? "null" : e.getClass().getName(), InGameHudLocatorProbeMixin.pretty(e)});
                    }
                    if (len > limit) {
                        LOGGER.info("[WurstLocator] LB verbose field={} has {}+ elements", (Object)fieldName, (Object)len);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static String summarizeValue(Object v, int limit) {
        if (v == null) {
            return "null";
        }
        try {
            if (v instanceof Collection) {
                Collection col = (Collection)v;
                return "Collection(size=" + col.size() + ", sample=" + InGameHudLocatorProbeMixin.sampleCollection(col, limit) + ")";
            }
            if (v instanceof Map) {
                Map map = (Map)v;
                return "Map(size=" + map.size() + ", sampleKeys=" + InGameHudLocatorProbeMixin.sampleCollection(map.keySet(), limit) + ")";
            }
            if (v.getClass().isArray()) {
                int len = Array.getLength(v);
                StringBuilder sb = new StringBuilder();
                sb.append("Array(len=").append(len).append(", sample=[");
                for (int i = 0; i < Math.min(len, limit); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    Object e = Array.get(v, i);
                    sb.append(InGameHudLocatorProbeMixin.pretty(e));
                }
                if (len > limit) {
                    sb.append(",...");
                }
                sb.append("])");
                return sb.toString();
            }
            Object s = String.valueOf(v);
            if (((String)s).length() > 200) {
                s = ((String)s).substring(0, 200) + "...";
            }
            return s;
        }
        catch (Throwable t) {
            return v.getClass().getName();
        }
    }

    private static String sampleCollection(Collection<?> col, int limit) {
        StringBuilder sb = new StringBuilder("[");
        int i = 0;
        Iterator<?> it = col.iterator();
        while (it.hasNext() && i < limit) {
            Object e = it.next();
            if (i++ > 0) {
                sb.append(',');
            }
            sb.append(InGameHudLocatorProbeMixin.pretty(e));
        }
        if (col.size() > limit) {
            sb.append(",...");
        }
        sb.append(']');
        return sb.toString();
    }

    private static String pretty(Object o) {
        if (o == null) {
            return "null";
        }
        try {
            Object s = String.valueOf(o);
            if (((String)s).length() > 200) {
                s = ((String)s).substring(0, 200) + "...";
            }
            return s;
        }
        catch (Throwable t) {
            return o.getClass().getName();
        }
    }
}

