/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.nicewurst;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_327;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import net.wurstclient.Category;
import net.wurstclient.Feature;
import net.wurstclient.WurstClient;
import net.wurstclient.WurstRenderLayers;
import net.wurstclient.chestsearch.ChestEntry;
import net.wurstclient.chestsearch.ChestManager;
import net.wurstclient.events.RenderListener;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.hack.Hack;
import net.wurstclient.hack.HackList;
import net.wurstclient.hacks.ChestSearchHack;
import net.wurstclient.navigator.Navigator;
import net.wurstclient.other_feature.OtfList;
import net.wurstclient.other_feature.OtherFeature;
import net.wurstclient.util.RenderUtils;

public final class NiceWurstModule {
    private static final String BRAND_LABEL = "NiceWurst 7";
    private static final String OPTIONS_LABEL = "NiceWurst 7 Options";
    private static final EnumSet<Category> CATEGORY_ALLOW_ALL = EnumSet.of(Category.FUN);
    private static final EnumMap<Category, Set<String>> ALLOWED_HACKS = new EnumMap(Category.class);
    private static final Set<String> ALLOWED_NAME_ONLY = Set.of("ClickGUI", "Navigator");
    private static final Set<String> HIDDEN_OTHER_FEATURES = Set.of("Anti-Fingerprint");
    private static final Set<String> DEPTH_TEST_CALLERS = Set.of("net.wurstclient.hacks.BreadcrumbsHack", "net.wurstclient.hacks.ItemEspHack", "net.wurstclient.hacks.MobEspHack", "net.wurstclient.hacks.MobSearchHack", "net.wurstclient.hacks.PlayerEspHack", "net.wurstclient.hacks.PortalEspHack", "net.wurstclient.hacks.SearchHack", "net.wurstclient.hacks.TrialSpawnerEspHack", "net.wurstclient.hacks.TridentEspHack");
    private static final Set<String> ENTITY_OVERLAY_CALLERS = Set.of("net.wurstclient.hacks.MobEspHack");
    private static final Set<String> TEXT_DEPTH_TEST_CALLERS = Set.of("net.wurstclient.hacks.TrialSpawnerEspHack");
    private static final Set<String> TRACER_VISIBILITY_EXCEPTIONS = Set.of("net.wurstclient.hacks.WaypointsHack");
    private static boolean applied;

    private NiceWurstModule() {
    }

    public static boolean isActive() {
        return true;
    }

    public static void apply(WurstClient wurst) {
        if (!NiceWurstModule.isActive() || applied || wurst == null) {
            return;
        }
        applied = true;
        NiceWurstModule.filterHackList(wurst.getHax());
        NiceWurstModule.filterNavigator(wurst.getNavigator());
        NiceWurstModule.filterOtherFeatures(wurst.getOtfs());
        NiceWurstModule.scheduleStateCleanup(wurst);
        NiceWurstModule.enableOpenedChestMarker(wurst);
    }

    public static boolean showAltManager() {
        return !NiceWurstModule.isActive();
    }

    public static boolean showAntiFingerprintControls() {
        return !NiceWurstModule.isActive();
    }

    public static boolean showXrayBlocksManager() {
        return !NiceWurstModule.isActive();
    }

    public static String getBrandLabel(String defaultLabel) {
        return NiceWurstModule.isActive() ? BRAND_LABEL : defaultLabel;
    }

    public static String getOptionsLabel(String defaultLabel) {
        return NiceWurstModule.isActive() ? OPTIONS_LABEL : defaultLabel;
    }

    public static boolean enforceDepthTest(boolean originalDepthTest) {
        if (originalDepthTest || !NiceWurstModule.isActive()) {
            return originalDepthTest;
        }
        if (NiceWurstModule.isEntityOverlayCall()) {
            return originalDepthTest;
        }
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!DEPTH_TEST_CALLERS.contains(element.getClassName())) continue;
            return true;
        }
        return originalDepthTest;
    }

    public static class_1921.class_4687 enforceDepthTest(class_1921.class_4687 originalLayer) {
        if (!NiceWurstModule.isActive() || originalLayer == null) {
            return originalLayer;
        }
        if (NiceWurstModule.isEntityOverlayCall()) {
            return originalLayer;
        }
        if (originalLayer == WurstRenderLayers.ESP_QUADS) {
            return WurstRenderLayers.QUADS;
        }
        if (originalLayer == WurstRenderLayers.ESP_QUADS_NO_CULLING) {
            return WurstRenderLayers.QUADS_NO_CULLING;
        }
        if (originalLayer == WurstRenderLayers.ESP_LINES) {
            return WurstRenderLayers.LINES;
        }
        if (originalLayer == WurstRenderLayers.ESP_LINE_STRIP) {
            return WurstRenderLayers.LINE_STRIP;
        }
        return originalLayer;
    }

    public static boolean shouldEnforceTracerVisibility() {
        if (!NiceWurstModule.isActive()) {
            return false;
        }
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!TRACER_VISIBILITY_EXCEPTIONS.contains(element.getClassName())) continue;
            return false;
        }
        return true;
    }

    public static boolean shouldRenderTarget(class_243 target) {
        class_2338 targetPos;
        if (!NiceWurstModule.isActive() || target == null) {
            return true;
        }
        if (WurstClient.MC.field_1687 == null || WurstClient.MC.field_1724 == null) {
            return true;
        }
        class_4184 camera = WurstClient.MC.field_1773.method_19418();
        if (camera == null) {
            return true;
        }
        class_243 from = camera.method_19326();
        if (from == null) {
            return true;
        }
        if (from.method_1025(target) < 1.0E-6) {
            return true;
        }
        class_3959 context = new class_3959(from, target, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)WurstClient.MC.field_1724);
        class_3965 hit = WurstClient.MC.field_1687.method_17742(context);
        if (hit == null || hit.method_17783() == class_239.class_240.field_1333) {
            return true;
        }
        if (hit.method_17783() != class_239.class_240.field_1332) {
            return true;
        }
        class_2338 hitPos = hit.method_17777();
        if (hitPos.equals((Object)(targetPos = class_2338.method_49638((class_2374)target)))) {
            return true;
        }
        double targetDistSq = from.method_1025(target);
        double hitDistSq = hit.method_17784().method_1025(from);
        return hitDistSq >= targetDistSq - 0.001;
    }

    public static Integer filterGlowColor(class_1309 entity, Integer color) {
        if (color == null || !NiceWurstModule.isActive()) {
            return color;
        }
        if (entity == null) {
            return color;
        }
        class_243 target = entity.method_5829().method_1005();
        return NiceWurstModule.shouldRenderTarget(target) ? color : null;
    }

    public static class_327.class_6415 enforceTextLayer(class_327.class_6415 originalLayer) {
        if (originalLayer == null || !NiceWurstModule.isActive()) {
            return originalLayer;
        }
        if (originalLayer != class_327.class_6415.field_33994) {
            return originalLayer;
        }
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!TEXT_DEPTH_TEST_CALLERS.contains(element.getClassName())) continue;
            return class_327.class_6415.field_33993;
        }
        return originalLayer;
    }

    public static boolean shouldOverlayEntityShapes() {
        return NiceWurstModule.isActive() && NiceWurstModule.isEntityOverlayCall();
    }

    private static boolean isEntityOverlayCall() {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!ENTITY_OVERLAY_CALLERS.contains(element.getClassName())) continue;
            return true;
        }
        return false;
    }

    private static void filterHackList(HackList hackList) {
        TreeMap<String, Hack> hackMap = NiceWurstModule.getHackMap(hackList);
        Iterator<Map.Entry<String, Hack>> iterator = hackMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Hack hack = iterator.next().getValue();
            if (NiceWurstModule.isHackAllowed(hack)) continue;
            hack.setEnabled(false);
            if (hack.isFavorite()) {
                hack.setFavorite(false);
            }
            iterator.remove();
        }
    }

    private static void filterNavigator(Navigator navigator) {
        ArrayList<Feature> list = NiceWurstModule.getNavigatorList(navigator);
        list.removeIf(feature -> feature instanceof Hack && !NiceWurstModule.isHackAllowed((Hack)feature));
        list.removeIf(feature -> feature instanceof OtherFeature && HIDDEN_OTHER_FEATURES.contains(feature.getName()));
    }

    private static void filterOtherFeatures(OtfList otfList) {
        TreeMap<String, OtherFeature> featureMap = NiceWurstModule.getOtherFeatureMap(otfList);
        Iterator<Map.Entry<String, OtherFeature>> iterator = featureMap.entrySet().iterator();
        while (iterator.hasNext()) {
            OtherFeature feature = iterator.next().getValue();
            if (!HIDDEN_OTHER_FEATURES.contains(feature.getName())) continue;
            iterator.remove();
        }
    }

    private static void scheduleStateCleanup(final WurstClient wurst) {
        wurst.getEventManager().add(UpdateListener.class, new UpdateListener(){
            private int ticks;

            @Override
            public void onUpdate() {
                if (++this.ticks < 2) {
                    return;
                }
                wurst.getHax().saveEnabledHax();
                wurst.getHax().saveFavoriteHax();
                wurst.getEventManager().remove(UpdateListener.class, this);
            }
        });
    }

    private static void enableOpenedChestMarker(WurstClient wurst) {
        OpenedChestMarker marker = new OpenedChestMarker();
        wurst.getEventManager().add(UpdateListener.class, marker);
        wurst.getEventManager().add(RenderListener.class, marker);
    }

    private static boolean isHackAllowed(Hack hack) {
        Category category = hack.getCategory();
        String name = hack.getName();
        if (ALLOWED_NAME_ONLY.contains(name)) {
            return true;
        }
        if (category != null && CATEGORY_ALLOW_ALL.contains((Object)category)) {
            return true;
        }
        Set allowed = category == null ? Set.of() : ALLOWED_HACKS.getOrDefault((Object)category, Set.of());
        return allowed.contains(name);
    }

    private static TreeMap<String, Hack> getHackMap(HackList hackList) {
        try {
            Field field = HackList.class.getDeclaredField("hax");
            field.setAccessible(true);
            return (TreeMap)field.get(hackList);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to access HackList map.", e);
        }
    }

    private static ArrayList<Feature> getNavigatorList(Navigator navigator) {
        try {
            Field field = Navigator.class.getDeclaredField("navigatorList");
            field.setAccessible(true);
            return (ArrayList)field.get(navigator);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to access Navigator list.", e);
        }
    }

    private static TreeMap<String, OtherFeature> getOtherFeatureMap(OtfList otfList) {
        try {
            Field field = OtfList.class.getDeclaredField("otfs");
            field.setAccessible(true);
            return (TreeMap)field.get(otfList);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Unable to access OtherFeature map.", e);
        }
    }

    public static boolean isHackEnabled(String name, Category category) {
        if (!NiceWurstModule.isActive()) {
            return true;
        }
        name = name == null ? "" : name;
        Category cat = category;
        if (cat != null && CATEGORY_ALLOW_ALL.contains((Object)cat)) {
            return true;
        }
        Set allowed = cat == null ? Set.of() : ALLOWED_HACKS.getOrDefault((Object)cat, Set.of());
        return allowed.contains(name);
    }

    public static List<String> getAllowedHackNames(Category category) {
        if (!NiceWurstModule.isActive()) {
            return List.of();
        }
        if (category != null && CATEGORY_ALLOW_ALL.contains((Object)category)) {
            return List.of();
        }
        Set allowed = category == null ? Set.of() : ALLOWED_HACKS.getOrDefault((Object)category, Set.of());
        return allowed.stream().map(s -> s.toLowerCase(Locale.ROOT)).toList();
    }

    static {
        ALLOWED_HACKS.put(Category.BLOCKS, Set.of("AutoBuild", "AutoSign", "AutoTool", "BuildRandom", "Excavator", "InstantBunker", "ScaffoldWalk", "TemplateTool"));
        ALLOWED_HACKS.put(Category.MOVEMENT, Set.of("BunnyHop", "AutoSprint", "AutoWalk", "AutoSwim", "Dolphin", "SafeWalk", "Sneak", "InvWalk"));
        ALLOWED_HACKS.put(Category.COMBAT, Set.of("AutoRespawn", "AutoTotem", "AutoLeave", "WindChargeKey"));
        ALLOWED_HACKS.put(Category.RENDER, Set.of("Breadcrumbs", "Fullbright", "HealthTags", "ItemESP", "LavaWaterESP", "LogoutSpots", "MobESP", "MobSearch", "MobSpawnESP", "NewChunks", "NoBackground", "NoFireOverlay", "NoVignette", "NoWeather", "Freecam", "OpenWaterESP", "PlayerESP", "PortalESP", "Radar", "Search", "TrialSpawnerESP", "TridentESP", "Waypoints"));
        ALLOWED_HACKS.put(Category.OTHER, Set.of("AntiAFK", "Antisocial", "AutoFish", "AutoLibrarian", "AutoReconnect", "AutoTrader", "CheatDetector", "ClickGUI", "FeedAura", "Navigator", "Panic", "PortalGUI", "SafeTP", "SeedMapperHelper", "TooManyHax"));
        ALLOWED_HACKS.put(Category.ITEMS, Set.of("AntiDrop", "AutoDisenchant", "AutoDrop", "AutoEat", "AutoSteal", "ChestSearch", "EnchantmentHandler", "ItemHandler", "QuickShulker", "SignFramePT", "LootSearch", "XCarry"));
    }

    private static final class OpenedChestMarker
    implements UpdateListener,
    RenderListener {
        private List<ChestEntry> openedChests = List.of();

        private OpenedChestMarker() {
        }

        @Override
        public void onUpdate() {
            try {
                this.openedChests = new ChestManager().all();
            }
            catch (Throwable ignored) {
                this.openedChests = List.of();
            }
        }

        @Override
        public void onRender(class_4587 matrixStack, float partialTicks) {
            if (matrixStack == null || this.openedChests.isEmpty()) {
                return;
            }
            if (WurstClient.INSTANCE == null || WurstClient.MC == null) {
                return;
            }
            ChestSearchHack chestSearch = WurstClient.INSTANCE.getHax().chestSearchHack;
            if (chestSearch == null || !chestSearch.isMarkOpenedChest()) {
                return;
            }
            class_638 level = WurstClient.MC.field_1687;
            if (level == null || level.method_27983() == null) {
                return;
            }
            String curDimFull = level.method_27983().method_29177().toString();
            String curDimPath = level.method_27983().method_29177().method_12832();
            ArrayList<class_238> boxes = new ArrayList<class_238>();
            for (ChestEntry entry : this.openedChests) {
                class_2338 pos;
                if (entry == null || entry.dimension == null || !OpenedChestMarker.dimensionMatches(entry.dimension, curDimFull, curDimPath) || (pos = entry.getClickedPos()) == null || !level.method_8477(pos)) continue;
                boxes.add(OpenedChestMarker.entryToBox(entry));
            }
            if (boxes.isEmpty()) {
                return;
            }
            int markColor = chestSearch.getMarkXColorARGB();
            int fillColor = 0x40000000 | markColor & 0xFFFFFF;
            boolean depthTest = NiceWurstModule.enforceDepthTest(true);
            RenderUtils.drawSolidBoxes(matrixStack, boxes, fillColor, depthTest);
            RenderUtils.drawOutlinedBoxes(matrixStack, boxes, markColor, depthTest);
        }

        private static boolean dimensionMatches(String entryDim, String curDimFull, String curDimPath) {
            return entryDim.equals(curDimFull) || entryDim.equals(curDimPath) || entryDim.endsWith(":" + curDimPath);
        }

        private static class_238 entryToBox(ChestEntry entry) {
            int minX = Math.min(entry.x, entry.maxX);
            int minY = Math.min(entry.y, entry.maxY);
            int minZ = Math.min(entry.z, entry.maxZ);
            int maxX = Math.max(entry.x, entry.maxX) + 1;
            int maxY = Math.max(entry.y, entry.maxY) + 1;
            int maxZ = Math.max(entry.z, entry.maxZ) + 1;
            return new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        }
    }
}

