/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.other_features;

import java.awt.Color;
import java.util.Comparator;
import net.wurstclient.DontBlock;
import net.wurstclient.SearchTags;
import net.wurstclient.WurstClient;
import net.wurstclient.hack.Hack;
import net.wurstclient.other_feature.OtherFeature;
import net.wurstclient.settings.CheckboxSetting;
import net.wurstclient.settings.ColorSetting;
import net.wurstclient.settings.EnumSetting;
import net.wurstclient.settings.SliderSetting;

@SearchTags(value={"hack list", "HakList", "hak list", "HacksList", "hacks list", "HaxList", "hax list", "ArrayList", "array list", "ModList", "mod list", "CheatList", "cheat list"})
@DontBlock
public final class HackListOtf
extends OtherFeature {
    private final EnumSetting<Mode> mode = new EnumSetting("Mode", "\u00a7lAuto\u00a7r mode renders the whole list if it fits onto the screen.\n\u00a7lCount\u00a7r mode only renders the number of active hacks.\n\u00a7lHidden\u00a7r mode renders nothing.", (Enum[])Mode.values(), (Enum)Mode.AUTO);
    private final EnumSetting<Position> position = new EnumSetting("Position", "Which side of the screen the HackList should be shown on.\nChange this to \u00a7lRight\u00a7r when using TabGUI.", (Enum[])Position.values(), (Enum)Position.TOP_LEFT);
    private final ColorSetting color = new ColorSetting("Color", "Color of the HackList text.\nOnly visible when \u00a76RainbowUI\u00a7r is disabled.", Color.WHITE);
    private final CheckboxSetting useHackColors = new CheckboxSetting("Use hack colors", "When enabled, each entry uses the hack's own color (if available), e.g. ESP highlight colors.\nHas no effect while RainbowUI is enabled.", false);
    private final CheckboxSetting shadowBox = new CheckboxSetting("Shadow box", "Replace the text shadow with a transparent black box background. Useful when scaled fonts produce ugly shadows.", false);
    private final SliderSetting shadowBoxAlpha = new SliderSetting("Shadow box alpha", 0.5, 0.0, 1.0, 0.01, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting transparency = new SliderSetting("Transparency", 1.0, 0.0, 1.0, 0.01, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting xOffset = new SliderSetting("X offset", 0.0, -200.0, 200.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final SliderSetting yOffset = new SliderSetting("Y offset", 0.0, -200.0, 200.0, 1.0, SliderSetting.ValueDisplay.INTEGER);
    private final EnumSetting<SortBy> sortBy = new EnumSetting("Sort by", "Determines how the HackList entries are sorted.\nOnly visible when \u00a76Mode\u00a7r is set to \u00a76Auto\u00a7r.", (Enum[])SortBy.values(), (Enum)SortBy.NAME);
    private final CheckboxSetting revSort = new CheckboxSetting("Reverse sorting", false);
    private final CheckboxSetting animations = new CheckboxSetting("Animations", "When enabled, entries slide into and out of the HackList as hacks are enabled and disabled.", true);
    private SortBy prevSortBy;
    private Boolean prevRevSort;
    private final SliderSetting fontSize = new SliderSetting("Font size", 1.0, 0.5, 2.0, 0.05, SliderSetting.ValueDisplay.DECIMAL);
    private final SliderSetting entrySpacing = new SliderSetting("Entry spacing", 0.0, 0.0, 24.0, 1.0, SliderSetting.ValueDisplay.INTEGER);

    public HackListOtf() {
        super("HackList", "Shows a list of active hacks on the screen.");
        this.addSetting(this.mode);
        this.addSetting(this.position);
        this.addSetting(this.color);
        this.addSetting(this.useHackColors);
        this.addSetting(this.shadowBox);
        this.addSetting(this.shadowBoxAlpha);
        this.addSetting(this.fontSize);
        this.addSetting(this.entrySpacing);
        this.addSetting(this.transparency);
        this.addSetting(this.xOffset);
        this.addSetting(this.yOffset);
        this.addSetting(this.sortBy);
        this.addSetting(this.revSort);
        this.addSetting(this.animations);
    }

    public Mode getMode() {
        return this.mode.getSelected();
    }

    public Position getPosition() {
        return this.position.getSelected();
    }

    public double getTransparency() {
        return this.transparency.getValue();
    }

    public double getFontSize() {
        return this.fontSize.getValue();
    }

    public int getEntrySpacing() {
        return this.entrySpacing.getValueI();
    }

    public int getXOffset() {
        return this.xOffset.getValueI();
    }

    public int getYOffset() {
        return this.yOffset.getValueI();
    }

    public boolean isAnimations() {
        return this.animations.isChecked();
    }

    public boolean useShadowBox() {
        return this.shadowBox.isChecked();
    }

    public Comparator<Hack> getComparator() {
        if (this.revSort.isChecked()) {
            return this.sortBy.getSelected().comparator.reversed();
        }
        return this.sortBy.getSelected().comparator;
    }

    public boolean shouldSort() {
        try {
            if (this.sortBy.getSelected() == SortBy.WIDTH) {
                boolean bl = true;
                return bl;
            }
            if (this.sortBy.getSelected() != this.prevSortBy) {
                boolean bl = true;
                return bl;
            }
            if (!Boolean.valueOf(this.revSort.isChecked()).equals(this.prevRevSort)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.prevSortBy = this.sortBy.getSelected();
            this.prevRevSort = this.revSort.isChecked();
        }
    }

    public int getColor(int alpha) {
        return this.color.getColorI(alpha);
    }

    public boolean useHackColors() {
        return this.useHackColors.isChecked();
    }

    public double getShadowBoxAlpha() {
        return this.shadowBoxAlpha.getValue();
    }

    public static enum Mode {
        AUTO("Auto"),
        COUNT("Count"),
        HIDDEN("Hidden");

        private final String name;

        private Mode(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Position {
        LEFT("Left"),
        RIGHT("Right"),
        TOP_LEFT("Top left"),
        TOP_RIGHT("Top right"),
        BOTTOM_LEFT("Bottom left"),
        BOTTOM_RIGHT("Bottom right");

        private final String name;

        private Position(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum SortBy {
        NAME("Name", (a, b) -> a.getName().compareToIgnoreCase(b.getName())),
        WIDTH("Width", Comparator.comparingInt(h -> WurstClient.MC.field_1772.method_1727(h.getRenderName())));

        private final String name;
        private final Comparator<Hack> comparator;

        private SortBy(String name, Comparator<Hack> comparator) {
            this.name = name;
            this.comparator = comparator;
        }

        public String toString() {
            return this.name;
        }
    }
}

