/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.other_features;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import net.wurstclient.Category;
import net.wurstclient.Feature;
import net.wurstclient.hack.Hack;
import net.wurstclient.keybinds.Keybind;
import net.wurstclient.keybinds.KeybindList;
import net.wurstclient.other_feature.OtherFeature;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.ChatUtils;
import net.wurstclient.util.json.JsonUtils;

public final class WikiDataExportOtf
extends OtherFeature {
    public WikiDataExportOtf() {
        super("WikiDataExport", "Creates a JSON file full of technical details about all the different features and settings in this version of Wurst. Primarily used to update the Wurst Wiki.");
    }

    @Override
    public String getPrimaryAction() {
        return "Export Data";
    }

    @Override
    public void doPrimaryAction() {
        try {
            Path exportFile = WURST.getWurstFolder().resolve("wiki-data.json");
            JsonObject json = new JsonObject();
            for (Hack hack : WURST.getHax().getAllHax()) {
                json.add(hack.getName(), (JsonElement)this.hackToJson(hack));
            }
            JsonUtils.toJson((JsonElement)json, exportFile);
        }
        catch (Exception e) {
            ChatUtils.error("Failed to export data: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private JsonObject hackToJson(Hack hack) {
        JsonObject json = new JsonObject();
        json.addProperty("name", hack.getName());
        json.addProperty("descriptionKey", hack.getDescriptionKey());
        json.addProperty("type", "Hack");
        Category category = hack.getCategory();
        if (category != null) {
            json.addProperty("category", category.getName());
        }
        json.addProperty("keybind", this.getDefaultKeybind(hack));
        json.addProperty("stateSaved", Boolean.valueOf(hack.isStateSaved()));
        json.addProperty("class", hack.getClass().getName());
        JsonArray settings = new JsonArray();
        for (Setting setting : hack.getSettings().values()) {
            settings.add((JsonElement)setting.exportWikiData());
        }
        json.add("settings", (JsonElement)settings);
        return json;
    }

    private String getDefaultKeybind(Feature feature) {
        String name = feature.getName().toLowerCase().replace(" ", "_");
        if (name.startsWith(".")) {
            name = name.substring(1);
        }
        for (Keybind keybind : KeybindList.DEFAULT_KEYBINDS) {
            if (!keybind.getCommands().toLowerCase().contains(name)) continue;
            return keybind.getKey();
        }
        return null;
    }
}

