/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.components.ButtonComponent;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.text.WText;

public final class ButtonSetting
extends Setting {
    private final Runnable action;

    public ButtonSetting(String name, WText description, Runnable action) {
        super(name, description);
        this.action = Objects.requireNonNull(action);
    }

    public ButtonSetting(String name, String descriptionKey, Runnable action) {
        this(name, WText.translated(descriptionKey, new Object[0]), action);
    }

    public ButtonSetting(String name, Runnable action) {
        this(name, WText.empty(), action);
    }

    @Override
    public Component getComponent() {
        return new ButtonComponent(this.getName(), this.action);
    }

    @Override
    public void fromJson(JsonElement json) {
    }

    @Override
    public JsonElement toJson() {
        return JsonNull.INSTANCE;
    }

    @Override
    public JsonObject exportWikiData() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getName());
        json.addProperty("description", this.getDescription());
        json.addProperty("type", "Button");
        return json;
    }

    @Override
    public Set<PossibleKeybind> getPossibleKeybinds(String featureName) {
        return Collections.emptySet();
    }
}

