/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.wurstclient.WurstClient;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.components.EntityTypeListEditButton;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.json.JsonException;
import net.wurstclient.util.json.JsonUtils;
import net.wurstclient.util.text.WText;

public final class EntityTypeListSetting
extends Setting {
    private final ArrayList<String> typeNames = new ArrayList();
    private final String[] defaultNames;

    public EntityTypeListSetting(String name, WText description, String ... types) {
        super(name, description);
        if (types != null && types.length > 0) {
            ((Stream)Arrays.stream(types).parallel()).forEachOrdered(s -> this.addFromStringCanonicalizing((String)s));
        } else {
            class_7923.field_41177.method_10235().forEach(id -> {
                class_1299 t = (class_1299)class_7923.field_41177.method_63535(id);
                class_1311 g = t.method_5891();
                if (g != class_1311.field_17715) {
                    this.typeNames.add(id.toString());
                }
            });
            Collections.sort(this.typeNames);
        }
        this.defaultNames = this.typeNames.toArray(new String[0]);
    }

    public EntityTypeListSetting(String name, String descriptionKey) {
        this(name, WText.translated(descriptionKey, new Object[0]), new String[0]);
    }

    public List<String> getTypeNames() {
        return Collections.unmodifiableList(this.typeNames);
    }

    private void addFromStringCanonicalizing(String s) {
        if (s == null) {
            return;
        }
        String raw = s.trim();
        if (raw.isEmpty()) {
            return;
        }
        class_2960 id = class_2960.method_12829((String)raw);
        String name = raw;
        if (id != null && class_7923.field_41177.method_10250(id)) {
            name = id.toString();
        }
        if (Collections.binarySearch(this.typeNames, name) < 0) {
            this.typeNames.add(name);
            Collections.sort(this.typeNames);
        }
    }

    public void addRawName(String raw) {
        int before = this.typeNames.size();
        this.addFromStringCanonicalizing(raw);
        if (this.typeNames.size() != before) {
            WurstClient.INSTANCE.saveSettings();
        }
    }

    public void add(class_1299<?> type) {
        String name = class_7923.field_41177.method_10221(type).toString();
        if (Collections.binarySearch(this.typeNames, name) >= 0) {
            return;
        }
        this.typeNames.add(name);
        Collections.sort(this.typeNames);
        WurstClient.INSTANCE.saveSettings();
    }

    public void remove(int index) {
        if (index < 0 || index >= this.typeNames.size()) {
            return;
        }
        this.typeNames.remove(index);
        WurstClient.INSTANCE.saveSettings();
    }

    public void resetToDefaults() {
        this.typeNames.clear();
        this.typeNames.addAll(Arrays.asList(this.defaultNames));
        WurstClient.INSTANCE.saveSettings();
    }

    public void clear() {
        this.typeNames.clear();
        WurstClient.INSTANCE.saveSettings();
    }

    @Override
    public Component getComponent() {
        return new EntityTypeListEditButton(this);
    }

    @Override
    public void fromJson(JsonElement json) {
        try {
            this.typeNames.clear();
            if (JsonUtils.getAsString(json, "nope").equals("default")) {
                this.typeNames.addAll(Arrays.asList(this.defaultNames));
                return;
            }
            for (String s : JsonUtils.getAsArray(json).getAllStrings()) {
                this.addFromStringCanonicalizing(s);
            }
        }
        catch (JsonException e) {
            e.printStackTrace();
            this.resetToDefaults();
        }
    }

    @Override
    public JsonElement toJson() {
        if (this.typeNames.equals(Arrays.asList(this.defaultNames))) {
            return new JsonPrimitive("default");
        }
        JsonArray json = new JsonArray();
        this.typeNames.forEach(s -> json.add(s));
        return json;
    }

    @Override
    public JsonObject exportWikiData() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getName());
        json.addProperty("description", this.getDescription());
        json.addProperty("type", "EntityTypeList");
        JsonArray defaults = new JsonArray();
        Arrays.stream(this.defaultNames).forEachOrdered(arg_0 -> ((JsonArray)defaults).add(arg_0));
        json.add("defaultTypes", (JsonElement)defaults);
        return json;
    }

    @Override
    public Set<PossibleKeybind> getPossibleKeybinds(String featureName) {
        String fullName = featureName + " " + this.getName();
        String command = ".entitylist " + featureName.toLowerCase() + " " + this.getName().toLowerCase().replace(" ", "_") + " ";
        LinkedHashSet<PossibleKeybind> pkb = new LinkedHashSet<PossibleKeybind>();
        pkb.add(new PossibleKeybind(command + "reset", "Reset " + fullName));
        return pkb;
    }
}

