/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.settings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.wurstclient.clickgui.Component;
import net.wurstclient.clickgui.components.SettingGroupComponent;
import net.wurstclient.keybinds.PossibleKeybind;
import net.wurstclient.settings.Setting;
import net.wurstclient.util.text.WText;

public final class SettingGroup
extends Setting {
    private final ArrayList<Setting> children = new ArrayList();
    private final boolean defaultExpanded;
    private final boolean popout;

    public SettingGroup(String name, WText description) {
        this(name, description, false, true);
    }

    public SettingGroup(String name, WText description, boolean defaultExpanded, boolean popout) {
        super(name, description);
        this.defaultExpanded = defaultExpanded;
        this.popout = popout;
    }

    public SettingGroup addChild(Setting setting) {
        if (setting == null) {
            throw new IllegalArgumentException("Setting cannot be null.");
        }
        if (setting == this) {
            throw new IllegalArgumentException("SettingGroup cannot contain itself.");
        }
        if (this.children.contains(setting)) {
            return this;
        }
        this.children.add(setting);
        setting.setVisibleInGui(false);
        return this;
    }

    public SettingGroup addChildren(Setting ... settings) {
        if (settings == null) {
            return this;
        }
        Arrays.stream(settings).forEach(this::addChild);
        return this;
    }

    public List<Setting> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean isDefaultExpanded() {
        return this.defaultExpanded;
    }

    public boolean isPopout() {
        return this.popout;
    }

    @Override
    public Component getComponent() {
        return this.getComponent(true);
    }

    public Component getComponent(boolean allowPopout) {
        if (this.children.isEmpty()) {
            return null;
        }
        return new SettingGroupComponent(this, allowPopout);
    }

    @Override
    public void fromJson(JsonElement json) {
    }

    @Override
    public JsonElement toJson() {
        return JsonNull.INSTANCE;
    }

    @Override
    public JsonObject exportWikiData() {
        JsonObject json = new JsonObject();
        json.addProperty("name", this.getName());
        json.addProperty("description", this.getDescription());
        json.addProperty("type", "SettingGroup");
        JsonArray childArray = new JsonArray();
        for (Setting child : this.children) {
            childArray.add(child.getName());
        }
        json.add("children", (JsonElement)childArray);
        return json;
    }

    @Override
    public Set<PossibleKeybind> getPossibleKeybinds(String featureName) {
        return Collections.emptySet();
    }
}

