/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.util;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public final class ItemNameUtils {
    private ItemNameUtils() {
    }

    public static String buildEnchantmentName(class_2960 id, String path) {
        if (path == null || path.isEmpty()) {
            return "Unknown Enchant";
        }
        String namespace = id != null ? id.method_12836() : "minecraft";
        String key = "enchantment." + namespace + "." + path;
        String translated = class_2561.method_43471((String)key).getString();
        if (translated.equals(key)) {
            return ItemNameUtils.humanize(path);
        }
        return translated;
    }

    public static String buildEffectName(class_2960 id, String path) {
        if (path == null || path.isEmpty()) {
            return "Unknown Effect";
        }
        String namespace = id != null ? id.method_12836() : "minecraft";
        String key = "effect." + namespace + "." + path;
        String translated = class_2561.method_43471((String)key).getString();
        if (translated.equals(key)) {
            return ItemNameUtils.humanize(path);
        }
        return translated;
    }

    public static String buildPotionName(class_2960 id, String path) {
        if (path == null || path.isEmpty()) {
            return "Unknown Potion";
        }
        String namespace = id != null ? id.method_12836() : "minecraft";
        String key = "potion." + namespace + "." + path;
        String translated = class_2561.method_43471((String)key).getString();
        if (translated.equals(key)) {
            return ItemNameUtils.humanize(path);
        }
        return translated;
    }

    public static String humanize(String path) {
        if (path == null || path.isEmpty()) {
            return "Unknown";
        }
        String humanized = Arrays.stream(path.split("_")).filter(part -> !part.isEmpty()).map(part -> Character.toUpperCase(part.charAt(0)) + (part.length() > 1 ? part.substring(1) : "")).collect(Collectors.joining(" "));
        return humanized.isEmpty() ? "Unknown" : humanized;
    }

    public static String sanitizePath(String raw) {
        if (raw == null || raw.isEmpty()) {
            return "";
        }
        int colon = raw.indexOf(58);
        return colon >= 0 && colon + 1 < raw.length() ? raw.substring(colon + 1) : raw;
    }
}

