/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;

public final class PlayerColorRegistry {
    private static final Map<UUID, Color> colorMap = new HashMap<UUID, Color>();
    private static final Map<UUID, String> ownerMap = new HashMap<UUID, String>();

    private PlayerColorRegistry() {
    }

    public static synchronized Color assignIfAbsent(UUID player, Color color, String owner) {
        if (!colorMap.containsKey(player)) {
            colorMap.put(player, color);
            ownerMap.put(player, owner);
            return color;
        }
        return colorMap.get(player);
    }

    public static synchronized void forceAssign(UUID player, Color color, String owner) {
        colorMap.put(player, color);
        ownerMap.put(player, owner);
    }

    public static synchronized Color get(UUID player) {
        return colorMap.get(player);
    }

    public static synchronized void remove(UUID player) {
        colorMap.remove(player);
        ownerMap.remove(player);
    }

    public static synchronized void clear() {
        colorMap.clear();
        ownerMap.clear();
    }

    public static synchronized String getOwner(UUID player) {
        return ownerMap.get(player);
    }

    public static synchronized void removeByOwner(String owner) {
        Iterator<Map.Entry<UUID, String>> it = ownerMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<UUID, String> e = it.next();
            if (!owner.equals(e.getValue())) continue;
            UUID key = e.getKey();
            it.remove();
            colorMap.remove(key);
        }
    }

    public static Color generateBrightColor(int index) {
        Color[] base = new Color[]{new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255), new Color(255, 255, 0), new Color(255, 0, 255), new Color(0, 255, 255), new Color(255, 128, 0), new Color(128, 255, 0), new Color(255, 0, 128), new Color(0, 128, 255), new Color(128, 0, 255), new Color(0, 255, 128)};
        int baseCount = base.length;
        int b = Math.abs(index) % baseCount;
        int round = Math.abs(index) / baseCount;
        float factor = 1.0f - Math.min(0.2f, (float)round * 0.04f);
        Color bc = base[b];
        int r = Math.min(255, Math.max(0, (int)((float)bc.getRed() * factor)));
        int g = Math.min(255, Math.max(0, (int)((float)bc.getGreen() * factor)));
        int bl = Math.min(255, Math.max(0, (int)((float)bc.getBlue() * factor)));
        return new Color(r, g, bl);
    }

    public static synchronized Color assignGeneratedIfAbsent(UUID player, int index, String owner) {
        Color existing = colorMap.get(player);
        if (existing != null) {
            return existing;
        }
        Color c = PlayerColorRegistry.generateBrightColor(index);
        colorMap.put(player, c);
        ownerMap.put(player, owner);
        return c;
    }

    public static synchronized Color assignDeterministic(UUID player, String owner) {
        Color existing = colorMap.get(player);
        if (existing != null) {
            return existing;
        }
        int idx = player.hashCode();
        Color c = PlayerColorRegistry.generateBrightColor(idx);
        colorMap.put(player, c);
        ownerMap.put(player, owner);
        return c;
    }
}

