/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.wurstclient.WurstClient;
import net.wurstclient.event.EventManager;
import net.wurstclient.events.UpdateListener;
import net.wurstclient.util.FakePlayerEntity;

public final class PlayerRangeAlertManager
implements UpdateListener {
    private final EventManager events;
    private final class_310 mc = WurstClient.MC;
    private final Set<Listener> listeners = new LinkedHashSet<Listener>();
    private final Map<UUID, PlayerInfo> knownPlayers = new HashMap<UUID, PlayerInfo>();
    private boolean running;

    public PlayerRangeAlertManager(EventManager events) {
        this.events = events;
    }

    public synchronized void addListener(Listener listener) {
        if (this.listeners.add(listener) && !this.running) {
            this.events.add(UpdateListener.class, this);
            this.running = true;
        }
    }

    public synchronized void removeListener(Listener listener) {
        if (!this.listeners.remove(listener) || !this.listeners.isEmpty()) {
            return;
        }
        this.stop();
    }

    private synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.events.remove(UpdateListener.class, this);
        this.running = false;
        this.knownPlayers.clear();
    }

    @Override
    public void onUpdate() {
        if (!this.running) {
            return;
        }
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            this.flushAll();
            return;
        }
        HashSet<UUID> seen = new HashSet<UUID>();
        for (class_1657 player : this.mc.field_1687.method_18456()) {
            if (player == this.mc.field_1724 || player instanceof FakePlayerEntity) continue;
            UUID id = player.method_5667();
            seen.add(id);
            PlayerInfo info = this.knownPlayers.get(id);
            boolean npc = this.isProbablyNpc(id);
            class_243 pos = new class_243(player.method_23317(), player.method_23318(), player.method_23321());
            String name = player.method_5477().getString();
            if (info == null) {
                info = new PlayerInfo(id, name, pos, npc);
                this.knownPlayers.put(id, info);
                this.notifyEnter(player, info);
                continue;
            }
            info.update(name, pos, npc);
        }
        if (this.knownPlayers.isEmpty()) {
            return;
        }
        HashSet<UUID> toRemove = new HashSet<UUID>();
        for (Map.Entry<UUID, PlayerInfo> entry : this.knownPlayers.entrySet()) {
            if (seen.contains(entry.getKey())) continue;
            this.notifyExit(entry.getValue());
            toRemove.add(entry.getKey());
        }
        for (UUID id : toRemove) {
            this.knownPlayers.remove(id);
        }
    }

    private boolean isProbablyNpc(UUID id) {
        class_634 handler = this.mc.method_1562();
        return handler != null && handler.method_2871(id) == null;
    }

    private void flushAll() {
        if (this.knownPlayers.isEmpty()) {
            return;
        }
        this.knownPlayers.values().forEach(this::notifyExit);
        this.knownPlayers.clear();
    }

    private void notifyEnter(class_1657 player, PlayerInfo info) {
        for (Listener listener : this.snapshotListeners()) {
            listener.onPlayerEnter(player, info);
        }
    }

    private void notifyExit(PlayerInfo info) {
        for (Listener listener : this.snapshotListeners()) {
            listener.onPlayerExit(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Listener[] snapshotListeners() {
        PlayerRangeAlertManager playerRangeAlertManager = this;
        synchronized (playerRangeAlertManager) {
            if (this.listeners.isEmpty()) {
                return new Listener[0];
            }
            return this.listeners.toArray(new Listener[0]);
        }
    }

    public static final class PlayerInfo {
        private final UUID uuid;
        private String name;
        private class_243 lastPos;
        private boolean probablyNpc;

        private PlayerInfo(UUID uuid, String name, class_243 lastPos, boolean probablyNpc) {
            this.uuid = uuid;
            this.name = name;
            this.lastPos = lastPos;
            this.probablyNpc = probablyNpc;
        }

        private void update(String name, class_243 lastPos, boolean probablyNpc) {
            this.name = name;
            this.lastPos = lastPos;
            this.probablyNpc = probablyNpc;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public class_243 getLastPos() {
            return this.lastPos;
        }

        public boolean isProbablyNpc() {
            return this.probablyNpc;
        }
    }

    public static interface Listener {
        public void onPlayerEnter(class_1657 var1, PlayerInfo var2);

        public void onPlayerExit(PlayerInfo var1);
    }
}

