/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.waypoints;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.wurstclient.waypoints.Waypoint;
import net.wurstclient.waypoints.WaypointDimension;
import net.wurstclient.waypoints.XaeroWaypointIO;

public final class WaypointsManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path folder;
    private final ArrayList<Waypoint> waypoints = new ArrayList();

    public WaypointsManager(Path worldFolder) {
        this.folder = worldFolder.resolve("waypoints");
        try {
            Files.createDirectories(this.folder, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<Waypoint> all() {
        return this.waypoints;
    }

    public Waypoint getByName(String name) {
        for (Waypoint w : this.waypoints) {
            if (!w.getName().equalsIgnoreCase(name)) continue;
            return w;
        }
        return null;
    }

    public void addOrUpdate(Waypoint w) {
        int i = this.indexOfUuid(w.getUuid());
        if (i >= 0) {
            this.waypoints.set(i, w);
        } else {
            this.waypoints.add(w);
        }
    }

    public boolean remove(Waypoint w) {
        return this.waypoints.removeIf(x -> x.getUuid().equals(w.getUuid()));
    }

    private int indexOfUuid(UUID id) {
        for (int i = 0; i < this.waypoints.size(); ++i) {
            if (!this.waypoints.get(i).getUuid().equals(id)) continue;
            return i;
        }
        return -1;
    }

    public void load(String worldId) {
        Path file = this.folder.resolve(worldId + ".json");
        this.waypoints.clear();
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return;
        }
        try {
            JsonObject root = (JsonObject)GSON.fromJson((Reader)Files.newBufferedReader(file), JsonObject.class);
            JsonArray arr = root.getAsJsonArray("waypoints");
            if (arr == null) {
                return;
            }
            arr.forEach(el -> this.waypoints.add(WaypointsManager.fromJson(el.getAsJsonObject())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save(String worldId) {
        Path file = this.folder.resolve(worldId + ".json");
        JsonObject root = new JsonObject();
        JsonArray arr = new JsonArray();
        for (Waypoint w : this.waypoints) {
            arr.add((JsonElement)WaypointsManager.toJson(w));
        }
        root.add("waypoints", (JsonElement)arr);
        try {
            Files.writeString(file, (CharSequence)GSON.toJson((JsonElement)root), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public XaeroSyncStats importFromXaero(String worldId) {
        Path worldFolder = this.findXaeroWorldFolder(worldId);
        if (worldFolder == null) {
            return new XaeroSyncStats(0, 0, 0, 0, List.of());
        }
        int imported = 0;
        int skipped = 0;
        LinkedHashSet<Path> touched = new LinkedHashSet<Path>();
        for (WaypointDimension dimension : WaypointDimension.values()) {
            Set<class_2338> occupied = this.collectPositions(dimension);
            Path dimFolder = worldFolder.resolve(WaypointsManager.xaeroDimFolder(dimension));
            if (!Files.isDirectory(dimFolder, new LinkOption[0])) continue;
            ArrayList files = new ArrayList();
            try (Stream<Path> stream = Files.list(dimFolder);){
                stream.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && WaypointsManager.isXaeroWaypointName(p.getFileName().toString())).forEach(files::add);
            }
            catch (IOException e) {
                ++skipped;
                continue;
            }
            for (Path file : files) {
                XaeroWaypointIO.FileData data;
                touched.add(file);
                try {
                    data = XaeroWaypointIO.read(file);
                }
                catch (IOException e) {
                    ++skipped;
                    continue;
                }
                for (XaeroWaypointIO.Entry entry : data.entries()) {
                    class_2338 pos = entry.pos();
                    if (!occupied.add(pos)) {
                        ++skipped;
                        continue;
                    }
                    Waypoint w = new Waypoint(UUID.randomUUID(), System.currentTimeMillis());
                    w.setName(entry.name());
                    w.setPos(new class_2338(pos.method_10263(), pos.method_10264(), pos.method_10260()));
                    w.setDimension(dimension);
                    w.setColor(XaeroWaypointIO.colorFromIndex(entry.colorIdx()));
                    w.setVisible(!entry.disabled());
                    w.setLines(false);
                    w.setBeaconMode(Waypoint.BeaconMode.OFF);
                    w.setIcon(XaeroWaypointIO.iconFromType(entry.type()));
                    this.addOrUpdate(w);
                    ++imported;
                }
            }
        }
        return new XaeroSyncStats(imported, 0, skipped, 0, List.copyOf(touched));
    }

    public XaeroSyncStats exportToXaero(String worldId) {
        Path worldFolder = this.ensureXaeroWorldFolder(worldId);
        if (worldFolder == null) {
            return new XaeroSyncStats(0, 0, 0, 0, List.of());
        }
        int exported = 0;
        int skipped = 0;
        LinkedHashSet<Path> touched = new LinkedHashSet<Path>();
        for (WaypointDimension dimension : WaypointDimension.values()) {
            XaeroWaypointIO.FileData existing;
            ArrayList<Waypoint> subset = new ArrayList<Waypoint>();
            for (Waypoint waypoint : this.waypoints) {
                if (waypoint.getDimension() != dimension) continue;
                subset.add(waypoint);
            }
            if (subset.isEmpty()) continue;
            Path dimFolder = worldFolder.resolve(WaypointsManager.xaeroDimFolder(dimension));
            Path file = dimFolder.resolve("mw$default_1.txt");
            try {
                existing = XaeroWaypointIO.read(file);
            }
            catch (IOException e) {
                existing = new XaeroWaypointIO.FileData(List.of(), List.of());
            }
            ArrayList<XaeroWaypointIO.Entry> combined = new ArrayList<XaeroWaypointIO.Entry>(existing.entries());
            HashSet<class_2338> occupied = new HashSet<class_2338>();
            for (XaeroWaypointIO.Entry entry : existing.entries()) {
                occupied.add(entry.pos());
            }
            int addedForDim = 0;
            for (Waypoint waypoint : subset) {
                class_2338 pos = waypoint.getPos();
                if (!occupied.add(pos)) continue;
                combined.add(XaeroWaypointIO.fromWaypoint(waypoint));
                ++addedForDim;
            }
            if (addedForDim == 0) continue;
            ArrayList<String> arrayList = new ArrayList<String>(existing.sets());
            try {
                XaeroWaypointIO.write(file, arrayList, combined);
                exported += addedForDim;
                touched.add(file);
            }
            catch (IOException e) {
                ++skipped;
            }
        }
        return new XaeroSyncStats(0, 0, skipped, exported, List.copyOf(touched));
    }

    private Set<class_2338> collectPositions(WaypointDimension dimension) {
        HashSet<class_2338> positions = new HashSet<class_2338>();
        for (Waypoint waypoint : this.waypoints) {
            if (waypoint.getDimension() != dimension) continue;
            positions.add(waypoint.getPos());
        }
        return positions;
    }

    private static boolean isXaeroWaypointName(String name) {
        return name.startsWith("mw$") && name.endsWith(".txt");
    }

    private Path findXaeroWorldFolder(String worldId) {
        Path root = this.xaeroRoot();
        if (root == null || !Files.isDirectory(root, new LinkOption[0])) {
            return null;
        }
        List<Path> dirs = WaypointsManager.listDirectories(root);
        if (dirs.isEmpty()) {
            return null;
        }
        List<String> candidates = WaypointsManager.xaeroFolderCandidates(worldId);
        for (String candidate : candidates) {
            for (Path dir : dirs) {
                if (!dir.getFileName().toString().equalsIgnoreCase(candidate)) continue;
                return dir;
            }
        }
        String needle = WaypointsManager.sanitizeWorldId(worldId).toLowerCase(Locale.ROOT);
        for (Path dir : dirs) {
            String name = dir.getFileName().toString().toLowerCase(Locale.ROOT);
            if (!name.contains(needle)) continue;
            return dir;
        }
        return null;
    }

    private Path ensureXaeroWorldFolder(String worldId) {
        Path root = this.xaeroRoot();
        if (root == null) {
            return null;
        }
        try {
            Files.createDirectories(root, new FileAttribute[0]);
        }
        catch (IOException e) {
            return null;
        }
        Path existing = this.findXaeroWorldFolder(worldId);
        if (existing != null) {
            return existing;
        }
        for (String candidate : WaypointsManager.xaeroFolderCandidates(worldId)) {
            Path candidatePath = root.resolve(candidate);
            try {
                Files.createDirectories(candidatePath, new FileAttribute[0]);
                return candidatePath;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private Path xaeroRoot() {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return null;
        }
        return client.field_1697.toPath().resolve("xaero").resolve("minimap");
    }

    private static List<Path> listDirectories(Path root) {
        ArrayList<Path> dirs = new ArrayList<Path>();
        try (Stream<Path> stream = Files.list(root);){
            stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(dirs::add);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dirs;
    }

    private static List<String> xaeroFolderCandidates(String worldId) {
        LinkedHashSet<CallSite> names = new LinkedHashSet<CallSite>();
        String sanitized = WaypointsManager.sanitizeWorldId(worldId);
        if ("singleplayer".equalsIgnoreCase(worldId)) {
            names.add((CallSite)((Object)("Singleplayer_" + sanitized)));
            return new ArrayList<String>(names);
        }
        int idx = sanitized.lastIndexOf(95);
        if (idx > 0) {
            names.add((CallSite)((Object)("Multiplayer_" + sanitized)));
        }
        names.add((CallSite)((Object)("Multiplayer_" + (idx > 0 ? sanitized.substring(0, idx) : sanitized))));
        return new ArrayList<String>(names);
    }

    private static String sanitizeWorldId(String worldId) {
        if (worldId == null || worldId.isBlank()) {
            return "default";
        }
        return worldId.replace(':', '_').replace('/', '_').replace("\\", "_");
    }

    private static String xaeroDimFolder(WaypointDimension dimension) {
        return switch (dimension) {
            default -> throw new MatchException(null, null);
            case WaypointDimension.OVERWORLD -> "dim%0";
            case WaypointDimension.NETHER -> "dim%-1";
            case WaypointDimension.END -> "dim%1";
        };
    }

    private static JsonObject toJson(Waypoint w) {
        JsonObject o = new JsonObject();
        o.addProperty("uuid", w.getUuid().toString());
        o.addProperty("createdAt", (Number)w.getCreatedAt());
        o.addProperty("name", w.getName());
        o.addProperty("icon", w.getIcon());
        o.addProperty("color", (Number)w.getColor());
        o.addProperty("visible", Boolean.valueOf(w.isVisible()));
        o.addProperty("maxVisible", (Number)w.getMaxVisible());
        o.addProperty("scale", (Number)w.getScale());
        o.addProperty("lines", Boolean.valueOf(w.isLines()));
        o.addProperty("beacon", Boolean.valueOf(w.hasBeacon()));
        o.addProperty("beaconMode", w.getBeaconMode().name());
        class_2338 p = w.getPos();
        JsonObject pos = new JsonObject();
        pos.addProperty("x", (Number)p.method_10263());
        pos.addProperty("y", (Number)p.method_10264());
        pos.addProperty("z", (Number)p.method_10260());
        o.add("pos", (JsonElement)pos);
        o.addProperty("dimension", w.getDimension().name());
        o.addProperty("opposite", Boolean.valueOf(w.isOpposite()));
        o.addProperty("actionWhenNear", w.getActionWhenNear().name());
        o.addProperty("actionWhenNearDistance", (Number)w.getActionWhenNearDistance());
        return o;
    }

    private static Waypoint fromJson(JsonObject o) {
        Waypoint w = new Waypoint(UUID.fromString(o.get("uuid").getAsString()), o.get("createdAt").getAsLong());
        w.setName(WaypointsManager.optString(o, "name", "Home"));
        w.setIcon(WaypointsManager.optString(o, "icon", "star"));
        w.setColor(WaypointsManager.optInt(o, "color", -1));
        w.setVisible(WaypointsManager.optBool(o, "visible", true));
        w.setMaxVisible(WaypointsManager.optInt(o, "maxVisible", 5000));
        w.setScale(WaypointsManager.optDouble(o, "scale", 1.5));
        w.setLines(WaypointsManager.optBool(o, "lines", false));
        Waypoint.BeaconMode beaconMode = Waypoint.BeaconMode.OFF;
        if (o.has("beaconMode")) {
            try {
                beaconMode = Waypoint.BeaconMode.valueOf(WaypointsManager.optString(o, "beaconMode", "OFF"));
            }
            catch (Exception exception) {}
        } else if (WaypointsManager.optBool(o, "beacon", false)) {
            beaconMode = Waypoint.BeaconMode.ESP;
        }
        w.setBeaconMode(beaconMode);
        JsonObject pos = o.getAsJsonObject("pos");
        if (pos != null) {
            w.setPos(new class_2338(pos.get("x").getAsInt(), pos.get("y").getAsInt(), pos.get("z").getAsInt()));
        }
        w.setDimension(WaypointDimension.fromString(WaypointsManager.optString(o, "dimension", "OVERWORLD")));
        w.setOpposite(WaypointsManager.optBool(o, "opposite", false));
        try {
            w.setActionWhenNear(Waypoint.ActionWhenNear.valueOf(WaypointsManager.optString(o, "actionWhenNear", "DISABLED")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        w.setActionWhenNearDistance(WaypointsManager.optInt(o, "actionWhenNearDistance", 8));
        return w;
    }

    private static String optString(JsonObject o, String k, String d) {
        return o.has(k) ? o.get(k).getAsString() : d;
    }

    private static int optInt(JsonObject o, String k, int d) {
        return o.has(k) ? o.get(k).getAsInt() : d;
    }

    private static double optDouble(JsonObject o, String k, double d) {
        return o.has(k) ? o.get(k).getAsDouble() : d;
    }

    private static boolean optBool(JsonObject o, String k, boolean d) {
        return o.has(k) ? o.get(k).getAsBoolean() : d;
    }

    public record XaeroSyncStats(int imported, int updated, int skipped, int exported, List<Path> filesTouched) {
    }
}

