/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.client.world;

import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.LongObjectMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.ClientShip;
import org.valkyrienskies.core.api.ships.properties.ChunkClaim;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.compat.SodiumCompat;
import org.valkyrienskies.mod.compat.VSRenderer;
import org.valkyrienskies.mod.mixin.ValkyrienCommonMixinConfigPlugin;
import org.valkyrienskies.mod.mixin.accessors.client.multiplayer.ClientLevelAccessor;
import org.valkyrienskies.mod.mixin.accessors.client.render.LevelRendererAccessor;
import org.valkyrienskies.mod.mixinducks.client.render.IVSViewAreaMethods;
import org.valkyrienskies.mod.mixinducks.client.world.ClientChunkCacheDuck;
import org.valkyrienskies.mod.mixinducks.mod_compat.vanilla_renderer.LevelRendererDuck;

@Mixin(value={ClientChunkCache.class})
public abstract class MixinClientChunkCache
implements ClientChunkCacheDuck {
    @Shadow
    @Final
    ClientLevel f_104411_;
    @Unique
    private final LongObjectMap<LevelChunk> vs$shipChunks = new LongObjectHashMap();

    @Override
    public LongObjectMap<LevelChunk> vs$getShipChunks() {
        return this.vs$shipChunks;
    }

    @Inject(method={"replaceWithPacketData"}, at={@At(value="HEAD")}, cancellable=true)
    private void preLoadChunkFromPacket(int x2, int z2, FriendlyByteBuf buf, CompoundTag tag, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer, CallbackInfoReturnable<LevelChunk> cir) {
        if (VSGameUtilsKt.isChunkInShipyard((Level)this.f_104411_, x2, z2)) {
            LevelChunk worldChunk;
            ChunkPos pos;
            long chunkPosLong;
            LevelChunk oldChunk;
            LevelRenderer levelRenderer = Minecraft.m_91087_().f_91060_;
            if (levelRenderer instanceof LevelRendererDuck) {
                LevelRendererDuck levelRenderer2 = (LevelRendererDuck)levelRenderer;
                levelRenderer2.vs$setNeedsFrustumUpdate();
            }
            if ((oldChunk = (LevelChunk)this.vs$shipChunks.get(chunkPosLong = (pos = new ChunkPos(x2, z2)).m_45588_())) != null) {
                worldChunk = oldChunk;
                oldChunk.m_187971_(buf, tag, consumer);
            } else {
                worldChunk = new LevelChunk((Level)this.f_104411_, pos);
                worldChunk.m_187971_(buf, tag, consumer);
                this.vs$shipChunks.put(chunkPosLong, (Object)worldChunk);
            }
            this.f_104411_.m_171649_(pos);
            SodiumCompat.onChunkAdded(this.f_104411_, x2, z2);
            cir.setReturnValue((Object)worldChunk);
        }
    }

    @Override
    public void vs$removeShip(ClientShip ship) {
        ChunkClaim chunks = ship.getChunkClaim();
        for (int x2 = chunks.getXStart(); x2 <= chunks.getXEnd(); ++x2) {
            for (int z2 = chunks.getZStart(); z2 <= chunks.getZEnd(); ++z2) {
                this.removeShipChunk(x2, z2);
            }
        }
    }

    @Unique
    private void removeShipChunk(int chunkX, int chunkZ) {
        if (this.vs$shipChunks.remove(ChunkPos.m_45589_((int)chunkX, (int)chunkZ)) == null) {
            return;
        }
        if (ValkyrienCommonMixinConfigPlugin.getVSRenderer() != VSRenderer.SODIUM) {
            ((IVSViewAreaMethods)((LevelRendererAccessor)((ClientLevelAccessor)this.f_104411_).getLevelRenderer()).getViewArea()).unloadChunk(chunkX, chunkZ);
        }
        SodiumCompat.onChunkRemoved(this.f_104411_, chunkX, chunkZ);
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/level/chunk/ChunkStatus;Z)Lnet/minecraft/world/level/chunk/LevelChunk;"}, at={@At(value="HEAD")}, cancellable=true)
    public void preGetChunk(int chunkX, int chunkZ, ChunkStatus chunkStatus, boolean bl2, CallbackInfoReturnable<LevelChunk> cir) {
        LevelChunk shipChunk = (LevelChunk)this.vs$shipChunks.get(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
        if (shipChunk != null) {
            cir.setReturnValue((Object)shipChunk);
        }
    }
}

