/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependentRequired
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(DependentRequired.class);
    private final Map<String, List<String>> propertyDependencies = new HashMap<String, List<String>>();

    public DependentRequired(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.DEPENDENT_REQUIRED, validationContext);
        Iterator<String> it2 = schemaNode.fieldNames();
        while (it2.hasNext()) {
            String pname = it2.next();
            JsonNode pvalue = schemaNode.get(pname);
            if (!pvalue.isArray()) continue;
            List dependencies = this.propertyDependencies.computeIfAbsent(pname, k2 -> new ArrayList());
            for (int i2 = 0; i2 < pvalue.size(); ++i2) {
                dependencies.add(pvalue.get(i2).asText());
            }
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at2) {
        this.debug(logger, node, rootNode, at2);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        Iterator<String> it2 = node.fieldNames();
        while (it2.hasNext()) {
            String pname = it2.next();
            List<String> dependencies = this.propertyDependencies.get(pname);
            if (dependencies == null || dependencies.isEmpty()) continue;
            for (String field : dependencies) {
                if (node.get(field) != null) continue;
                errors.add(this.buildValidationMessage(at2, this.propertyDependencies.toString()));
            }
        }
        return Collections.unmodifiableSet(errors);
    }
}

