/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(EnumValidator.class);
    private final Set<JsonNode> nodes;
    private final String error;

    public EnumValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ENUM, validationContext);
        this.validationContext = validationContext;
        if (schemaNode != null && schemaNode.isArray()) {
            JsonNode nullable;
            this.nodes = new HashSet<JsonNode>();
            StringBuilder sb2 = new StringBuilder();
            sb2.append('[');
            String separator = "";
            for (JsonNode n2 : schemaNode) {
                if (n2.isNumber()) {
                    this.nodes.add(DecimalNode.valueOf(n2.decimalValue()));
                } else {
                    this.nodes.add(n2);
                }
                sb2.append(separator);
                sb2.append(n2.asText());
                separator = ", ";
            }
            if (validationContext.getConfig().isHandleNullableField() && (nullable = parentSchema.getSchemaNode().get("nullable")) != null && nullable.asBoolean()) {
                this.nodes.add(NullNode.getInstance());
                separator = ", ";
                sb2.append(separator);
                sb2.append("null");
            }
            sb2.append(']');
            this.error = sb2.toString();
        } else {
            this.nodes = Collections.emptySet();
            this.error = "[none]";
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at2) {
        this.debug(logger, node, rootNode, at2);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (node.isNumber()) {
            node = DecimalNode.valueOf(node.decimalValue());
        }
        if (!(this.nodes.contains(node) || this.validationContext.getConfig().isTypeLoose() && this.isTypeLooseContainsInEnum(node))) {
            errors.add(this.buildValidationMessage(at2, this.error));
        }
        return Collections.unmodifiableSet(errors);
    }

    private boolean isTypeLooseContainsInEnum(JsonNode node) {
        if (TypeFactory.getValueNodeType(node, this.validationContext.getConfig()) == JsonType.STRING) {
            String nodeText = node.textValue();
            for (JsonNode n2 : this.nodes) {
                String value = n2.asText();
                if (value == null || !value.equals(nodeText)) continue;
                return true;
            }
        }
        return false;
    }
}

