/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionTypeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnionTypeValidator.class);
    private final List<JsonValidator> schemas = new ArrayList<JsonValidator>();
    private final String error;

    public UnionTypeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.UNION_TYPE, validationContext);
        this.validationContext = validationContext;
        StringBuilder errorBuilder = new StringBuilder();
        String sep = "";
        errorBuilder.append('[');
        if (!schemaNode.isArray()) {
            throw new JsonSchemaException("Expected array for type property on Union Type Definition.");
        }
        int i2 = 0;
        for (JsonNode n2 : schemaNode) {
            JsonType t2 = TypeFactory.getSchemaNodeType(n2);
            errorBuilder.append(sep).append((Object)t2);
            sep = ", ";
            if (n2.isObject()) {
                this.schemas.add(new JsonSchema(validationContext, ValidatorTypeCode.TYPE.getValue(), parentSchema.getCurrentUri(), n2, parentSchema));
            } else {
                this.schemas.add(new TypeValidator(schemaPath + "/" + i2, n2, parentSchema, validationContext));
            }
            ++i2;
        }
        errorBuilder.append(']');
        this.error = errorBuilder.toString();
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at2) {
        this.debug(logger, node, rootNode, at2);
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.validationContext.getConfig());
        boolean valid = false;
        for (JsonValidator schema : this.schemas) {
            Set<ValidationMessage> errors = schema.validate(node, rootNode, at2);
            if (errors != null && !errors.isEmpty()) continue;
            valid = true;
            break;
        }
        if (!valid) {
            return Collections.singleton(this.buildValidationMessage(at2, nodeType.toString(), this.error));
        }
        return Collections.emptySet();
    }

    @Override
    public void preloadJsonSchema() {
        for (JsonValidator validator : this.schemas) {
            validator.preloadJsonSchema();
        }
    }
}

