/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.uri;

import com.networknt.schema.uri.ClasspathURLStreamHandler;
import com.networknt.schema.uri.URIFactory;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.Set;

public final class ClasspathURLFactory
implements URIFactory {
    static final URLStreamHandler STREAM_HANDLER = new ClasspathURLStreamHandler();
    public static final Set<String> SUPPORTED_SCHEMES = Collections.unmodifiableSet(ClasspathURLStreamHandler.SUPPORTED_SCHEMES);

    public static URL convert(URI uri) throws MalformedURLException {
        return new URL(null, uri.toString(), STREAM_HANDLER);
    }

    @Override
    public URI create(String uri) {
        try {
            return new URL(null, uri, STREAM_HANDLER).toURI();
        }
        catch (MalformedURLException e2) {
            throw new IllegalArgumentException("Unable to create URI.", e2);
        }
        catch (URISyntaxException e3) {
            throw new IllegalArgumentException("Unable to create URI.", e3);
        }
    }

    @Override
    public URI create(URI baseURI, String segment) {
        try {
            return new URL(ClasspathURLFactory.convert(baseURI), segment, STREAM_HANDLER).toURI();
        }
        catch (MalformedURLException e2) {
            throw new IllegalArgumentException("Unable to create URI.", e2);
        }
        catch (URISyntaxException e3) {
            throw new IllegalArgumentException("Unable to create URI.", e3);
        }
    }
}

