/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.MultiformatMessage;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.IndexedReadOnlyStringMap;
import org.apache.logging.log4j.util.IndexedStringMap;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;

@AsynchronouslyFormattable
@PerformanceSensitive(value={"allocation"})
public class MapMessage
implements MultiformatMessage,
StringBuilderFormattable {
    private static final long serialVersionUID = -5031471831131487120L;
    private final IndexedStringMap data;

    public MapMessage() {
        this.data = new SortedArrayStringMap();
    }

    public MapMessage(Map<String, String> map2) {
        this.data = new SortedArrayStringMap(map2);
    }

    @Override
    public String[] getFormats() {
        return MapFormat.names();
    }

    @Override
    public Object[] getParameters() {
        Object[] result2 = new Object[this.data.size()];
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            result2[i2] = this.data.getValueAt(i2);
        }
        return result2;
    }

    @Override
    public String getFormat() {
        return "";
    }

    public Map<String, String> getData() {
        TreeMap<String, String> result2 = new TreeMap<String, String>();
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            result2.put(this.data.getKeyAt(i2), (String)this.data.getValueAt(i2));
        }
        return Collections.unmodifiableMap(result2);
    }

    public IndexedReadOnlyStringMap getIndexedReadOnlyStringMap() {
        return this.data;
    }

    public void clear() {
        this.data.clear();
    }

    public MapMessage with(String key, String value) {
        this.put(key, value);
        return this;
    }

    public void put(String key, String value) {
        if (value == null) {
            throw new IllegalArgumentException("No value provided for key " + key);
        }
        this.validate(key, value);
        this.data.putValue(key, value);
    }

    protected void validate(String key, String value) {
    }

    public void putAll(Map<String, String> map2) {
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            this.data.putValue(entry.getKey(), entry.getValue());
        }
    }

    public String get(String key) {
        return (String)this.data.getValue(key);
    }

    public String remove(String key) {
        String result2 = (String)this.data.getValue(key);
        this.data.remove(key);
        return result2;
    }

    public String asString() {
        return this.format(null, new StringBuilder()).toString();
    }

    public String asString(String format) {
        try {
            return this.format(EnglishEnums.valueOf(MapFormat.class, format), new StringBuilder()).toString();
        }
        catch (IllegalArgumentException ex2) {
            return this.asString();
        }
    }

    private StringBuilder format(MapFormat format, StringBuilder sb2) {
        if (format == null) {
            this.appendMap(sb2);
        } else {
            switch (format) {
                case XML: {
                    this.asXml(sb2);
                    break;
                }
                case JSON: {
                    this.asJson(sb2);
                    break;
                }
                case JAVA: {
                    this.asJava(sb2);
                    break;
                }
                default: {
                    this.appendMap(sb2);
                }
            }
        }
        return sb2;
    }

    public void asXml(StringBuilder sb2) {
        sb2.append("<Map>\n");
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            sb2.append("  <Entry key=\"").append(this.data.getKeyAt(i2)).append("\">").append(this.data.getValueAt(i2)).append("</Entry>\n");
        }
        sb2.append("</Map>");
    }

    @Override
    public String getFormattedMessage() {
        return this.asString();
    }

    @Override
    public String getFormattedMessage(String[] formats) {
        if (formats == null || formats.length == 0) {
            return this.asString();
        }
        for (int i2 = 0; i2 < formats.length; ++i2) {
            MapFormat mapFormat = MapFormat.lookupIgnoreCase(formats[i2]);
            if (mapFormat == null) continue;
            return this.format(mapFormat, new StringBuilder()).toString();
        }
        return this.asString();
    }

    protected void appendMap(StringBuilder sb2) {
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            if (i2 > 0) {
                sb2.append(' ');
            }
            StringBuilders.appendKeyDqValue(sb2, this.data.getKeyAt(i2), this.data.getValueAt(i2));
        }
    }

    protected void asJson(StringBuilder sb2) {
        sb2.append('{');
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            if (i2 > 0) {
                sb2.append(", ");
            }
            StringBuilders.appendDqValue(sb2, this.data.getKeyAt(i2)).append(':');
            StringBuilders.appendDqValue(sb2, this.data.getValueAt(i2));
        }
        sb2.append('}');
    }

    protected void asJava(StringBuilder sb2) {
        sb2.append('{');
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            if (i2 > 0) {
                sb2.append(", ");
            }
            StringBuilders.appendKeyDqValue(sb2, this.data.getKeyAt(i2), this.data.getValueAt(i2));
        }
        sb2.append('}');
    }

    public MapMessage newInstance(Map<String, String> map2) {
        return new MapMessage(map2);
    }

    public String toString() {
        return this.asString();
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        this.format(null, buffer);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        MapMessage that = (MapMessage)o2;
        return this.data.equals(that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }

    public static enum MapFormat {
        XML,
        JSON,
        JAVA;


        public static MapFormat lookupIgnoreCase(String format) {
            return XML.name().equalsIgnoreCase(format) ? XML : (JSON.name().equalsIgnoreCase(format) ? JSON : (JAVA.name().equalsIgnoreCase(format) ? JAVA : null));
        }

        public static String[] names() {
            return new String[]{XML.name(), JSON.name(), JAVA.name()};
        }
    }
}

