/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Map;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.StructuredDataId;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;

@AsynchronouslyFormattable
public class StructuredDataMessage
extends MapMessage
implements StringBuilderFormattable {
    private static final long serialVersionUID = 1703221292892071920L;
    private static final int MAX_LENGTH = 32;
    private static final int HASHVAL = 31;
    private StructuredDataId id;
    private String message;
    private String type;

    public StructuredDataMessage(String id2, String msg, String type) {
        this.id = new StructuredDataId(id2, null, null);
        this.message = msg;
        this.type = type;
    }

    public StructuredDataMessage(String id2, String msg, String type, Map<String, String> data) {
        super(data);
        this.id = new StructuredDataId(id2, null, null);
        this.message = msg;
        this.type = type;
    }

    public StructuredDataMessage(StructuredDataId id2, String msg, String type) {
        this.id = id2;
        this.message = msg;
        this.type = type;
    }

    public StructuredDataMessage(StructuredDataId id2, String msg, String type, Map<String, String> data) {
        super(data);
        this.id = id2;
        this.message = msg;
        this.type = type;
    }

    private StructuredDataMessage(StructuredDataMessage msg, Map<String, String> map2) {
        super(map2);
        this.id = msg.id;
        this.message = msg.message;
        this.type = msg.type;
    }

    protected StructuredDataMessage() {
    }

    @Override
    public StructuredDataMessage with(String key, String value) {
        this.put(key, value);
        return this;
    }

    @Override
    public String[] getFormats() {
        String[] formats = new String[Format.values().length];
        int i2 = 0;
        for (Format format : Format.values()) {
            formats[i2++] = format.name();
        }
        return formats;
    }

    public StructuredDataId getId() {
        return this.id;
    }

    protected void setId(String id2) {
        this.id = new StructuredDataId(id2, null, null);
    }

    protected void setId(StructuredDataId id2) {
        this.id = id2;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        if (type.length() > 32) {
            throw new IllegalArgumentException("structured data type exceeds maximum length of 32 characters: " + type);
        }
        this.type = type;
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        this.asString(Format.FULL, null, buffer);
    }

    @Override
    public String getFormat() {
        return this.message;
    }

    protected void setMessageFormat(String msg) {
        this.message = msg;
    }

    @Override
    protected void validate(String key, String value) {
        this.validateKey(key);
    }

    private void validateKey(String key) {
        if (key.length() > 32) {
            throw new IllegalArgumentException("Structured data keys are limited to 32 characters. key: " + key);
        }
        for (int i2 = 0; i2 < key.length(); ++i2) {
            char c2 = key.charAt(i2);
            if (c2 >= '!' && c2 <= '~' && c2 != '=' && c2 != ']' && c2 != '\"') continue;
            throw new IllegalArgumentException("Structured data keys must contain printable US ASCII charactersand may not contain a space, =, ], or \"");
        }
    }

    @Override
    public String asString() {
        return this.asString(Format.FULL, null);
    }

    @Override
    public String asString(String format) {
        try {
            return this.asString(EnglishEnums.valueOf(Format.class, format), null);
        }
        catch (IllegalArgumentException ex2) {
            return this.asString();
        }
    }

    public final String asString(Format format, StructuredDataId structuredDataId) {
        StringBuilder sb2 = new StringBuilder();
        this.asString(format, structuredDataId, sb2);
        return sb2.toString();
    }

    public final void asString(Format format, StructuredDataId structuredDataId, StringBuilder sb2) {
        String msg;
        StructuredDataId sdId;
        boolean full = Format.FULL.equals((Object)format);
        if (full) {
            String myType = this.getType();
            if (myType == null) {
                return;
            }
            sb2.append(this.getType()).append(' ');
        }
        if ((sdId = (sdId = this.getId()) != null ? sdId.makeId(structuredDataId) : structuredDataId) == null || sdId.getName() == null) {
            return;
        }
        sb2.append('[');
        StringBuilders.appendValue(sb2, sdId);
        sb2.append(' ');
        this.appendMap(sb2);
        sb2.append(']');
        if (full && (msg = this.getFormat()) != null) {
            sb2.append(' ').append(msg);
        }
    }

    @Override
    public String getFormattedMessage() {
        return this.asString(Format.FULL, null);
    }

    @Override
    public String getFormattedMessage(String[] formats) {
        if (formats != null && formats.length > 0) {
            for (int i2 = 0; i2 < formats.length; ++i2) {
                String format = formats[i2];
                if (Format.XML.name().equalsIgnoreCase(format)) {
                    return this.asXml();
                }
                if (!Format.FULL.name().equalsIgnoreCase(format)) continue;
                return this.asString(Format.FULL, null);
            }
            return this.asString(null, null);
        }
        return this.asString(Format.FULL, null);
    }

    private String asXml() {
        StringBuilder sb2 = new StringBuilder();
        StructuredDataId sdId = this.getId();
        if (sdId == null || sdId.getName() == null || this.type == null) {
            return sb2.toString();
        }
        sb2.append("<StructuredData>\n");
        sb2.append("<type>").append(this.type).append("</type>\n");
        sb2.append("<id>").append(sdId).append("</id>\n");
        super.asXml(sb2);
        sb2.append("</StructuredData>\n");
        return sb2.toString();
    }

    @Override
    public String toString() {
        return this.asString(null, null);
    }

    @Override
    public MapMessage newInstance(Map<String, String> map2) {
        return new StructuredDataMessage(this, map2);
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        StructuredDataMessage that = (StructuredDataMessage)o2;
        if (!super.equals(o2)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.type != null ? this.type.hashCode() : 0);
        result2 = 31 * result2 + (this.id != null ? this.id.hashCode() : 0);
        result2 = 31 * result2 + (this.message != null ? this.message.hashCode() : 0);
        return result2;
    }

    public static enum Format {
        XML,
        FULL;

    }
}

