/*
 * Decompiled with CFR 0.152.
 */
package org.joml.primitives;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2fc;

public class Circlef
implements Externalizable {
    public float x;
    public float y;
    public float r;

    public Circlef() {
    }

    public Circlef(Circlef source) {
        this.x = source.x;
        this.y = source.y;
        this.r = source.r;
    }

    public Circlef(float x2, float y2, float r2) {
        this.x = x2;
        this.y = y2;
        this.r = r2;
    }

    public Circlef translate(Vector2fc xy2) {
        return this.translate(xy2.x(), xy2.y(), this);
    }

    public Circlef translate(Vector2fc xy2, Circlef dest) {
        return this.translate(xy2.x(), xy2.y(), dest);
    }

    public Circlef translate(float x2, float y2) {
        return this.translate(x2, y2, this);
    }

    public Circlef translate(float x2, float y2, Circlef dest) {
        dest.x = this.x + x2;
        dest.y = this.y + y2;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + Float.floatToIntBits(this.r);
        result2 = 31 * result2 + Float.floatToIntBits(this.x);
        result2 = 31 * result2 + Float.floatToIntBits(this.y);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Circlef other = (Circlef)obj;
        if (Float.floatToIntBits(this.r) != Float.floatToIntBits(other.r)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(other.y);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + Runtime.format(this.x, formatter) + " " + Runtime.format(this.y, formatter) + " " + Runtime.format(this.r, formatter) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.r);
    }

    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        this.x = in2.readFloat();
        this.y = in2.readFloat();
        this.r = in2.readFloat();
    }
}

