/*
 * Decompiled with CFR 0.152.
 */
package org.joml.primitives;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.primitives.Rectanglef;
import org.joml.primitives.Rectanglei;

public class Rectangled
implements Externalizable {
    public double minX;
    public double minY;
    public double maxX;
    public double maxY;

    public Rectangled() {
    }

    public Rectangled(Rectangled source) {
        this.minX = source.minX;
        this.minY = source.minY;
        this.maxX = source.maxX;
        this.maxY = source.maxY;
    }

    public Rectangled(Vector2dc min, Vector2dc max) {
        this.minX = min.x();
        this.minY = min.y();
        this.maxX = max.x();
        this.maxY = max.y();
    }

    public Rectangled(double minX, double minY, double maxX, double maxY) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public Rectangled set(Rectangled source) {
        this.minX = source.minX;
        this.minY = source.minY;
        this.maxX = source.maxX;
        this.maxY = source.maxY;
        return this;
    }

    public Rectangled setMin(double minX, double minY) {
        this.minX = minX;
        this.minY = minY;
        return this;
    }

    public Rectangled setMin(Vector2dc min) {
        this.minX = min.x();
        this.minY = min.y();
        return this;
    }

    public Rectangled setMax(double maxX, double maxY) {
        this.maxX = maxX;
        this.maxY = maxY;
        return this;
    }

    public Rectangled setMax(Vector2dc max) {
        this.maxX = max.x();
        this.maxY = max.y();
        return this;
    }

    public double lengthX() {
        return this.maxX - this.minX;
    }

    public double lengthY() {
        return this.maxY - this.minY;
    }

    public double area() {
        return this.lengthX() * this.lengthY();
    }

    private Rectangled validate() {
        if (!this.isValid()) {
            this.minX = Double.NaN;
            this.minY = Double.NaN;
            this.maxX = Double.NaN;
            this.maxY = Double.NaN;
        }
        return this;
    }

    public boolean isValid() {
        return this.minX < this.maxX && this.minY < this.maxY;
    }

    public Rectangled intersection(Rectangled other) {
        return this.intersection(other, this);
    }

    public Rectangled intersection(Rectangled other, Rectangled dest) {
        dest.minX = Math.max(this.minX, other.minX);
        dest.minY = Math.max(this.minY, other.minY);
        dest.maxX = Math.min(this.maxX, other.maxX);
        dest.maxY = Math.min(this.maxY, other.maxY);
        return dest.validate();
    }

    public Rectangled intersection(Rectanglef other, Rectangled dest) {
        dest.minX = Math.max(this.minX, (double)other.minX);
        dest.minY = Math.max(this.minY, (double)other.minY);
        dest.maxX = Math.min(this.maxX, (double)other.maxX);
        dest.maxY = Math.min(this.maxY, (double)other.maxY);
        return dest.validate();
    }

    public Rectangled intersection(Rectanglei other, Rectangled dest) {
        dest.minX = Math.max(this.minX, (double)other.minX);
        dest.minY = Math.max(this.minY, (double)other.minY);
        dest.maxX = Math.min(this.maxX, (double)other.maxX);
        dest.maxY = Math.min(this.maxY, (double)other.maxY);
        return dest.validate();
    }

    public Vector2d lengths(Vector2d dest) {
        return dest.set(this.lengthX(), this.lengthY());
    }

    public boolean containsRectangle(Rectangled rectangle) {
        return rectangle.minX >= this.minX && rectangle.maxX <= this.maxX && rectangle.minY >= this.minY && rectangle.maxY <= this.maxY;
    }

    public boolean containsRectangle(Rectanglef rectangle) {
        return (double)rectangle.minX >= this.minX && (double)rectangle.maxX <= this.maxX && (double)rectangle.minY >= this.minY && (double)rectangle.maxY <= this.maxY;
    }

    public boolean containsRectangle(Rectanglei rectangle) {
        return (double)rectangle.minX >= this.minX && (double)rectangle.maxX <= this.maxX && (double)rectangle.minY >= this.minY && (double)rectangle.maxY <= this.maxY;
    }

    public Rectangled union(double x2, double y2) {
        return this.union(x2, y2, this);
    }

    public Rectangled union(Vector2dc p2) {
        return this.union(p2.x(), p2.y(), this);
    }

    public Rectangled union(double x2, double y2, Rectangled dest) {
        dest.minX = this.minX < x2 ? this.minX : x2;
        dest.minY = this.minY < y2 ? this.minY : y2;
        dest.maxX = this.maxX > x2 ? this.maxX : x2;
        dest.maxY = this.maxY > y2 ? this.maxY : y2;
        return dest;
    }

    public Rectangled union(Vector2dc p2, Rectangled dest) {
        return this.union(p2.x(), p2.y(), dest);
    }

    public Rectangled union(Rectangled other) {
        return this.union(other, this);
    }

    public Rectangled union(Rectangled other, Rectangled dest) {
        dest.minX = this.minX < other.minX ? this.minX : other.minX;
        dest.minY = this.minY < other.minY ? this.minY : other.minY;
        dest.maxX = this.maxX > other.maxX ? this.maxX : other.maxX;
        dest.maxY = this.maxY > other.maxY ? this.maxY : other.maxY;
        return dest;
    }

    public boolean intersectsRectangle(Rectangled other) {
        return this.minX < other.maxX && this.maxX > other.minX && this.maxY > other.minY && this.minY < other.maxY;
    }

    public boolean intersectsRectangle(Rectanglef other) {
        return this.minX < (double)other.maxX && this.maxX > (double)other.minX && this.maxY > (double)other.minY && this.minY < (double)other.maxY;
    }

    public boolean intersectsRectangle(Rectanglei other) {
        return this.minX < (double)other.maxX && this.maxX > (double)other.minX && this.maxY > (double)other.minY && this.minY < (double)other.maxY;
    }

    public boolean containsPoint(Vector2dc point) {
        return this.containsPoint(point.x(), point.y());
    }

    public boolean containsPoint(double x2, double y2) {
        return x2 > this.minX && y2 > this.minY && x2 < this.maxX && y2 < this.maxY;
    }

    public Rectangled translate(Vector2dc xy2) {
        return this.translate(xy2.x(), xy2.y(), this);
    }

    public Rectangled translate(Vector2dc xy2, Rectangled dest) {
        return this.translate(xy2.x(), xy2.y(), dest);
    }

    public Rectangled translate(Vector2fc xy2) {
        return this.translate(xy2.x(), xy2.y(), this);
    }

    public Rectangled translate(Vector2fc xy2, Rectangled dest) {
        return this.translate(xy2.x(), xy2.y(), dest);
    }

    public Rectangled translate(double x2, double y2) {
        return this.translate(x2, y2, this);
    }

    public Rectangled translate(double x2, double y2, Rectangled dest) {
        dest.minX = this.minX + x2;
        dest.minY = this.minY + y2;
        dest.maxX = this.maxX + x2;
        dest.maxY = this.maxY + y2;
        return dest;
    }

    public Rectangled scale(double sf2) {
        return this.scale(sf2, sf2);
    }

    public Rectangled scale(double sf2, Rectangled dest) {
        return this.scale(sf2, sf2, dest);
    }

    public Rectangled scale(double sf2, double ax2, double ay2) {
        return this.scale(sf2, sf2, ax2, ay2);
    }

    public Rectangled scale(double sf2, double ax2, double ay2, Rectangled dest) {
        return this.scale(sf2, sf2, ax2, ay2, dest);
    }

    public Rectangled scale(double sf2, Vector2dc anchor) {
        return this.scale(sf2, anchor.x(), anchor.y());
    }

    public Rectangled scale(double sf2, Vector2dc anchor, Rectangled dest) {
        return this.scale(sf2, anchor.x(), anchor.y(), dest);
    }

    public Rectangled scale(double sx2, double sy2) {
        return this.scale(sx2, sy2, 0.0, 0.0);
    }

    public Rectangled scale(double sx2, double sy2, Rectangled dest) {
        return this.scale(sx2, sy2, 0.0, 0.0, dest);
    }

    public Rectangled scale(double sx2, double sy2, double ax2, double ay2) {
        this.minX = (this.minX - ax2) * sx2 + ax2;
        this.minY = (this.minY - ay2) * sy2 + ay2;
        this.maxX = (this.maxX - ax2) * sx2 + ax2;
        this.maxY = (this.maxY - ay2) * sy2 + ay2;
        return this;
    }

    public Rectangled scale(double sx2, double sy2, Vector2dc anchor) {
        return this.scale(sx2, sy2, anchor.x(), anchor.y());
    }

    public Rectangled scale(double sx2, double sy2, double ax2, double ay2, Rectangled dest) {
        dest.minX = (this.minX - ax2) * sx2 + ax2;
        dest.minY = (this.minY - ay2) * sy2 + ay2;
        dest.maxX = (this.maxX - ax2) * sx2 + ax2;
        dest.maxY = (this.maxY - ay2) * sy2 + ay2;
        return dest;
    }

    public Rectangled scale(double sx2, double sy2, Vector2dc anchor, Rectangled dest) {
        return this.scale(sx2, sy2, anchor.x(), anchor.y(), dest);
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        long temp = Double.doubleToLongBits(this.maxX);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxY);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minX);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minY);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectangled other = (Rectangled)obj;
        if (Double.doubleToLongBits(this.maxX) != Double.doubleToLongBits(other.maxX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxY) != Double.doubleToLongBits(other.maxY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minX) != Double.doubleToLongBits(other.minX)) {
            return false;
        }
        return Double.doubleToLongBits(this.minY) == Double.doubleToLongBits(other.minY);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + Runtime.format(this.minX, formatter) + " " + Runtime.format(this.minY, formatter) + ") < (" + Runtime.format(this.maxX, formatter) + " " + Runtime.format(this.maxY, formatter) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.minX);
        out.writeDouble(this.minY);
        out.writeDouble(this.maxX);
        out.writeDouble(this.maxY);
    }

    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        this.minX = in2.readDouble();
        this.minY = in2.readDouble();
        this.maxX = in2.readDouble();
        this.maxY = in2.readDouble();
    }
}

