/*
 * Decompiled with CFR 0.152.
 */
package org.joml.primitives;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector3fc;

public class Spheref
implements Externalizable {
    public float x;
    public float y;
    public float z;
    public float r;

    public Spheref() {
    }

    public Spheref(Spheref source) {
        this.x = source.x;
        this.y = source.y;
        this.z = source.z;
        this.r = source.r;
    }

    public Spheref(Vector3fc c2, float r2) {
        this.x = c2.x();
        this.y = c2.y();
        this.z = c2.z();
        this.r = r2;
    }

    public Spheref(float x2, float y2, float z2, float r2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.r = r2;
    }

    public Spheref translate(Vector3fc xyz) {
        return this.translate(xyz.x(), xyz.y(), xyz.z(), this);
    }

    public Spheref translate(Vector3fc xyz, Spheref dest) {
        return this.translate(xyz.x(), xyz.y(), xyz.z(), dest);
    }

    public Spheref translate(float x2, float y2, float z2) {
        return this.translate(x2, y2, z2, this);
    }

    public Spheref translate(float x2, float y2, float z2, Spheref dest) {
        dest.x = this.x + x2;
        dest.y = this.y + y2;
        dest.z = this.z + z2;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + Float.floatToIntBits(this.r);
        result2 = 31 * result2 + Float.floatToIntBits(this.x);
        result2 = 31 * result2 + Float.floatToIntBits(this.y);
        result2 = 31 * result2 + Float.floatToIntBits(this.z);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Spheref other = (Spheref)obj;
        if (Float.floatToIntBits(this.r) != Float.floatToIntBits(other.r)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "[" + Runtime.format(this.x, formatter) + " " + Runtime.format(this.y, formatter) + " " + Runtime.format(this.z, formatter) + " " + Runtime.format(this.r, formatter) + "]";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
        out.writeFloat(this.r);
    }

    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        this.x = in2.readFloat();
        this.y = in2.readFloat();
        this.z = in2.readFloat();
        this.r = in2.readFloat();
    }
}

