/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.api.world;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J$\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0013\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0004R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0014\u001a\u0004\b\u0015\u0010\u0004R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0016\u0010\u0004R\u0011\u0010\u0018\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0004\u00a8\u0006\u001b"}, d2={"Lorg/valkyrienskies/core/api/world/LevelYRange;", "", "", "component1", "()I", "component2", "minY", "maxY", "copy", "(II)Lorg/valkyrienskies/core/api/world/LevelYRange;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "getCenter", "center", "I", "getMaxY", "getMinY", "getSize", "size", "<init>", "(II)V", "api"})
public final class LevelYRange {
    private final int minY;
    private final int maxY;

    public LevelYRange(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
        int n2 = this.minY;
        int n3 = 16;
        int n4 = n2 % n3;
        if (n4 + (n3 & ((n4 ^ n3) & (n4 | -n4)) >> 31) != 0) {
            throw new IllegalArgumentException("minY must be congruent to 0 mod 16");
        }
        n2 = this.maxY + 1;
        n3 = 16;
        n4 = n2 % n3;
        if (n4 + (n3 & ((n4 ^ n3) & (n4 | -n4)) >> 31) != 0) {
            throw new IllegalArgumentException("maxY must be congruent to 15 mod 16");
        }
        if (this.maxY < this.minY) {
            throw new IllegalArgumentException("maxY must not be less than minY");
        }
    }

    public final int getMinY() {
        return this.minY;
    }

    public final int getMaxY() {
        return this.maxY;
    }

    public final int getCenter() {
        return (this.minY + this.maxY + 1) / 2;
    }

    public final int getSize() {
        return this.maxY - this.minY + 1;
    }

    public final int component1() {
        return this.minY;
    }

    public final int component2() {
        return this.maxY;
    }

    @NotNull
    public final LevelYRange copy(int minY, int maxY) {
        return new LevelYRange(minY, maxY);
    }

    public static /* synthetic */ LevelYRange copy$default(LevelYRange levelYRange, int n2, int n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n2 = levelYRange.minY;
        }
        if ((n4 & 2) != 0) {
            n3 = levelYRange.maxY;
        }
        return levelYRange.copy(n2, n3);
    }

    @NotNull
    public String toString() {
        return "LevelYRange(minY=" + this.minY + ", maxY=" + this.maxY + ')';
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.minY);
        result2 = result2 * 31 + Integer.hashCode(this.maxY);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LevelYRange)) {
            return false;
        }
        LevelYRange levelYRange = (LevelYRange)other;
        if (this.minY != levelYRange.minY) {
            return false;
        }
        return this.maxY == levelYRange.maxY;
    }
}

