/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.collision;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.primitives.AABBi;
import org.valkyrienskies.physics_api.voxel.CollisionPoint;
import org.valkyrienskies.physics_api.voxel.Lod1SolidBoxesCollisionShape;
import org.valkyrienskies.physics_api.voxel.LodBlockBoundingBox;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J+\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0005\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000e\u001a\u0004\u0018\u00010\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013"}, d2={"Lorg/valkyrienskies/core/impl/collision/Lod1SolidShapeUtils;", "", "", "Lorg/valkyrienskies/physics_api/voxel/LodBlockBoundingBox;", "boxes", "cut", "cutBoxes", "(Ljava/util/List;Lorg/valkyrienskies/physics_api/voxel/LodBlockBoundingBox;)Ljava/util/List;", "", "Lorg/valkyrienskies/physics_api/voxel/CollisionPoint;", "generateCollisionPointsForBoxes", "(Ljava/util/List;)Ljava/util/List;", "posBoxes", "Lorg/valkyrienskies/physics_api/voxel/Lod1SolidBoxesCollisionShape;", "generateShapeFromBoxes", "(Ljava/util/List;)Lorg/valkyrienskies/physics_api/voxel/Lod1SolidBoxesCollisionShape;", "mergeBoxes", "", "MAX_BOXES", "I", "MAX_POINTS", "<init>", "()V"})
public final class Lod1SolidShapeUtils {
    public static final Lod1SolidShapeUtils INSTANCE = new Lod1SolidShapeUtils();
    private static final int MAX_BOXES = 10;
    private static final int MAX_POINTS = 20;

    private Lod1SolidShapeUtils() {
    }

    public final List<LodBlockBoundingBox> mergeBoxes(List<LodBlockBoundingBox> boxes) {
        Intrinsics.checkNotNullParameter(boxes, (String)"");
        if (boxes.size() < 2) {
            return boxes;
        }
        boolean bl2 = false;
        block0: while (!bl2) {
            int n2 = boxes.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = boxes.size();
                for (int i3 = i2 + 1; i3 < n3; ++i3) {
                    LodBlockBoundingBox lodBlockBoundingBox = Lod1SolidShapeUtils.mergeBoxes$tryMerging(boxes.get(i2), boxes.get(i3));
                    if (lodBlockBoundingBox == null) continue;
                    boxes.remove(i3);
                    boxes.remove(i2);
                    boxes.add(lodBlockBoundingBox);
                    continue block0;
                }
            }
            bl2 = true;
        }
        return boxes;
    }

    private final List<LodBlockBoundingBox> cutBoxes(List<LodBlockBoundingBox> boxes, LodBlockBoundingBox cut) {
        AABBi aABBi = new AABBi();
        AABBi aABBi2 = new AABBi();
        if (boxes.isEmpty()) {
            return boxes;
        }
        boolean bl2 = false;
        block0: while (!bl2) {
            int n2 = boxes.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                LodBlockBoundingBox lodBlockBoundingBox = boxes.get(i2);
                if (!Lod1SolidShapeUtils.cutBoxes$intersects(aABBi, aABBi2, lodBlockBoundingBox, cut)) continue;
                boxes.remove(i2);
                Lod1SolidShapeUtils.cutBoxes$cutBox(lodBlockBoundingBox, cut, boxes);
                continue block0;
            }
            bl2 = true;
        }
        return boxes;
    }

    private final List<CollisionPoint> generateCollisionPointsForBoxes(List<LodBlockBoundingBox> boxes) {
        ArrayList<CollisionPoint> arrayList = new ArrayList<CollisionPoint>();
        for (LodBlockBoundingBox lodBlockBoundingBox : boxes) {
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            int n2 = lodBlockBoundingBox.getMaxX() + 1 - lodBlockBoundingBox.getMinX();
            int n3 = lodBlockBoundingBox.getMaxY() + 1 - lodBlockBoundingBox.getMinY();
            int n4 = lodBlockBoundingBox.getMaxZ() + 1 - lodBlockBoundingBox.getMinZ();
            if (n2 * 2 <= n3 && n2 * 2 <= n4) {
                f7 = (float)n2 / 2.0f;
                f6 = (float)(lodBlockBoundingBox.getMaxX() + 1 + lodBlockBoundingBox.getMinX()) / 2.0f;
                f5 = (float)lodBlockBoundingBox.getMinY() + f7;
                f4 = (float)lodBlockBoundingBox.getMinZ() + f7;
                f3 = (float)(lodBlockBoundingBox.getMaxY() + 1) - f7;
                f2 = (float)(lodBlockBoundingBox.getMaxZ() + 1) - f7;
                arrayList.add(new CollisionPoint(new Vector3f(f6 / 16.0f, f5 / 16.0f, f4 / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(f6 / 16.0f, f5 / 16.0f, f2 / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(f6 / 16.0f, f3 / 16.0f, f4 / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(f6 / 16.0f, f3 / 16.0f, f2 / 16.0f), f7 / 16.0f));
                continue;
            }
            if (n3 * 2 <= n2 && n3 * 2 <= n4) {
                f7 = (float)n3 / 2.0f;
                f6 = (float)(lodBlockBoundingBox.getMaxY() + 1 + lodBlockBoundingBox.getMinY()) / 2.0f;
                f5 = (float)lodBlockBoundingBox.getMinX() + f7;
                f4 = (float)lodBlockBoundingBox.getMinZ() + f7;
                f3 = (float)(lodBlockBoundingBox.getMaxX() + 1) - f7;
                f2 = (float)(lodBlockBoundingBox.getMaxZ() + 1) - f7;
                arrayList.add(new CollisionPoint(new Vector3f(f5 / 16.0f, f6 / 16.0f, f4 / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(f5 / 16.0f, f6 / 16.0f, f2 / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(f3 / 16.0f, f6 / 16.0f, f4 / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(f3 / 16.0f, f6 / 16.0f, f2 / 16.0f), f7 / 16.0f));
                continue;
            }
            if (n4 * 2 <= n2 && n4 * 2 <= n3) {
                f7 = (float)n4 / 2.0f;
                f6 = (float)(lodBlockBoundingBox.getMaxZ() + 1 + lodBlockBoundingBox.getMinZ()) / 2.0f;
                f5 = (float)lodBlockBoundingBox.getMinX() + f7;
                f4 = (float)lodBlockBoundingBox.getMinY() + f7;
                f3 = (float)(lodBlockBoundingBox.getMaxX() + 1) - f7;
                f2 = (float)(lodBlockBoundingBox.getMaxY() + 1) - f7;
                arrayList.add(new CollisionPoint(new Vector3f(f5 / 16.0f, f4 / 16.0f, f6 / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(f5 / 16.0f, f2 / 16.0f, f6 / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(f3 / 16.0f, f4 / 16.0f, f6 / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(f3 / 16.0f, f2 / 16.0f, f6 / 16.0f), f7 / 16.0f));
                continue;
            }
            if (n2 >= 2 * n3 && n2 >= 2 * n4) {
                f7 = (float)Math.min(n3, n4) / 2.0f;
                f6 = (float)(lodBlockBoundingBox.getMaxY() + 1 + lodBlockBoundingBox.getMinY()) / 2.0f;
                f5 = (float)(lodBlockBoundingBox.getMaxZ() + 1 + lodBlockBoundingBox.getMinZ()) / 2.0f;
                arrayList.add(new CollisionPoint(new Vector3f(((float)lodBlockBoundingBox.getMinX() + f7) / 16.0f, f6 / 16.0f, f5 / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f((float)(lodBlockBoundingBox.getMaxX() + 1 + lodBlockBoundingBox.getMinX()) / 2.0f / 16.0f, f6 / 16.0f, f5 / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(((float)(lodBlockBoundingBox.getMaxX() + 1) - f7) / 16.0f, f6 / 16.0f, f5 / 16.0f), f7 / 16.0f));
                continue;
            }
            if (n3 >= 2 * n2 && n3 >= 2 * n4) {
                f7 = (float)Math.min(n2, n4) / 2.0f;
                f6 = (float)(lodBlockBoundingBox.getMaxX() + 1 + lodBlockBoundingBox.getMinX()) / 2.0f;
                f5 = (float)(lodBlockBoundingBox.getMaxZ() + 1 + lodBlockBoundingBox.getMinZ()) / 2.0f;
                arrayList.add(new CollisionPoint(new Vector3f(f6 / 16.0f, ((float)lodBlockBoundingBox.getMinY() + f7) / 16.0f, f5 / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(f6 / 16.0f, (float)(lodBlockBoundingBox.getMaxY() + 1 + lodBlockBoundingBox.getMinY()) / 2.0f / 16.0f, f5 / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(f6 / 16.0f, ((float)(lodBlockBoundingBox.getMaxY() + 1) - f7) / 16.0f, f5 / 16.0f), f7 / 16.0f));
                continue;
            }
            if (n4 >= 2 * n2 && n4 >= 2 * n3) {
                f7 = (float)Math.min(n2, n3) / 2.0f;
                f6 = (float)(lodBlockBoundingBox.getMaxX() + 1 + lodBlockBoundingBox.getMinX()) / 2.0f;
                f5 = (float)(lodBlockBoundingBox.getMaxY() + 1 + lodBlockBoundingBox.getMinY()) / 2.0f;
                arrayList.add(new CollisionPoint(new Vector3f(f6 / 16.0f, f5 / 16.0f, ((float)lodBlockBoundingBox.getMinZ() + f7) / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(f6 / 16.0f, f5 / 16.0f, (float)(lodBlockBoundingBox.getMaxZ() + 1 + lodBlockBoundingBox.getMinZ()) / 2.0f / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(f6 / 16.0f, f5 / 16.0f, ((float)(lodBlockBoundingBox.getMaxZ() + 1) - f7) / 16.0f), f7 / 16.0f));
                continue;
            }
            if (boxes.size() == 1) {
                f7 = (float)Math.min(n2, Math.min(n3, n4)) / 4.0f;
                arrayList.add(new CollisionPoint(new Vector3f(((float)lodBlockBoundingBox.getMinX() + f7) / 16.0f, ((float)lodBlockBoundingBox.getMinY() + f7) / 16.0f, ((float)lodBlockBoundingBox.getMinZ() + f7) / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(((float)lodBlockBoundingBox.getMinX() + f7) / 16.0f, ((float)lodBlockBoundingBox.getMinY() + f7) / 16.0f, ((float)lodBlockBoundingBox.getMaxZ() + 1.0f - f7) / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(((float)lodBlockBoundingBox.getMinX() + f7) / 16.0f, ((float)lodBlockBoundingBox.getMaxY() + 1.0f - f7) / 16.0f, ((float)lodBlockBoundingBox.getMinZ() + f7) / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(((float)lodBlockBoundingBox.getMinX() + f7) / 16.0f, ((float)lodBlockBoundingBox.getMaxY() + 1.0f - f7) / 16.0f, ((float)lodBlockBoundingBox.getMaxZ() + 1.0f - f7) / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(((float)lodBlockBoundingBox.getMaxX() + 1.0f - f7) / 16.0f, ((float)lodBlockBoundingBox.getMinY() + f7) / 16.0f, ((float)lodBlockBoundingBox.getMinZ() + f7) / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(((float)lodBlockBoundingBox.getMaxX() + 1.0f - f7) / 16.0f, ((float)lodBlockBoundingBox.getMinY() + f7) / 16.0f, ((float)lodBlockBoundingBox.getMaxZ() + 1.0f - f7) / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(((float)lodBlockBoundingBox.getMaxX() + 1.0f - f7) / 16.0f, ((float)lodBlockBoundingBox.getMaxY() + 1.0f - f7) / 16.0f, ((float)lodBlockBoundingBox.getMinZ() + f7) / 16.0f), f7 / 16.0f));
                arrayList.add(new CollisionPoint(new Vector3f(((float)lodBlockBoundingBox.getMaxX() + 1.0f - f7) / 16.0f, ((float)lodBlockBoundingBox.getMaxY() + 1.0f - f7) / 16.0f, ((float)lodBlockBoundingBox.getMaxZ() + 1.0f - f7) / 16.0f), f7 / 16.0f));
                continue;
            }
            f7 = (float)Math.min(n2, Math.min(n3, n4)) / 2.0f;
            f6 = (float)(lodBlockBoundingBox.getMaxX() + 1 + lodBlockBoundingBox.getMinX()) / 2.0f;
            f5 = (float)(lodBlockBoundingBox.getMaxY() + 1 + lodBlockBoundingBox.getMinY()) / 2.0f;
            f4 = (float)(lodBlockBoundingBox.getMaxZ() + 1 + lodBlockBoundingBox.getMinZ()) / 2.0f;
            arrayList.add(new CollisionPoint(new Vector3f(f6 / 16.0f, f5 / 16.0f, f4 / 16.0f), f7 / 16.0f));
        }
        return arrayList;
    }

    public final Lod1SolidBoxesCollisionShape generateShapeFromBoxes(List<LodBlockBoundingBox> posBoxes) {
        Intrinsics.checkNotNullParameter(posBoxes, (String)"");
        if (posBoxes.isEmpty()) {
            return new Lod1SolidBoxesCollisionShape(LodBlockBoundingBox.Companion.createEmptyVSBoundingBox(), CollectionsKt.emptyList(), CollectionsKt.emptyList(), CollectionsKt.listOf((Object)LodBlockBoundingBox.Companion.createFullVSBoundingBox()));
        }
        this.mergeBoxes(posBoxes);
        if (posBoxes.size() > 10) {
            return null;
        }
        Object object2 = new LodBlockBoundingBox[]{LodBlockBoundingBox.Companion.createFullVSBoundingBox()};
        List<LodBlockBoundingBox> list = CollectionsKt.mutableListOf((Object[])object2);
        for (LodBlockBoundingBox object3 : posBoxes) {
            list = this.cutBoxes(list, object3);
        }
        this.mergeBoxes(list);
        if (list.size() > 10) {
            return null;
        }
        object2 = this.generateCollisionPointsForBoxes(posBoxes);
        if (object2.size() > 20) {
            return null;
        }
        Vector3i vector3i = new Vector3i(posBoxes.get(0).getMinX(), posBoxes.get(0).getMinY(), (int)posBoxes.get(0).getMinZ());
        Vector3i vector3i2 = new Vector3i(posBoxes.get(0).getMaxX(), posBoxes.get(0).getMaxY(), (int)posBoxes.get(0).getMaxZ());
        int n2 = posBoxes.size();
        for (int lodBlockBoundingBox = 1; lodBlockBoundingBox < n2; ++lodBlockBoundingBox) {
            vector3i.x = Math.min(vector3i.x, posBoxes.get(lodBlockBoundingBox).getMinX());
            vector3i.y = Math.min(vector3i.y, posBoxes.get(lodBlockBoundingBox).getMinY());
            vector3i.z = Math.min(vector3i.z, posBoxes.get(lodBlockBoundingBox).getMinZ());
            vector3i2.x = Math.max(vector3i2.x, posBoxes.get(lodBlockBoundingBox).getMaxX());
            vector3i2.y = Math.max(vector3i2.y, posBoxes.get(lodBlockBoundingBox).getMaxY());
            vector3i2.z = Math.max(vector3i2.z, posBoxes.get(lodBlockBoundingBox).getMaxZ());
        }
        LodBlockBoundingBox lodBlockBoundingBox = LodBlockBoundingBox.Companion.createVSBoundingBox((byte)vector3i.x, (byte)vector3i.y, (byte)vector3i.z, (byte)vector3i2.x, (byte)vector3i2.y, (byte)vector3i2.z);
        return new Lod1SolidBoxesCollisionShape(lodBlockBoundingBox, (List<CollisionPoint>)object2, posBoxes, list);
    }

    private static final LodBlockBoundingBox mergeBoxes$tryMerging(LodBlockBoundingBox box0, LodBlockBoundingBox box1) {
        int n2;
        byte by2;
        int n3;
        byte by3;
        if (box0.getMinY() == box1.getMinY() && box0.getMaxY() == box1.getMaxY() && box0.getMinZ() == box1.getMinZ() && box0.getMaxZ() == box1.getMaxZ()) {
            by3 = box0.getMinX();
            n3 = box0.getMaxX() + 1;
            by2 = box1.getMinX();
            n2 = box1.getMaxX() + 1;
            if (by3 <= n2 && n3 >= by2) {
                return LodBlockBoundingBox.Companion.createVSBoundingBox((byte)Math.min(box0.getMinX(), box1.getMinX()), box0.getMinY(), box0.getMinZ(), (byte)Math.max(box0.getMaxX(), box1.getMaxX()), box0.getMaxY(), box0.getMaxZ());
            }
        }
        if (box0.getMinX() == box1.getMinX() && box0.getMaxX() == box1.getMaxX() && box0.getMinZ() == box1.getMinZ() && box0.getMaxZ() == box1.getMaxZ()) {
            by3 = box0.getMinY();
            n3 = box0.getMaxY() + 1;
            by2 = box1.getMinY();
            n2 = box1.getMaxY() + 1;
            if (by3 <= n2 && n3 >= by2) {
                return LodBlockBoundingBox.Companion.createVSBoundingBox(box0.getMinX(), (byte)Math.min(box0.getMinY(), box1.getMinY()), box0.getMinZ(), box0.getMaxX(), (byte)Math.max(box0.getMaxY(), box1.getMaxY()), box0.getMaxZ());
            }
        }
        if (box0.getMinX() == box1.getMinX() && box0.getMaxX() == box1.getMaxX() && box0.getMinY() == box1.getMinY() && box0.getMaxY() == box1.getMaxY()) {
            by3 = box0.getMinZ();
            n3 = box0.getMaxZ() + 1;
            by2 = box1.getMinZ();
            n2 = box1.getMaxZ() + 1;
            if (by3 <= n2 && n3 >= by2) {
                return LodBlockBoundingBox.Companion.createVSBoundingBox(box0.getMinX(), box0.getMinY(), (byte)Math.min(box0.getMinZ(), box1.getMinZ()), box0.getMaxX(), box0.getMaxY(), (byte)Math.max(box0.getMaxZ(), box1.getMaxZ()));
            }
        }
        return null;
    }

    private static final boolean cutBoxes$intersects(AABBi box0BB, AABBi box1BB, LodBlockBoundingBox box0, LodBlockBoundingBox box1) {
        box0BB.setMin(box0.getMinX(), box0.getMinY(), box0.getMinZ());
        box0BB.setMax(box0.getMaxX(), box0.getMaxY(), box0.getMaxZ());
        box1BB.setMin(box1.getMinX(), box1.getMinY(), box1.getMinZ());
        box1BB.setMax(box1.getMaxX(), box1.getMaxY(), box1.getMaxZ());
        return box0BB.intersectsAABB(box1BB);
    }

    private static final void cutBoxes$cutBox(LodBlockBoundingBox box, LodBlockBoundingBox cut, List<LodBlockBoundingBox> dest) {
        if (box.getMinX() < cut.getMinX()) {
            dest.add(LodBlockBoundingBox.Companion.createVSBoundingBox(box.getMinX(), box.getMinY(), box.getMinZ(), (byte)(cut.getMinX() - 1), box.getMaxY(), box.getMaxZ()));
        }
        if (box.getMaxX() > cut.getMaxX()) {
            dest.add(LodBlockBoundingBox.Companion.createVSBoundingBox((byte)(cut.getMaxX() + 1), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ()));
        }
        if (box.getMinY() < cut.getMinY()) {
            dest.add(LodBlockBoundingBox.Companion.createVSBoundingBox(cut.getMinX(), box.getMinY(), box.getMinZ(), cut.getMaxX(), (byte)(cut.getMinY() - 1), box.getMaxZ()));
        }
        if (box.getMaxY() > cut.getMaxY()) {
            dest.add(LodBlockBoundingBox.Companion.createVSBoundingBox(cut.getMinX(), (byte)(cut.getMaxY() + 1), box.getMinZ(), cut.getMaxX(), box.getMaxY(), box.getMaxZ()));
        }
        if (box.getMinZ() < cut.getMinZ()) {
            dest.add(LodBlockBoundingBox.Companion.createVSBoundingBox(cut.getMinX(), cut.getMinY(), box.getMinZ(), cut.getMaxX(), cut.getMaxY(), (byte)(cut.getMinZ() - 1)));
        }
        if (box.getMaxZ() > cut.getMaxZ()) {
            dest.add(LodBlockBoundingBox.Companion.createVSBoundingBox(cut.getMinX(), cut.getMinY(), (byte)(cut.getMaxZ() + 1), cut.getMaxX(), cut.getMaxY(), box.getMaxZ()));
        }
    }
}

