/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.valkyrienskies.core.api.ships.QueryableShipData;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.core.apigame.ships.MutableQueryableShipData;
import org.valkyrienskies.core.apigame.world.ClientShipWorldCore;
import org.valkyrienskies.core.impl.game.c;
import org.valkyrienskies.core.impl.game.phys_entities.PhysicsEntityClient;
import org.valkyrienskies.core.impl.game.ships.QueryableShipDataImpl;
import org.valkyrienskies.core.impl.game.ships.ShipDataCommon;
import org.valkyrienskies.core.impl.game.ships.ShipObjectClient;
import org.valkyrienskies.core.impl.game.ships.ShipObjectWorld;
import org.valkyrienskies.core.impl.hooks.VSEvents;
import org.valkyrienskies.core.impl.networking.impl.PhysEntityCreateData;
import org.valkyrienskies.core.impl.shadow.zS;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0019\b\u0007\u0012\u0006\u00106\u001a\u000205\u0012\u0006\u00108\u001a\u000207\u00a2\u0006\u0004\b9\u0010:J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0019\u0010\u0013\u001a\u00020\u00062\n\u0010\u0012\u001a\u00060\u0010j\u0002`\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0015\u001a\u00020\u00062\n\u0010\u0012\u001a\u00060\u0010j\u0002`\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00030\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R$\u0010#\u001a\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\"0!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030%8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010*\u001a\u00020)8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00030%8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010'R\u0014\u0010/\u001a\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100R!\u00104\u001a\u0012\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\u0004\u0012\u00020\"018G\u00a2\u0006\u0006\u001a\u0004\b2\u00103"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/ShipObjectClientWorld;", "Lorg/valkyrienskies/core/apigame/world/ClientShipWorldCore;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectWorld;", "Lorg/valkyrienskies/core/impl/game/ships/ShipObjectClient;", "Lorg/valkyrienskies/core/impl/networking/impl/PhysEntityCreateData;", "physicsEntityCreateData", "", "addPhysicsEntity", "(Lorg/valkyrienskies/core/impl/networking/impl/PhysEntityCreateData;)V", "Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;", "ship", "addShip", "(Lorg/valkyrienskies/core/impl/game/ships/ShipDataCommon;)V", "destroyWorld", "()V", "postTick", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "shipId", "removePhysicsEntity", "(J)V", "removeShip", "Ljava/net/SocketAddress;", "server", "tickNetworking", "(Ljava/net/SocketAddress;)V", "", "partialTicks", "updateRenderTransforms", "(D)V", "Lorg/valkyrienskies/core/apigame/ships/MutableQueryableShipData;", "_loadedShips", "Lorg/valkyrienskies/core/apigame/ships/MutableQueryableShipData;", "", "Lorg/valkyrienskies/core/impl/game/phys_entities/PhysicsEntityClient;", "_physicsEntities", "Ljava/util/Map;", "Lorg/valkyrienskies/core/api/ships/QueryableShipData;", "getAllShips", "()Lorg/valkyrienskies/core/api/ships/QueryableShipData;", "allShips", "", "isSyncedWithServer", "()Z", "getLoadedShips", "loadedShips", "Lorg/valkyrienskies/core/impl/shadow/zS;", "networkManager", "Lorg/valkyrienskies/core/impl/shadow/zS;", "", "getPhysicsEntities", "()Ljava/util/Map;", "physicsEntities", "Lorg/valkyrienskies/core/impl/shadow/zS$b;", "networkManagerFactory", "Lorg/valkyrienskies/core/impl/game/c;", "chunkAllocators", "<init>", "(Lorg/valkyrienskies/core/impl/shadow/zS$b;Lorg/valkyrienskies/core/impl/game/c;)V"})
public final class ShipObjectClientWorld
extends ShipObjectWorld<ShipObjectClient>
implements ClientShipWorldCore {
    private final MutableQueryableShipData<ShipObjectClient> _loadedShips;
    private final Map<Long, PhysicsEntityClient> _physicsEntities;
    private final zS networkManager;

    @Inject
    public ShipObjectClientWorld(zS.b networkManagerFactory, c chunkAllocators) {
        Intrinsics.checkNotNullParameter((Object)networkManagerFactory, (String)"");
        Intrinsics.checkNotNullParameter((Object)chunkAllocators, (String)"");
        super(chunkAllocators);
        this._loadedShips = new QueryableShipDataImpl(null, 1, null);
        this._physicsEntities = new HashMap();
        this.networkManager = networkManagerFactory.a(this);
        this.networkManager.b();
    }

    @Override
    @JvmName(name="getAllShips")
    public QueryableShipData<ShipObjectClient> getAllShips() {
        return this.getLoadedShips();
    }

    @JvmName(name="getPhysicsEntities")
    public final Map<Long, PhysicsEntityClient> getPhysicsEntities() {
        return this._physicsEntities;
    }

    @Override
    @JvmName(name="isSyncedWithServer")
    public boolean isSyncedWithServer() {
        return this.networkManager.a();
    }

    @Override
    @JvmName(name="getLoadedShips")
    public QueryableShipData<ShipObjectClient> getLoadedShips() {
        return this._loadedShips;
    }

    public final void addShip(ShipDataCommon ship) {
        Intrinsics.checkNotNullParameter((Object)ship, (String)"");
        ShipObjectClient shipObjectClient = new ShipObjectClient(ship, null, 2, null);
        this._loadedShips.add((ShipObjectClient)((Ship)shipObjectClient));
        VSEvents.INSTANCE.getShipLoadEventClient().emit(new VSEvents.ShipLoadEventClient(shipObjectClient));
    }

    public final void removeShip(long shipId) {
        try {
            ShipObjectClient shipObjectClient = this._loadedShips.remove(shipId);
            VSEvents.INSTANCE.getShipUnloadEventClient().emit(new VSEvents.ShipUnloadEventClient(shipObjectClient));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final void addPhysicsEntity(PhysEntityCreateData physicsEntityCreateData) {
        Intrinsics.checkNotNullParameter((Object)physicsEntityCreateData, (String)"");
        PhysicsEntityClient physicsEntityClient = new PhysicsEntityClient(physicsEntityCreateData.getId(), physicsEntityCreateData.getDimensionId(), physicsEntityCreateData.getShipTransform(), physicsEntityCreateData.getShipTransform(), physicsEntityCreateData.getCollisionShapeData());
        this._physicsEntities.put(physicsEntityClient.getId(), physicsEntityClient);
    }

    public final void removePhysicsEntity(long shipId) {
        this._physicsEntities.remove(shipId);
    }

    @Override
    public void tickNetworking(SocketAddress server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"");
        this.networkManager.a(server);
    }

    @Override
    public void postTick() {
        boolean bl2;
        Object object;
        super.preTick();
        Iterable iterable = this.getLoadedShips();
        boolean bl3 = false;
        for (Object t2 : iterable) {
            object = (ShipObjectClient)t2;
            bl2 = false;
            ((ShipObjectClient)object).tickUpdateShipTransform();
        }
        iterable = this.getPhysicsEntities().values();
        bl3 = false;
        for (Object t2 : iterable) {
            object = (PhysicsEntityClient)t2;
            bl2 = false;
            ((PhysicsEntityClient)object).tickUpdateShipTransform();
        }
    }

    @Override
    public void updateRenderTransforms(double partialTicks) {
        boolean bl2;
        Object object;
        VSEvents.INSTANCE.getStartUpdateRenderTransformsEvent().emit(new VSEvents.StartUpdateRenderTransformsEvent(this));
        Iterable iterable = this.getLoadedShips();
        boolean bl3 = false;
        for (Object t2 : iterable) {
            object = (ShipObjectClient)t2;
            bl2 = false;
            ((ShipObjectClient)object).updateRenderShipTransform(partialTicks);
        }
        iterable = this.getPhysicsEntities().values();
        bl3 = false;
        for (Object t2 : iterable) {
            object = (PhysicsEntityClient)t2;
            bl2 = false;
            ((PhysicsEntityClient)object).updateRenderShipTransform(partialTicks);
        }
    }

    @Override
    public void destroyWorld() {
        this.networkManager.c();
    }
}

