/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.game.ships;

import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Wing;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.WingGroupImpl;
import org.valkyrienskies.core.impl.game.ships.WingManagerImpl;
import org.valkyrienskies.core.util.datastructures.BlockPos2ObjectOpenHashMap;
import org.valkyrienskies.physics_api.PoseVel;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ9\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\r"}, d2={"Lorg/valkyrienskies/core/impl/game/ships/WingPhysicsSolver;", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;", "shipTransform", "Lorg/valkyrienskies/physics_api/PoseVel;", "poseVel", "Lorg/valkyrienskies/core/impl/game/ships/WingManagerImpl;", "wingManager", "Lorg/joml/Matrix3dc;", "momentOfInertia", "Lkotlin/Pair;", "Lorg/joml/Vector3dc;", "applyWingForces", "(Lorg/valkyrienskies/core/api/ships/properties/ShipTransform;Lorg/valkyrienskies/physics_api/PoseVel;Lorg/valkyrienskies/core/impl/game/ships/WingManagerImpl;Lorg/joml/Matrix3dc;)Lkotlin/Pair;", "<init>", "()V"})
public final class WingPhysicsSolver {
    public static final WingPhysicsSolver INSTANCE = new WingPhysicsSolver();

    private WingPhysicsSolver() {
    }

    public final Pair<Vector3dc, Vector3dc> applyWingForces(ShipTransform shipTransform, PoseVel poseVel, WingManagerImpl wingManager, Matrix3dc momentOfInertia) {
        Intrinsics.checkNotNullParameter((Object)shipTransform, (String)"");
        Intrinsics.checkNotNullParameter((Object)poseVel, (String)"");
        Intrinsics.checkNotNullParameter((Object)wingManager, (String)"");
        Intrinsics.checkNotNullParameter((Object)momentOfInertia, (String)"");
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3dc vector3dc = poseVel.getVel();
        Vector3dc vector3dc2 = poseVel.getOmega();
        Object object = wingManager;
        boolean bl2 = false;
        ObjectIterator objectIterator = ((ObjectCollection)WingManagerImpl.access$getWingGroups$p((WingManagerImpl)object).values()).iterator();
        while (objectIterator.hasNext()) {
            Vector3d vector3d3;
            Vector3dc vector3dc3;
            Vector3dc vector3dc4;
            double d2;
            double d3;
            Vector3dc vector3dc5;
            double d4;
            double d5;
            Vector3d vector3d4;
            double d6;
            Vector3dc vector3dc6;
            Vector3dc vector3dc7;
            Vector3dc vector3dc8;
            Vector3dc vector3dc9;
            Vector3dc vector3dc10;
            Vector3dc vector3dc11;
            Vector3dc vector3dc12;
            boolean bl3;
            Matrix4dc matrix4dc;
            int n2;
            int n3;
            int n4;
            Wing wing;
            boolean bl4;
            int n5;
            int n6;
            int n7;
            Wing wing2;
            WingGroupImpl wingGroupImpl;
            WingGroupImpl wingGroupImpl2 = wingGroupImpl = (WingGroupImpl)objectIterator.next();
            boolean bl5 = false;
            BlockPos2ObjectOpenHashMap blockPos2ObjectOpenHashMap = WingGroupImpl.access$getWingsMap$p(wingGroupImpl2);
            boolean bl6 = false;
            if (blockPos2ObjectOpenHashMap.getContainsNullKey()) {
                wing2 = (Wing)blockPos2ObjectOpenHashMap.getValues()[blockPos2ObjectOpenHashMap.getN()];
                n7 = blockPos2ObjectOpenHashMap.getKeys()[blockPos2ObjectOpenHashMap.getN() * 3 + 2];
                n6 = blockPos2ObjectOpenHashMap.getKeys()[blockPos2ObjectOpenHashMap.getN() * 3 + 1];
                n5 = blockPos2ObjectOpenHashMap.getKeys()[blockPos2ObjectOpenHashMap.getN() * 3];
                bl4 = false;
                wing = wing2;
                n4 = n7;
                n3 = n6;
                n2 = n5;
                matrix4dc = wingGroupImpl.getWingTransform();
                bl3 = false;
                Vector3d vector3d5 = matrix4dc.transformDirection(new Vector3d(wing.getWingNormal()));
                Intrinsics.checkNotNullExpressionValue((Object)vector3d5, (String)"");
                vector3dc12 = vector3d5;
                Vector3d vector3d6 = matrix4dc.transformPosition(new Vector3d((double)n2 + 0.5, (double)n3 + 0.5, (double)n4 + 0.5));
                Intrinsics.checkNotNullExpressionValue((Object)vector3d6, (String)"");
                vector3dc11 = vector3d6;
                Vector3d vector3d7 = shipTransform.getShipToWorld().transformPosition(vector3dc11, new Vector3d()).sub(shipTransform.getPositionInWorld());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d7, (String)"");
                vector3dc10 = vector3d7;
                Vector3d vector3d8 = new Vector3d(vector3dc2).cross(vector3dc10).add(vector3dc);
                Intrinsics.checkNotNullExpressionValue((Object)vector3d8, (String)"");
                vector3dc9 = vector3d8;
                Vector3d vector3d9 = shipTransform.getShipToWorld().transformDirection(vector3dc12, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d9, (String)"");
                vector3dc8 = vector3d9;
                Vector3d vector3d10 = vector3dc9.sub(new Vector3d(vector3dc8).mul(vector3dc8.dot(vector3dc9)), new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d10, (String)"");
                vector3dc7 = vector3d10;
                if (vector3dc7.lengthSquared() > 1.0E-12) {
                    Vector3d vector3d11 = new Vector3d(vector3dc7).normalize();
                    Intrinsics.checkNotNullExpressionValue((Object)vector3d11, (String)"");
                    vector3dc6 = vector3d11;
                    d6 = vector3dc6.angle(vector3dc9) * -Math.signum(vector3dc8.dot(vector3dc9)) + wing.getWingCamberAttackAngleBias();
                    vector3d4 = vector3dc9.mul(-1.0, new Vector3d());
                    if (!(vector3d4.lengthSquared() < 1.0E-12)) {
                        vector3d4.normalize();
                        Intrinsics.checkNotNull((Object)vector3d4);
                        d5 = Math.sin(2.0 * d6);
                        d4 = RangesKt.coerceIn((double)(wing.getWingLiftPower() * d5 * vector3dc7.lengthSquared()), (double)-1.0E7, (double)1.0E7);
                        Vector3d vector3d12 = vector3dc8.mul(d4, new Vector3d());
                        Intrinsics.checkNotNullExpressionValue((Object)vector3d12, (String)"");
                        vector3dc5 = vector3d12;
                        d3 = 1.0 - Math.cos(2.0 * d6);
                        d2 = wing.getWingDragPower() * d3 * vector3dc9.lengthSquared();
                        Vector3d vector3d13 = vector3d4.mul(d2, new Vector3d());
                        Intrinsics.checkNotNullExpressionValue((Object)vector3d13, (String)"");
                        vector3dc4 = vector3d13;
                        Vector3d vector3d14 = vector3dc5.add(vector3dc4, new Vector3d());
                        Intrinsics.checkNotNullExpressionValue((Object)vector3d14, (String)"");
                        vector3dc3 = vector3d14;
                        if (!(vector3dc3.lengthSquared() > 1.0E16)) {
                            vector3d3 = vector3dc10.cross(vector3dc3, new Vector3d());
                            vector3d.add(vector3dc3);
                            vector3d2.add(vector3d3);
                        }
                    }
                }
            }
            for (int i2 = blockPos2ObjectOpenHashMap.getN(); -1 < i2; --i2) {
                if (blockPos2ObjectOpenHashMap.getKeys()[i2 * 3] == 0 && blockPos2ObjectOpenHashMap.getKeys()[i2 * 3 + 1] == 0 && blockPos2ObjectOpenHashMap.getKeys()[i2 * 3 + 2] == 0) continue;
                wing2 = (Wing)blockPos2ObjectOpenHashMap.getValues()[i2];
                n7 = blockPos2ObjectOpenHashMap.getKeys()[i2 * 3 + 2];
                n6 = blockPos2ObjectOpenHashMap.getKeys()[i2 * 3 + 1];
                n5 = blockPos2ObjectOpenHashMap.getKeys()[i2 * 3];
                bl4 = false;
                wing = wing2;
                n4 = n7;
                n3 = n6;
                n2 = n5;
                matrix4dc = wingGroupImpl.getWingTransform();
                bl3 = false;
                Vector3d vector3d15 = matrix4dc.transformDirection(new Vector3d(wing.getWingNormal()));
                Intrinsics.checkNotNullExpressionValue((Object)vector3d15, (String)"");
                vector3dc12 = vector3d15;
                Vector3d vector3d16 = matrix4dc.transformPosition(new Vector3d((double)n2 + 0.5, (double)n3 + 0.5, (double)n4 + 0.5));
                Intrinsics.checkNotNullExpressionValue((Object)vector3d16, (String)"");
                vector3dc11 = vector3d16;
                Vector3d vector3d17 = shipTransform.getShipToWorld().transformPosition(vector3dc11, new Vector3d()).sub(shipTransform.getPositionInWorld());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d17, (String)"");
                vector3dc10 = vector3d17;
                Vector3d vector3d18 = new Vector3d(vector3dc2).cross(vector3dc10).add(vector3dc);
                Intrinsics.checkNotNullExpressionValue((Object)vector3d18, (String)"");
                vector3dc9 = vector3d18;
                Vector3d vector3d19 = shipTransform.getShipToWorld().transformDirection(vector3dc12, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d19, (String)"");
                vector3dc8 = vector3d19;
                Vector3d vector3d20 = vector3dc9.sub(new Vector3d(vector3dc8).mul(vector3dc8.dot(vector3dc9)), new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d20, (String)"");
                vector3dc7 = vector3d20;
                if (!(vector3dc7.lengthSquared() > 1.0E-12)) continue;
                Vector3d vector3d21 = new Vector3d(vector3dc7).normalize();
                Intrinsics.checkNotNullExpressionValue((Object)vector3d21, (String)"");
                vector3dc6 = vector3d21;
                d6 = vector3dc6.angle(vector3dc9) * -Math.signum(vector3dc8.dot(vector3dc9)) + wing.getWingCamberAttackAngleBias();
                vector3d4 = vector3dc9.mul(-1.0, new Vector3d());
                if (vector3d4.lengthSquared() < 1.0E-12) continue;
                vector3d4.normalize();
                Intrinsics.checkNotNull((Object)vector3d4);
                d5 = Math.sin(2.0 * d6);
                d4 = RangesKt.coerceIn((double)(wing.getWingLiftPower() * d5 * vector3dc7.lengthSquared()), (double)-1.0E7, (double)1.0E7);
                Vector3d vector3d22 = vector3dc8.mul(d4, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d22, (String)"");
                vector3dc5 = vector3d22;
                d3 = 1.0 - Math.cos(2.0 * d6);
                d2 = wing.getWingDragPower() * d3 * vector3dc9.lengthSquared();
                Vector3d vector3d23 = vector3d4.mul(d2, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d23, (String)"");
                vector3dc4 = vector3d23;
                Vector3d vector3d24 = vector3dc5.add(vector3dc4, new Vector3d());
                Intrinsics.checkNotNullExpressionValue((Object)vector3d24, (String)"");
                vector3dc3 = vector3d24;
                if (vector3dc3.lengthSquared() > 1.0E16) continue;
                vector3d3 = vector3dc10.cross(vector3dc3, new Vector3d());
                vector3d.add(vector3dc3);
                vector3d2.add(vector3d3);
            }
        }
        object = momentOfInertia.invert(new Matrix3d());
        Vector3d vector3d25 = ((Matrix3d)object).transform(shipTransform.getWorldToShip().transformDirection(vector3d2, new Vector3d()));
        double d7 = Math.PI * 4;
        if (vector3d25.length() > d7) {
            vector3d2.mul(d7 / vector3d25.length());
        }
        return new Pair((Object)vector3d, (Object)vector3d2);
    }
}

