/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.common.util;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.valkyrienskies.core.apigame.world.IPlayer;
import org.valkyrienskies.core.apigame.world.PlayerState;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.entity.ShipMountedToData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u00100\u001a\u00020\"\u00a2\u0006\u0004\b1\u00102J\u001a\u0010\u0005\u001a\u00020\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0018\u001a\u00060\u0014j\u0002`\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R2\u0010\u001d\u001a\u001a\u0012\b\u0012\u00060\u001aj\u0002`\u001b0\u0019j\f\u0012\b\u0012\u00060\u001aj\u0002`\u001b`\u001c8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0012R\u0011\u0010%\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001d\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0&8\u0006\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\u001a\u0010,\u001a\u00020+8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/\u00a8\u00063"}, d2={"Lorg/valkyrienskies/mod/common/util/MinecraftPlayer;", "Lorg/valkyrienskies/core/apigame/world/IPlayer;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "Lorg/valkyrienskies/core/apigame/world/PlayerState;", "getPlayerState", "()Lorg/valkyrienskies/core/apigame/world/PlayerState;", "Lorg/joml/Vector3d;", "dest", "getPosition", "(Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "", "hashCode", "()I", "getCanModifyServerConfig", "()Z", "canModifyServerConfig", "", "Lorg/valkyrienskies/core/apigame/world/properties/DimensionId;", "getDimension", "()Ljava/lang/String;", "dimension", "Ljava/util/HashSet;", "", "Lorg/valkyrienskies/core/api/ships/properties/ShipId;", "Lkotlin/collections/HashSet;", "forceWatchingShips", "Ljava/util/HashSet;", "getForceWatchingShips", "()Ljava/util/HashSet;", "isAdmin", "Lnet/minecraft/class_1657;", "getPlayer", "()Lnet/minecraft/class_1657;", "player", "Ljava/lang/ref/WeakReference;", "playerEntityReference", "Ljava/lang/ref/WeakReference;", "getPlayerEntityReference", "()Ljava/lang/ref/WeakReference;", "Ljava/util/UUID;", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "playerObject", "<init>", "(Lnet/minecraft/class_1657;)V", "valkyrienskies-120"})
public final class MinecraftPlayer
implements IPlayer {
    @NotNull
    private final UUID uuid;
    @NotNull
    private final WeakReference<class_1657> playerEntityReference;
    @NotNull
    private final HashSet<Long> forceWatchingShips;

    public MinecraftPlayer(@NotNull class_1657 playerObject) {
        Intrinsics.checkNotNullParameter((Object)playerObject, (String)"playerObject");
        UUID uUID = playerObject.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        this.uuid = uUID;
        this.playerEntityReference = new WeakReference<class_1657>(playerObject);
        this.forceWatchingShips = new HashSet();
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public final WeakReference<class_1657> getPlayerEntityReference() {
        return this.playerEntityReference;
    }

    @NotNull
    public final class_1657 getPlayer() {
        Object t2 = this.playerEntityReference.get();
        Intrinsics.checkNotNull(t2);
        return (class_1657)t2;
    }

    @Override
    public boolean isAdmin() {
        return this.getPlayer().method_5687(4);
    }

    @Override
    public boolean getCanModifyServerConfig() {
        return VSGameUtilsKt.getVsCore().getHooks().isPhysicalClient() || this.getPlayer().method_5687(4);
    }

    @Override
    @NotNull
    public String getDimension() {
        class_1937 class_19372 = this.getPlayer().method_37908();
        Intrinsics.checkNotNullExpressionValue((Object)class_19372, (String)"level(...)");
        return VSGameUtilsKt.getDimensionId(class_19372);
    }

    @NotNull
    public HashSet<Long> getForceWatchingShips() {
        return this.forceWatchingShips;
    }

    @Override
    @NotNull
    public Vector3d getPosition(@NotNull Vector3d dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Vector3d vector3d = dest.set(this.getPlayer().method_23317(), this.getPlayer().method_23318(), this.getPlayer().method_23321());
        Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"set(...)");
        return vector3d;
    }

    @Override
    @NotNull
    public PlayerState getPlayerState() {
        Object object;
        ShipMountedToData mountedShipAndPos = VSGameUtilsKt.getShipMountedToData$default((class_1297)this.getPlayer(), null, 2, null);
        ShipMountedToData shipMountedToData = mountedShipAndPos;
        return new PlayerState(new Vector3d(this.getPlayer().method_23317(), this.getPlayer().method_23318(), this.getPlayer().method_23321()), new Vector3d(new Vector3d(this.getPlayer().method_23317() - this.getPlayer().field_6014, this.getPlayer().method_23318() - this.getPlayer().field_6036, this.getPlayer().method_23321() - this.getPlayer().field_5969)), this.getDimension(), (object = mountedShipAndPos) != null && (object = ((ShipMountedToData)object).getShipMountedTo()) != null ? Long.valueOf(object.getId()) : null, shipMountedToData != null ? shipMountedToData.getMountPosInShip() : null);
    }

    public int hashCode() {
        return this.getUuid().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (super.equals(other)) {
            return true;
        }
        if (other instanceof MinecraftPlayer) {
            return Intrinsics.areEqual((Object)this.getUuid(), (Object)((MinecraftPlayer)other).getUuid());
        }
        return false;
    }
}

