/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2424;
import net.minecraft.class_243;
import net.minecraft.class_2784;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3324;
import net.minecraft.class_4048;
import net.minecraft.class_5321;
import net.minecraft.class_5459;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.properties.IShipActiveChunksSet;
import org.valkyrienskies.core.apigame.GameServer;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.apigame.world.VSPipeline;
import org.valkyrienskies.mod.common.IShipObjectWorldServerProvider;
import org.valkyrienskies.mod.common.ShipSavedData;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.config.MassDatapackResolver;
import org.valkyrienskies.mod.common.hooks.VSGameEvents;
import org.valkyrienskies.mod.common.util.EntityDragger;
import org.valkyrienskies.mod.common.util.VSLevelChunk;
import org.valkyrienskies.mod.common.util.VSServerLevel;
import org.valkyrienskies.mod.common.world.ChunkManagement;
import org.valkyrienskies.mod.compat.LoadedMods;
import org.valkyrienskies.mod.compat.Weather2Compat;
import org.valkyrienskies.mod.util.KrunchSupport;

@Mixin(value={MinecraftServer.class})
public abstract class MixinMinecraftServer
implements IShipObjectWorldServerProvider,
GameServer {
    @Shadow
    private class_3324 field_4550;
    @Unique
    private ServerShipWorldCore shipWorld;
    @Unique
    private VSPipeline vsPipeline;
    @Unique
    private Set<String> loadedLevels = new HashSet<String>();
    @Unique
    private final Map<String, class_3218> dimensionToLevelMap = new HashMap<String, class_3218>();

    @Shadow
    public abstract class_3218 method_30002();

    @Shadow
    public abstract Iterable<class_3218> method_3738();

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;initServer()Z")}, method={"runServer"})
    private void beforeInitServer(CallbackInfo info) {
        ValkyrienSkiesMod.setCurrentServer((MinecraftServer)MinecraftServer.class.cast(this));
    }

    @Inject(at={@At(value="TAIL")}, method={"stopServer"})
    private void afterStopServer(CallbackInfo ci2) {
        ValkyrienSkiesMod.setCurrentServer(null);
    }

    @Override
    @Nullable
    public ServerShipWorldCore getShipObjectWorld() {
        return this.shipWorld;
    }

    @Override
    @Nullable
    public VSPipeline getVsPipeline() {
        return this.vsPipeline;
    }

    @Inject(method={"createLevels"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;getDataStorage()Lnet/minecraft/world/level/storage/DimensionDataStorage;")})
    private void postCreateLevels(CallbackInfo ci2) {
        ShipSavedData shipSavedData = (ShipSavedData)this.method_30002().method_17983().method_17924(ShipSavedData::load, ShipSavedData.Companion::createEmpty, "vs_ship_data");
        Throwable ex2 = shipSavedData.getLoadingException();
        if (ex2 != null) {
            System.err.println("VALKYRIEN SKIES ERROR WHILE LOADING SHIP DATA");
            ex2.printStackTrace();
            throw new RuntimeException(ex2);
        }
        this.vsPipeline = shipSavedData.getPipeline();
        if (!MassDatapackResolver.INSTANCE.getRegisteredBlocks()) {
            ArrayList blockStateList = new ArrayList(class_2248.field_10651.method_10204());
            class_2248.field_10651.forEach(blockStateList::add);
            MassDatapackResolver.INSTANCE.registerAllBlockStates(blockStateList);
        }
        this.vsPipeline.registerBlocks(MassDatapackResolver.INSTANCE.getSolidBlockStates(), MassDatapackResolver.INSTANCE.getLiquidBlockStates(), MassDatapackResolver.INSTANCE.getBlockStateData());
        KrunchSupport.INSTANCE.setKrunchSupported(!this.vsPipeline.isUsingDummyPhysics());
        this.shipWorld = this.vsPipeline.getShipWorld();
        this.shipWorld.setGameServer(this);
        VSGameEvents.INSTANCE.getRegistriesCompleted().emit(Unit.INSTANCE);
        this.getShipObjectWorld().addDimension(VSGameUtilsKt.getDimensionId((class_1937)this.method_30002()), VSGameUtilsKt.getYRange((class_1937)this.method_30002()));
    }

    @Inject(method={"tickServer"}, at={@At(value="HEAD")})
    private void preTick(CallbackInfo ci2) {
        Set vsPlayers = this.field_4550.method_14571().stream().map(VSGameUtilsKt::getPlayerWrapper).collect(Collectors.toSet());
        this.shipWorld.setPlayers(vsPlayers);
        HashMap<String, class_3218> newLoadedLevels = new HashMap<String, class_3218>();
        for (class_3218 level : this.method_3738()) {
            String dimensionId = VSGameUtilsKt.getDimensionId((class_1937)level);
            newLoadedLevels.put(dimensionId, level);
            this.dimensionToLevelMap.put(dimensionId, level);
        }
        for (String oldLoadedLevelId : this.loadedLevels) {
            if (newLoadedLevels.containsKey(oldLoadedLevelId)) continue;
            this.shipWorld.removeDimension(oldLoadedLevelId);
            this.dimensionToLevelMap.remove(oldLoadedLevelId);
        }
        this.loadedLevels = newLoadedLevels.keySet();
        this.vsPipeline.preTickGame();
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerConnectionListener;tick()V", shift=At.Shift.AFTER)})
    private void preConnectionTick(CallbackInfo ci2) {
        ChunkManagement.tickChunkLoading(this.shipWorld, (MinecraftServer)MinecraftServer.class.cast(this));
    }

    @Shadow
    public abstract class_3218 method_3847(class_5321<class_1937> var1);

    @Shadow
    public abstract boolean method_3839();

    @Inject(method={"tickServer"}, at={@At(value="TAIL")})
    private void postTick(CallbackInfo ci2) {
        this.vsPipeline.postTickGame();
        for (class_3218 level : this.method_3738()) {
            EntityDragger.INSTANCE.dragEntitiesWithShips(level.method_27909());
            if (!LoadedMods.getWeather2()) continue;
            Weather2Compat.INSTANCE.tick(level);
        }
    }

    @Unique
    private class_243 getRelativePortalPosition(class_2350.class_2351 axis, class_5459.class_5460 foundRectangle, class_4048 entityDimensions, class_243 position) {
        return class_2424.method_30494((class_5459.class_5460)foundRectangle, (class_2350.class_2351)axis, (class_243)position, (class_4048)entityDimensions);
    }

    @Unique
    private Optional<class_5459.class_5460> getExitPortal(class_3218 serverLevel, class_2338 blockPos, boolean bl2, class_2784 worldBorder) {
        return serverLevel.method_14173().method_30483(blockPos, bl2, worldBorder);
    }

    @Inject(method={"stopServer"}, at={@At(value="HEAD")})
    private void preStopServer(CallbackInfo ci2) {
        if (this.vsPipeline != null) {
            this.vsPipeline.setDeleteResources(true);
            this.vsPipeline.setArePhysicsRunning(true);
        }
        this.dimensionToLevelMap.clear();
        this.shipWorld.setGameServer(null);
        this.shipWorld = null;
    }

    @NotNull
    private class_3218 getLevelFromDimensionId(@NotNull String dimensionId) {
        return this.dimensionToLevelMap.get(dimensionId);
    }

    @Override
    public void moveTerrainAcrossDimensions(@NotNull IShipActiveChunksSet shipChunks, @NotNull String srcDimension, @NotNull String destDimension) {
        class_3218 srcLevel = this.getLevelFromDimensionId(srcDimension);
        class_3218 destLevel = this.getLevelFromDimensionId(destDimension);
        shipChunks.forEach((x2, z2) -> {
            class_2818 srcChunk = srcLevel.method_8497(x2, z2);
            ((VSServerLevel)destLevel).removeChunk(x2, z2);
            class_2818 destChunk = destLevel.method_8497(x2, z2);
            ((VSLevelChunk)destChunk).copyChunkFromOtherDimension((VSLevelChunk)srcChunk);
        });
        shipChunks.forEach((x2, z2) -> {
            class_2818 srcChunk = srcLevel.method_8497(x2, z2);
            ((VSLevelChunk)srcChunk).clearChunk();
            class_1923 chunkPos = srcChunk.method_12004();
            srcLevel.method_14178().method_12124(chunkPos, false);
            ((VSServerLevel)srcLevel).removeChunk(x2, z2);
        });
    }
}

