/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.physics_api.BoxShapeReference;
import org.valkyrienskies.physics_api.ShapeInUseException;
import org.valkyrienskies.physics_api.UsingDeletedReferenceException;
import org.valkyrienskies.physics_api_krunch.KrunchShapeReference;

class KrunchNativeBoxShapeReference
implements BoxShapeReference,
KrunchShapeReference {
    private long shapeAddress;
    private static final long DELETED_SHAPE_ADDRESS = -1L;

    protected KrunchNativeBoxShapeReference(long shapeAddress) {
        this.shapeAddress = shapeAddress;
    }

    @Override
    public void close() {
        this.ensureNotDeleted();
        boolean deleteSuccessful = KrunchNativeBoxShapeReference.deleteBoxShape(this.shapeAddress);
        if (!deleteSuccessful) {
            throw new ShapeInUseException("Delete box shape failed! This shape is currently in use!");
        }
        this.shapeAddress = -1L;
    }

    protected void finalize() {
        if (this.shapeAddress != -1L) {
            this.close();
        }
    }

    @Override
    public long getShapeShapeAddress() {
        this.ensureNotDeleted();
        return this.shapeAddress;
    }

    @Override
    @NotNull
    public Vector3dc getLengths() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        double[] lengths = new double[3];
        boolean success = KrunchNativeBoxShapeReference.getLengths(this.shapeAddress, lengths);
        if (!success) {
            throw new IllegalStateException("Call to getLengths() failed");
        }
        return new Vector3d(lengths[0], lengths[1], lengths[2]);
    }

    @Override
    public void setLengths(@NotNull Vector3dc lengths) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        boolean success = KrunchNativeBoxShapeReference.setLengths(this.shapeAddress, new double[]{lengths.x(), lengths.y(), lengths.z()});
        if (!success) {
            throw new IllegalStateException("Call to setLengths() failed");
        }
    }

    @Override
    public boolean hasBeenDeleted() {
        return this.shapeAddress == -1L;
    }

    private void ensureNotDeleted() {
        if (this.hasBeenDeleted()) {
            throw new UsingDeletedReferenceException("This shape has been deleted!");
        }
    }

    private static native boolean getLengths(long var0, double[] var2);

    private static native boolean setLengths(long var0, double[] var2);

    private static native boolean deleteBoxShape(long var0);
}

