/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time.internal;

import com.ethlo.time.internal.LeapSecondHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.YearMonth;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public class DefaultLeapSecondHandler
implements LeapSecondHandler {
    public static final String LEAP_SECOND_PATH_CSV = "leap_second_dates.csv";
    private final SortedSet<YearMonth> leapSecondMonths = new TreeSet<YearMonth>();
    private final YearMonth lastLeapKnown;

    public DefaultLeapSecondHandler() {
        try (InputStream in2 = DefaultLeapSecondHandler.class.getClassLoader().getResourceAsStream(LEAP_SECOND_PATH_CSV);
             BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(in2, "leap_second_dates.csv was not found on the classpath"), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                this.leapSecondMonths.add(YearMonth.parse(line));
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
        this.lastLeapKnown = this.leapSecondMonths.last();
    }

    @Override
    public boolean isValidLeapSecondDate(YearMonth needle) {
        return this.leapSecondMonths.contains(needle);
    }

    @Override
    public YearMonth getLastKnownLeapSecond() {
        return this.lastLeapKnown;
    }
}

