/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationMessage;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public abstract class AbstractJsonValidator
implements JsonValidator {
    private final String keyword;

    protected AbstractJsonValidator(String keyword) {
        this.keyword = keyword;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node) {
        return this.validate(node, node, "$");
    }

    protected ValidationMessage buildValidationMessage(ErrorMessageType errorMessageType, String at2, String ... arguments) {
        return ValidationMessage.of(this.keyword, errorMessageType, at2, null, arguments);
    }

    protected ValidationMessage buildValidationMessage(ErrorMessageType errorMessageType, String at2, Map<String, Object> details) {
        return ValidationMessage.of(this.keyword, errorMessageType, at2, null, details);
    }

    protected Set<ValidationMessage> pass() {
        return Collections.emptySet();
    }

    protected Set<ValidationMessage> fail(ErrorMessageType errorMessageType, String at2, Map<String, Object> details) {
        return Collections.singleton(this.buildValidationMessage(errorMessageType, at2, details));
    }

    protected Set<ValidationMessage> fail(ErrorMessageType errorMessageType, String at2, String ... arguments) {
        return Collections.singleton(this.buildValidationMessage(errorMessageType, at2, arguments));
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at2, boolean shouldValidateSchema) {
        Set<ValidationMessage> validationMessages = Collections.emptySet();
        if (shouldValidateSchema) {
            validationMessages = this.validate(node, rootNode, at2);
        }
        return validationMessages;
    }
}

