/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainsValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ContainsValidator.class);
    private final JsonSchema schema;

    public ContainsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.CONTAINS, validationContext);
        this.schema = schemaNode.isObject() || schemaNode.isBoolean() ? new JsonSchema(validationContext, this.getValidatorType().getValue(), parentSchema.getCurrentUri(), schemaNode, parentSchema) : null;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at2) {
        this.debug(logger, node, rootNode, at2);
        if (!node.isArray()) {
            return Collections.emptySet();
        }
        if (node.size() == 0) {
            return this.buildErrorMessageSet(at2);
        }
        if (node.isArray()) {
            int i2 = 0;
            for (JsonNode n2 : node) {
                if (this.schema.validate(n2, rootNode, at2 + "[" + i2 + "]").isEmpty()) {
                    return Collections.emptySet();
                }
                ++i2;
            }
            return this.buildErrorMessageSet(at2);
        }
        return Collections.emptySet();
    }

    private Set<ValidationMessage> buildErrorMessageSet(String at2) {
        return Collections.singleton(this.buildValidationMessage(at2, this.schema.getSchemaNode().toString()));
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.schema) {
            this.schema.initializeValidators();
        }
    }
}

