/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.walk.DefaultItemWalkListenerRunner;
import com.networknt.schema.walk.WalkListenerRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemsValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(ItemsValidator.class);
    private static final String PROPERTY_ADDITIONAL_ITEMS = "additionalItems";
    private final JsonSchema schema;
    private final List<JsonSchema> tupleSchema = new ArrayList<JsonSchema>();
    private boolean additionalItems = true;
    private final JsonSchema additionalSchema;
    private WalkListenerRunner arrayItemWalkListenerRunner;

    public ItemsValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.ITEMS, validationContext);
        JsonSchema foundSchema = null;
        JsonSchema foundAdditionalSchema = null;
        if (schemaNode.isObject() || schemaNode.isBoolean()) {
            foundSchema = new JsonSchema(validationContext, schemaPath, parentSchema.getCurrentUri(), schemaNode, parentSchema);
        } else {
            for (JsonNode s2 : schemaNode) {
                this.tupleSchema.add(new JsonSchema(validationContext, schemaPath, parentSchema.getCurrentUri(), s2, parentSchema));
            }
            JsonNode addItemNode = this.getParentSchema().getSchemaNode().get(PROPERTY_ADDITIONAL_ITEMS);
            if (addItemNode != null) {
                if (addItemNode.isBoolean()) {
                    this.additionalItems = addItemNode.asBoolean();
                } else if (addItemNode.isObject()) {
                    foundAdditionalSchema = new JsonSchema(validationContext, "#", parentSchema.getCurrentUri(), addItemNode, parentSchema);
                }
            }
        }
        this.arrayItemWalkListenerRunner = new DefaultItemWalkListenerRunner(validationContext.getConfig().getArrayItemWalkListeners());
        this.validationContext = validationContext;
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
        this.schema = foundSchema;
        this.additionalSchema = foundAdditionalSchema;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at2) {
        this.debug(logger, node, rootNode, at2);
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        if (!node.isArray() && !this.validationContext.getConfig().isTypeLoose()) {
            return errors;
        }
        if (node.isArray()) {
            int i2 = 0;
            for (JsonNode n2 : node) {
                this.doValidate(errors, i2, n2, rootNode, at2);
                ++i2;
            }
        } else {
            this.doValidate(errors, 0, node, rootNode, at2);
        }
        return Collections.unmodifiableSet(errors);
    }

    private void doValidate(Set<ValidationMessage> errors, int i2, JsonNode node, JsonNode rootNode, String at2) {
        if (this.schema != null) {
            errors.addAll(this.schema.validate(node, rootNode, at2 + "[" + i2 + "]"));
        }
        if (this.tupleSchema != null) {
            if (i2 < this.tupleSchema.size()) {
                errors.addAll(this.tupleSchema.get(i2).validate(node, rootNode, at2 + "[" + i2 + "]"));
            } else if (this.additionalSchema != null) {
                errors.addAll(this.additionalSchema.validate(node, rootNode, at2 + "[" + i2 + "]"));
            } else if (!this.additionalItems) {
                errors.add(this.buildValidationMessage(at2, "" + i2));
            }
        }
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at2, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> validationMessages = new LinkedHashSet<ValidationMessage>();
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            JsonNode defaultNode = null;
            if (this.applyDefaultsStrategy.shouldApplyArrayDefaults() && this.schema != null) {
                defaultNode = this.schema.getSchemaNode().get("default");
            }
            int i2 = 0;
            for (JsonNode n2 : arrayNode) {
                if (n2.isNull() && defaultNode != null) {
                    arrayNode.set(i2, defaultNode);
                    n2 = defaultNode;
                }
                this.doWalk(validationMessages, i2, n2, rootNode, at2, shouldValidateSchema);
                ++i2;
            }
        } else {
            this.doWalk(validationMessages, 0, node, rootNode, at2, shouldValidateSchema);
        }
        return validationMessages;
    }

    private void doWalk(HashSet<ValidationMessage> validationMessages, int i2, JsonNode node, JsonNode rootNode, String at2, boolean shouldValidateSchema) {
        if (this.schema != null) {
            this.walkSchema(this.schema, node, rootNode, at2 + "[" + i2 + "]", shouldValidateSchema, validationMessages);
        }
        if (this.tupleSchema != null) {
            if (i2 < this.tupleSchema.size()) {
                this.walkSchema(this.tupleSchema.get(i2), node, rootNode, at2 + "[" + i2 + "]", shouldValidateSchema, validationMessages);
            } else if (this.additionalSchema != null) {
                this.walkSchema(this.additionalSchema, node, rootNode, at2 + "[" + i2 + "]", shouldValidateSchema, validationMessages);
            }
        }
    }

    private void walkSchema(JsonSchema walkSchema, JsonNode node, JsonNode rootNode, String at2, boolean shouldValidateSchema, Set<ValidationMessage> validationMessages) {
        boolean executeWalk = this.arrayItemWalkListenerRunner.runPreWalkListeners(ValidatorTypeCode.ITEMS.getValue(), node, rootNode, at2, walkSchema.getSchemaPath(), walkSchema.getSchemaNode(), walkSchema.getParentSchema(), this.validationContext, this.validationContext.getJsonSchemaFactory());
        if (executeWalk) {
            validationMessages.addAll(walkSchema.walk(node, rootNode, at2, shouldValidateSchema));
        }
        this.arrayItemWalkListenerRunner.runPostWalkListeners(ValidatorTypeCode.ITEMS.getValue(), node, rootNode, at2, walkSchema.getSchemaPath(), walkSchema.getSchemaNode(), walkSchema.getParentSchema(), this.validationContext, this.validationContext.getJsonSchemaFactory(), validationMessages);
    }

    public List<JsonSchema> getTupleSchema() {
        return this.tupleSchema;
    }

    public JsonSchema getSchema() {
        return this.schema;
    }

    @Override
    public void preloadJsonSchema() {
        if (null != this.schema) {
            this.schema.initializeValidators();
        }
        this.preloadJsonSchemas(this.tupleSchema);
        if (null != this.additionalSchema) {
            this.additionalSchema.initializeValidators();
        }
    }
}

