/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinPropertiesValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MinPropertiesValidator.class);
    protected int min;

    public MinPropertiesValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.MIN_PROPERTIES, validationContext);
        if (schemaNode.canConvertToExactIntegral()) {
            this.min = schemaNode.intValue();
        }
        this.parseErrorCode(this.getValidatorType().getErrorCodeKey());
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at2) {
        this.debug(logger, node, rootNode, at2);
        if (node.isObject() && node.size() < this.min) {
            return Collections.singleton(this.buildValidationMessage(at2, "" + this.min));
        }
        return Collections.emptySet();
    }
}

