/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class AxisAngle4f
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public float angle;
    public float x;
    public float y;
    public float z;

    public AxisAngle4f() {
        this.z = 1.0f;
    }

    public AxisAngle4f(AxisAngle4f a2) {
        this.x = a2.x;
        this.y = a2.y;
        this.z = a2.z;
        this.angle = (float)(((double)a2.angle < 0.0 ? java.lang.Math.PI * 2 + (double)a2.angle % (java.lang.Math.PI * 2) : (double)a2.angle) % (java.lang.Math.PI * 2));
    }

    public AxisAngle4f(Quaternionfc q2) {
        float acos = Math.safeAcos(q2.w());
        float invSqrt = Math.invsqrt(1.0f - q2.w() * q2.w());
        if (Float.isInfinite(invSqrt)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 1.0f;
        } else {
            this.x = q2.x() * invSqrt;
            this.y = q2.y() * invSqrt;
            this.z = q2.z() * invSqrt;
        }
        this.angle = acos + acos;
    }

    public AxisAngle4f(float angle, float x2, float y2, float z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.angle = (float)(((double)angle < 0.0 ? java.lang.Math.PI * 2 + (double)angle % (java.lang.Math.PI * 2) : (double)angle) % (java.lang.Math.PI * 2));
    }

    public AxisAngle4f(float angle, Vector3fc v2) {
        this(angle, v2.x(), v2.y(), v2.z());
    }

    public AxisAngle4f set(AxisAngle4f a2) {
        this.x = a2.x;
        this.y = a2.y;
        this.z = a2.z;
        this.angle = a2.angle;
        this.angle = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        return this;
    }

    public AxisAngle4f set(AxisAngle4d a2) {
        this.x = (float)a2.x;
        this.y = (float)a2.y;
        this.z = (float)a2.z;
        this.angle = (float)a2.angle;
        this.angle = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        return this;
    }

    public AxisAngle4f set(float angle, float x2, float y2, float z2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.angle = (float)(((double)angle < 0.0 ? java.lang.Math.PI * 2 + (double)angle % (java.lang.Math.PI * 2) : (double)angle) % (java.lang.Math.PI * 2));
        return this;
    }

    public AxisAngle4f set(float angle, Vector3fc v2) {
        return this.set(angle, v2.x(), v2.y(), v2.z());
    }

    public AxisAngle4f set(Quaternionfc q2) {
        float acos = Math.safeAcos(q2.w());
        float invSqrt = Math.invsqrt(1.0f - q2.w() * q2.w());
        if (Float.isInfinite(invSqrt)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 1.0f;
        } else {
            this.x = q2.x() * invSqrt;
            this.y = q2.y() * invSqrt;
            this.z = q2.z() * invSqrt;
        }
        this.angle = acos + acos;
        return this;
    }

    public AxisAngle4f set(Quaterniondc q2) {
        double acos = Math.safeAcos(q2.w());
        double invSqrt = Math.invsqrt(1.0 - q2.w() * q2.w());
        if (Double.isInfinite(invSqrt)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 1.0f;
        } else {
            this.x = (float)(q2.x() * invSqrt);
            this.y = (float)(q2.y() * invSqrt);
            this.z = (float)(q2.z() * invSqrt);
        }
        this.angle = (float)(acos + acos);
        return this;
    }

    public AxisAngle4f set(Matrix3fc m2) {
        float nm00 = m2.m00();
        float nm01 = m2.m01();
        float nm02 = m2.m02();
        float nm10 = m2.m10();
        float nm11 = m2.m11();
        float nm12 = m2.m12();
        float nm20 = m2.m20();
        float nm21 = m2.m21();
        float nm22 = m2.m22();
        float lenX = Math.invsqrt(m2.m00() * m2.m00() + m2.m01() * m2.m01() + m2.m02() * m2.m02());
        float lenY = Math.invsqrt(m2.m10() * m2.m10() + m2.m11() * m2.m11() + m2.m12() * m2.m12());
        float lenZ = Math.invsqrt(m2.m20() * m2.m20() + m2.m21() * m2.m21() + m2.m22() * m2.m22());
        nm00 *= lenX;
        nm01 *= lenX;
        nm02 *= lenX;
        nm10 *= lenY;
        nm11 *= lenY;
        nm12 *= lenY;
        nm20 *= lenZ;
        nm21 *= lenZ;
        nm22 *= lenZ;
        float epsilon = 1.0E-4f;
        float epsilon2 = 0.001f;
        if (Math.abs(nm10 - nm01) < epsilon && Math.abs(nm20 - nm02) < epsilon && Math.abs(nm21 - nm12) < epsilon) {
            if (Math.abs(nm10 + nm01) < epsilon2 && Math.abs(nm20 + nm02) < epsilon2 && Math.abs(nm21 + nm12) < epsilon2 && Math.abs(nm00 + nm11 + nm22 - 3.0f) < epsilon2) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            float xx2 = (nm00 + 1.0f) / 2.0f;
            float yy2 = (nm11 + 1.0f) / 2.0f;
            float zz2 = (nm22 + 1.0f) / 2.0f;
            float xy2 = (nm10 + nm01) / 4.0f;
            float xz2 = (nm20 + nm02) / 4.0f;
            float yz2 = (nm21 + nm12) / 4.0f;
            if (xx2 > yy2 && xx2 > zz2) {
                this.x = Math.sqrt(xx2);
                this.y = xy2 / this.x;
                this.z = xz2 / this.x;
            } else if (yy2 > zz2) {
                this.y = Math.sqrt(yy2);
                this.x = xy2 / this.y;
                this.z = yz2 / this.y;
            } else {
                this.z = Math.sqrt(zz2);
                this.x = xz2 / this.z;
                this.y = yz2 / this.z;
            }
            return this;
        }
        float s2 = Math.sqrt((nm12 - nm21) * (nm12 - nm21) + (nm20 - nm02) * (nm20 - nm02) + (nm01 - nm10) * (nm01 - nm10));
        this.angle = Math.safeAcos((nm00 + nm11 + nm22 - 1.0f) / 2.0f);
        this.x = (nm12 - nm21) / s2;
        this.y = (nm20 - nm02) / s2;
        this.z = (nm01 - nm10) / s2;
        return this;
    }

    public AxisAngle4f set(Matrix3dc m2) {
        double nm00 = m2.m00();
        double nm01 = m2.m01();
        double nm02 = m2.m02();
        double nm10 = m2.m10();
        double nm11 = m2.m11();
        double nm12 = m2.m12();
        double nm20 = m2.m20();
        double nm21 = m2.m21();
        double nm22 = m2.m22();
        double lenX = Math.invsqrt(m2.m00() * m2.m00() + m2.m01() * m2.m01() + m2.m02() * m2.m02());
        double lenY = Math.invsqrt(m2.m10() * m2.m10() + m2.m11() * m2.m11() + m2.m12() * m2.m12());
        double lenZ = Math.invsqrt(m2.m20() * m2.m20() + m2.m21() * m2.m21() + m2.m22() * m2.m22());
        nm00 *= lenX;
        nm01 *= lenX;
        nm02 *= lenX;
        nm10 *= lenY;
        nm11 *= lenY;
        nm12 *= lenY;
        nm20 *= lenZ;
        nm21 *= lenZ;
        nm22 *= lenZ;
        double epsilon = 1.0E-4;
        double epsilon2 = 0.001;
        if (Math.abs(nm10 - nm01) < epsilon && Math.abs(nm20 - nm02) < epsilon && Math.abs(nm21 - nm12) < epsilon) {
            if (Math.abs(nm10 + nm01) < epsilon2 && Math.abs(nm20 + nm02) < epsilon2 && Math.abs(nm21 + nm12) < epsilon2 && Math.abs(nm00 + nm11 + nm22 - 3.0) < epsilon2) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            double xx2 = (nm00 + 1.0) / 2.0;
            double yy2 = (nm11 + 1.0) / 2.0;
            double zz2 = (nm22 + 1.0) / 2.0;
            double xy2 = (nm10 + nm01) / 4.0;
            double xz2 = (nm20 + nm02) / 4.0;
            double yz2 = (nm21 + nm12) / 4.0;
            if (xx2 > yy2 && xx2 > zz2) {
                this.x = (float)Math.sqrt(xx2);
                this.y = (float)(xy2 / (double)this.x);
                this.z = (float)(xz2 / (double)this.x);
            } else if (yy2 > zz2) {
                this.y = (float)Math.sqrt(yy2);
                this.x = (float)(xy2 / (double)this.y);
                this.z = (float)(yz2 / (double)this.y);
            } else {
                this.z = (float)Math.sqrt(zz2);
                this.x = (float)(xz2 / (double)this.z);
                this.y = (float)(yz2 / (double)this.z);
            }
            return this;
        }
        double s2 = Math.sqrt((nm12 - nm21) * (nm12 - nm21) + (nm20 - nm02) * (nm20 - nm02) + (nm01 - nm10) * (nm01 - nm10));
        this.angle = (float)Math.safeAcos((nm00 + nm11 + nm22 - 1.0) / 2.0);
        this.x = (float)((nm12 - nm21) / s2);
        this.y = (float)((nm20 - nm02) / s2);
        this.z = (float)((nm01 - nm10) / s2);
        return this;
    }

    public AxisAngle4f set(Matrix4fc m2) {
        float nm00 = m2.m00();
        float nm01 = m2.m01();
        float nm02 = m2.m02();
        float nm10 = m2.m10();
        float nm11 = m2.m11();
        float nm12 = m2.m12();
        float nm20 = m2.m20();
        float nm21 = m2.m21();
        float nm22 = m2.m22();
        float lenX = Math.invsqrt(m2.m00() * m2.m00() + m2.m01() * m2.m01() + m2.m02() * m2.m02());
        float lenY = Math.invsqrt(m2.m10() * m2.m10() + m2.m11() * m2.m11() + m2.m12() * m2.m12());
        float lenZ = Math.invsqrt(m2.m20() * m2.m20() + m2.m21() * m2.m21() + m2.m22() * m2.m22());
        nm00 *= lenX;
        nm01 *= lenX;
        nm02 *= lenX;
        nm10 *= lenY;
        nm11 *= lenY;
        nm12 *= lenY;
        nm20 *= lenZ;
        nm21 *= lenZ;
        nm22 *= lenZ;
        float epsilon = 1.0E-4f;
        float epsilon2 = 0.001f;
        if (Math.abs(nm10 - nm01) < epsilon && Math.abs(nm20 - nm02) < epsilon && Math.abs(nm21 - nm12) < epsilon) {
            if (Math.abs(nm10 + nm01) < epsilon2 && Math.abs(nm20 + nm02) < epsilon2 && Math.abs(nm21 + nm12) < epsilon2 && Math.abs(nm00 + nm11 + nm22 - 3.0f) < epsilon2) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            float xx2 = (nm00 + 1.0f) / 2.0f;
            float yy2 = (nm11 + 1.0f) / 2.0f;
            float zz2 = (nm22 + 1.0f) / 2.0f;
            float xy2 = (nm10 + nm01) / 4.0f;
            float xz2 = (nm20 + nm02) / 4.0f;
            float yz2 = (nm21 + nm12) / 4.0f;
            if (xx2 > yy2 && xx2 > zz2) {
                this.x = Math.sqrt(xx2);
                this.y = xy2 / this.x;
                this.z = xz2 / this.x;
            } else if (yy2 > zz2) {
                this.y = Math.sqrt(yy2);
                this.x = xy2 / this.y;
                this.z = yz2 / this.y;
            } else {
                this.z = Math.sqrt(zz2);
                this.x = xz2 / this.z;
                this.y = yz2 / this.z;
            }
            return this;
        }
        float s2 = Math.sqrt((nm12 - nm21) * (nm12 - nm21) + (nm20 - nm02) * (nm20 - nm02) + (nm01 - nm10) * (nm01 - nm10));
        this.angle = Math.safeAcos((nm00 + nm11 + nm22 - 1.0f) / 2.0f);
        this.x = (nm12 - nm21) / s2;
        this.y = (nm20 - nm02) / s2;
        this.z = (nm01 - nm10) / s2;
        return this;
    }

    public AxisAngle4f set(Matrix4x3fc m2) {
        float nm00 = m2.m00();
        float nm01 = m2.m01();
        float nm02 = m2.m02();
        float nm10 = m2.m10();
        float nm11 = m2.m11();
        float nm12 = m2.m12();
        float nm20 = m2.m20();
        float nm21 = m2.m21();
        float nm22 = m2.m22();
        float lenX = Math.invsqrt(m2.m00() * m2.m00() + m2.m01() * m2.m01() + m2.m02() * m2.m02());
        float lenY = Math.invsqrt(m2.m10() * m2.m10() + m2.m11() * m2.m11() + m2.m12() * m2.m12());
        float lenZ = Math.invsqrt(m2.m20() * m2.m20() + m2.m21() * m2.m21() + m2.m22() * m2.m22());
        nm00 *= lenX;
        nm01 *= lenX;
        nm02 *= lenX;
        nm10 *= lenY;
        nm11 *= lenY;
        nm12 *= lenY;
        nm20 *= lenZ;
        nm21 *= lenZ;
        nm22 *= lenZ;
        float epsilon = 1.0E-4f;
        float epsilon2 = 0.001f;
        if (Math.abs(nm10 - nm01) < epsilon && Math.abs(nm20 - nm02) < epsilon && Math.abs(nm21 - nm12) < epsilon) {
            if (Math.abs(nm10 + nm01) < epsilon2 && Math.abs(nm20 + nm02) < epsilon2 && Math.abs(nm21 + nm12) < epsilon2 && Math.abs(nm00 + nm11 + nm22 - 3.0f) < epsilon2) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            float xx2 = (nm00 + 1.0f) / 2.0f;
            float yy2 = (nm11 + 1.0f) / 2.0f;
            float zz2 = (nm22 + 1.0f) / 2.0f;
            float xy2 = (nm10 + nm01) / 4.0f;
            float xz2 = (nm20 + nm02) / 4.0f;
            float yz2 = (nm21 + nm12) / 4.0f;
            if (xx2 > yy2 && xx2 > zz2) {
                this.x = Math.sqrt(xx2);
                this.y = xy2 / this.x;
                this.z = xz2 / this.x;
            } else if (yy2 > zz2) {
                this.y = Math.sqrt(yy2);
                this.x = xy2 / this.y;
                this.z = yz2 / this.y;
            } else {
                this.z = Math.sqrt(zz2);
                this.x = xz2 / this.z;
                this.y = yz2 / this.z;
            }
            return this;
        }
        float s2 = Math.sqrt((nm12 - nm21) * (nm12 - nm21) + (nm20 - nm02) * (nm20 - nm02) + (nm01 - nm10) * (nm01 - nm10));
        this.angle = Math.safeAcos((nm00 + nm11 + nm22 - 1.0f) / 2.0f);
        this.x = (nm12 - nm21) / s2;
        this.y = (nm20 - nm02) / s2;
        this.z = (nm01 - nm10) / s2;
        return this;
    }

    public AxisAngle4f set(Matrix4dc m2) {
        double nm00 = m2.m00();
        double nm01 = m2.m01();
        double nm02 = m2.m02();
        double nm10 = m2.m10();
        double nm11 = m2.m11();
        double nm12 = m2.m12();
        double nm20 = m2.m20();
        double nm21 = m2.m21();
        double nm22 = m2.m22();
        double lenX = Math.invsqrt(m2.m00() * m2.m00() + m2.m01() * m2.m01() + m2.m02() * m2.m02());
        double lenY = Math.invsqrt(m2.m10() * m2.m10() + m2.m11() * m2.m11() + m2.m12() * m2.m12());
        double lenZ = Math.invsqrt(m2.m20() * m2.m20() + m2.m21() * m2.m21() + m2.m22() * m2.m22());
        nm00 *= lenX;
        nm01 *= lenX;
        nm02 *= lenX;
        nm10 *= lenY;
        nm11 *= lenY;
        nm12 *= lenY;
        nm20 *= lenZ;
        nm21 *= lenZ;
        nm22 *= lenZ;
        double epsilon = 1.0E-4;
        double epsilon2 = 0.001;
        if (Math.abs(nm10 - nm01) < epsilon && Math.abs(nm20 - nm02) < epsilon && Math.abs(nm21 - nm12) < epsilon) {
            if (Math.abs(nm10 + nm01) < epsilon2 && Math.abs(nm20 + nm02) < epsilon2 && Math.abs(nm21 + nm12) < epsilon2 && Math.abs(nm00 + nm11 + nm22 - 3.0) < epsilon2) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            double xx2 = (nm00 + 1.0) / 2.0;
            double yy2 = (nm11 + 1.0) / 2.0;
            double zz2 = (nm22 + 1.0) / 2.0;
            double xy2 = (nm10 + nm01) / 4.0;
            double xz2 = (nm20 + nm02) / 4.0;
            double yz2 = (nm21 + nm12) / 4.0;
            if (xx2 > yy2 && xx2 > zz2) {
                this.x = (float)Math.sqrt(xx2);
                this.y = (float)(xy2 / (double)this.x);
                this.z = (float)(xz2 / (double)this.x);
            } else if (yy2 > zz2) {
                this.y = (float)Math.sqrt(yy2);
                this.x = (float)(xy2 / (double)this.y);
                this.z = (float)(yz2 / (double)this.y);
            } else {
                this.z = (float)Math.sqrt(zz2);
                this.x = (float)(xz2 / (double)this.z);
                this.y = (float)(yz2 / (double)this.z);
            }
            return this;
        }
        double s2 = Math.sqrt((nm12 - nm21) * (nm12 - nm21) + (nm20 - nm02) * (nm20 - nm02) + (nm01 - nm10) * (nm01 - nm10));
        this.angle = (float)Math.safeAcos((nm00 + nm11 + nm22 - 1.0) / 2.0);
        this.x = (float)((nm12 - nm21) / s2);
        this.y = (float)((nm20 - nm02) / s2);
        this.z = (float)((nm01 - nm10) / s2);
        return this;
    }

    public Quaternionf get(Quaternionf q2) {
        return q2.set(this);
    }

    public Quaterniond get(Quaterniond q2) {
        return q2.set(this);
    }

    public Matrix4f get(Matrix4f m2) {
        return m2.set(this);
    }

    public Matrix3f get(Matrix3f m2) {
        return m2.set(this);
    }

    public Matrix4d get(Matrix4d m2) {
        return m2.set(this);
    }

    public Matrix3d get(Matrix3d m2) {
        return m2.set(this);
    }

    public AxisAngle4d get(AxisAngle4d dest) {
        return dest.set(this);
    }

    public AxisAngle4f get(AxisAngle4f dest) {
        return dest.set(this);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.angle);
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
    }

    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        this.angle = in2.readFloat();
        this.x = in2.readFloat();
        this.y = in2.readFloat();
        this.z = in2.readFloat();
    }

    public AxisAngle4f normalize() {
        float invLength = Math.invsqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x *= invLength;
        this.y *= invLength;
        this.z *= invLength;
        return this;
    }

    public AxisAngle4f rotate(float ang) {
        this.angle += ang;
        this.angle = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        return this;
    }

    public Vector3f transform(Vector3f v2) {
        return this.transform(v2, v2);
    }

    public Vector3f transform(Vector3fc v2, Vector3f dest) {
        double sin = Math.sin(this.angle);
        double cos = Math.cosFromSin(sin, (double)this.angle);
        float dot = this.x * v2.x() + this.y * v2.y() + this.z * v2.z();
        dest.set((float)((double)v2.x() * cos + sin * (double)(this.y * v2.z() - this.z * v2.y()) + (1.0 - cos) * (double)dot * (double)this.x), (float)((double)v2.y() * cos + sin * (double)(this.z * v2.x() - this.x * v2.z()) + (1.0 - cos) * (double)dot * (double)this.y), (float)((double)v2.z() * cos + sin * (double)(this.x * v2.y() - this.y * v2.x()) + (1.0 - cos) * (double)dot * (double)this.z));
        return dest;
    }

    public Vector4f transform(Vector4f v2) {
        return this.transform(v2, v2);
    }

    public Vector4f transform(Vector4fc v2, Vector4f dest) {
        double sin = Math.sin(this.angle);
        double cos = Math.cosFromSin(sin, (double)this.angle);
        float dot = this.x * v2.x() + this.y * v2.y() + this.z * v2.z();
        dest.set((float)((double)v2.x() * cos + sin * (double)(this.y * v2.z() - this.z * v2.y()) + (1.0 - cos) * (double)dot * (double)this.x), (float)((double)v2.y() * cos + sin * (double)(this.z * v2.x() - this.x * v2.z()) + (1.0 - cos) * (double)dot * (double)this.y), (float)((double)v2.z() * cos + sin * (double)(this.x * v2.y() - this.y * v2.x()) + (1.0 - cos) * (double)dot * (double)this.z), dest.w);
        return dest;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + Runtime.format(this.x, formatter) + " " + Runtime.format(this.y, formatter) + " " + Runtime.format(this.z, formatter) + " <| " + Runtime.format(this.angle, formatter) + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        float nangle = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        result2 = 31 * result2 + Float.floatToIntBits(nangle);
        result2 = 31 * result2 + Float.floatToIntBits(this.x);
        result2 = 31 * result2 + Float.floatToIntBits(this.y);
        result2 = 31 * result2 + Float.floatToIntBits(this.z);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AxisAngle4f other = (AxisAngle4f)obj;
        float nangle = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        float nangleOther = (float)(((double)other.angle < 0.0 ? java.lang.Math.PI * 2 + (double)other.angle % (java.lang.Math.PI * 2) : (double)other.angle) % (java.lang.Math.PI * 2));
        if (Float.floatToIntBits(nangle) != Float.floatToIntBits(nangleOther)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(other.z);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

