/*
 * Decompiled with CFR 0.152.
 */
package org.joml.primitives;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2dc;
import org.joml.Vector2fc;

public class Circled
implements Externalizable {
    public double x;
    public double y;
    public double r;

    public Circled() {
    }

    public Circled(Circled source) {
        this.x = source.x;
        this.y = source.y;
        this.r = source.r;
    }

    public Circled(double x2, double y2, double r2) {
        this.x = x2;
        this.y = y2;
        this.r = r2;
    }

    public Circled translate(Vector2dc xy2) {
        return this.translate(xy2.x(), xy2.y(), this);
    }

    public Circled translate(Vector2dc xy2, Circled dest) {
        return this.translate(xy2.x(), xy2.y(), dest);
    }

    public Circled translate(Vector2fc xy2) {
        return this.translate(xy2.x(), xy2.y(), this);
    }

    public Circled translate(Vector2fc xy2, Circled dest) {
        return this.translate(xy2.x(), xy2.y(), dest);
    }

    public Circled translate(double x2, double y2) {
        return this.translate(x2, y2, this);
    }

    public Circled translate(double x2, double y2, Circled dest) {
        dest.x = this.x + x2;
        dest.y = this.y + y2;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        long temp = Double.doubleToLongBits(this.r);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Circled other = (Circled)obj;
        if (Double.doubleToLongBits(this.r) != Double.doubleToLongBits(other.r)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + Runtime.format(this.x, formatter) + " " + Runtime.format(this.y, formatter) + " " + Runtime.format(this.r, formatter) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.r);
    }

    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        this.x = in2.readDouble();
        this.y = in2.readDouble();
        this.r = in2.readDouble();
    }
}

