/*
 * Decompiled with CFR 0.152.
 */
package org.joml.primitives;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector3fc;

public class Rayf
implements Externalizable {
    public float oX;
    public float oY;
    public float oZ;
    public float dX;
    public float dY;
    public float dZ;

    public Rayf() {
    }

    public Rayf(Rayf source) {
        this.oX = source.oX;
        this.oY = source.oY;
        this.oZ = source.oZ;
        this.dX = source.dX;
        this.dY = source.dY;
        this.dZ = source.dZ;
    }

    public Rayf(Vector3fc origin, Vector3fc direction) {
        this.oX = origin.x();
        this.oY = origin.y();
        this.oZ = origin.z();
        this.dX = direction.x();
        this.dY = direction.y();
        this.dZ = direction.z();
    }

    public Rayf(float oX2, float oY2, float oZ2, float dX2, float dY2, float dZ2) {
        this.oX = oX2;
        this.oY = oY2;
        this.oZ = oZ2;
        this.dX = dX2;
        this.dY = dY2;
        this.dZ = dZ2;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + Float.floatToIntBits(this.dX);
        result2 = 31 * result2 + Float.floatToIntBits(this.dY);
        result2 = 31 * result2 + Float.floatToIntBits(this.dZ);
        result2 = 31 * result2 + Float.floatToIntBits(this.oX);
        result2 = 31 * result2 + Float.floatToIntBits(this.oY);
        result2 = 31 * result2 + Float.floatToIntBits(this.oZ);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rayf other = (Rayf)obj;
        if (Float.floatToIntBits(this.dX) != Float.floatToIntBits(other.dX)) {
            return false;
        }
        if (Float.floatToIntBits(this.dY) != Float.floatToIntBits(other.dY)) {
            return false;
        }
        if (Float.floatToIntBits(this.dZ) != Float.floatToIntBits(other.dZ)) {
            return false;
        }
        if (Float.floatToIntBits(this.oX) != Float.floatToIntBits(other.oX)) {
            return false;
        }
        if (Float.floatToIntBits(this.oY) != Float.floatToIntBits(other.oY)) {
            return false;
        }
        return Float.floatToIntBits(this.oZ) == Float.floatToIntBits(other.oZ);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "(" + Runtime.format(this.oX, formatter) + " " + Runtime.format(this.oY, formatter) + " " + Runtime.format(this.oZ, formatter) + ") -> (" + Runtime.format(this.dX, formatter) + " " + Runtime.format(this.dY, formatter) + " " + Runtime.format(this.dZ, formatter) + ")";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.oX);
        out.writeFloat(this.oY);
        out.writeFloat(this.oZ);
        out.writeFloat(this.dX);
        out.writeFloat(this.dY);
        out.writeFloat(this.dZ);
    }

    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        this.oX = in2.readFloat();
        this.oY = in2.readFloat();
        this.oZ = in2.readFloat();
        this.dX = in2.readFloat();
        this.dY = in2.readFloat();
        this.dZ = in2.readFloat();
    }
}

