/*
 * Decompiled with CFR 0.152.
 */
package org.joml.primitives;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class Sphered
implements Externalizable {
    public double x;
    public double y;
    public double z;
    public double r;

    public Sphered() {
    }

    public Sphered(Sphered source) {
        this.x = source.x;
        this.y = source.y;
        this.z = source.z;
        this.r = source.r;
    }

    public Sphered(Vector3fc c2, double r2) {
        this.x = c2.x();
        this.y = c2.y();
        this.z = c2.z();
        this.r = r2;
    }

    public Sphered(Vector3dc c2, double r2) {
        this.x = c2.x();
        this.y = c2.y();
        this.z = c2.z();
        this.r = r2;
    }

    public Sphered(double x2, double y2, double z2, double r2) {
        this.x = x2;
        this.y = y2;
        this.z = z2;
        this.r = r2;
    }

    public Sphered translate(Vector3dc xyz) {
        return this.translate(xyz.x(), xyz.y(), xyz.z(), this);
    }

    public Sphered translate(Vector3dc xyz, Sphered dest) {
        return this.translate(xyz.x(), xyz.y(), xyz.z(), dest);
    }

    public Sphered translate(Vector3fc xyz) {
        return this.translate(xyz.x(), xyz.y(), xyz.z(), this);
    }

    public Sphered translate(Vector3fc xyz, Sphered dest) {
        return this.translate(xyz.x(), xyz.y(), xyz.z(), dest);
    }

    public Sphered translate(double x2, double y2, double z2) {
        return this.translate(x2, y2, z2, this);
    }

    public Sphered translate(double x2, double y2, double z2, Sphered dest) {
        dest.x = this.x + x2;
        dest.y = this.y + y2;
        dest.z = this.z + z2;
        return dest;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        long temp = Double.doubleToLongBits(this.r);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.z);
        result2 = 31 * result2 + (int)(temp ^ temp >>> 32);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sphered other = (Sphered)obj;
        if (Double.doubleToLongBits(this.r) != Double.doubleToLongBits(other.r)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(other.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(other.z);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat formatter) {
        return "[" + Runtime.format(this.x, formatter) + " " + Runtime.format(this.y, formatter) + " " + Runtime.format(this.z, formatter) + " " + Runtime.format(this.r, formatter) + "]";
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
        out.writeDouble(this.r);
    }

    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        this.x = in2.readDouble();
        this.y = in2.readDouble();
        this.z = in2.readDouble();
        this.r = in2.readDouble();
    }
}

