/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import org.joml.Random;
import org.joml.sampling.Callback2d;
import org.joml.sampling.Callback3d;
import org.joml.sampling.Math;

public class UniformSampling {

    public static class Sphere {
        private final Random rnd;

        public Sphere(long seed, int numSamples, Callback3d callback) {
            this.rnd = new Random(seed);
            this.generate(numSamples, callback);
        }

        public void generate(int numSamples, Callback3d callback) {
            int i2 = 0;
            while (i2 < numSamples) {
                float x2;
                float x1 = this.rnd.nextFloat() * 2.0f - 1.0f;
                if (x1 * x1 + (x2 = this.rnd.nextFloat() * 2.0f - 1.0f) * x2 >= 1.0f) continue;
                float sqrt = (float)Math.sqrt(1.0 - (double)(x1 * x1) - (double)(x2 * x2));
                float x3 = 2.0f * x1 * sqrt;
                float y2 = 2.0f * x2 * sqrt;
                float z2 = 1.0f - 2.0f * (x1 * x1 + x2 * x2);
                callback.onNewSample(x3, y2, z2);
                ++i2;
            }
        }
    }

    public static class Disk {
        private final Random rnd;

        public Disk(long seed, int numSamples, Callback2d callback) {
            this.rnd = new Random(seed);
            this.generate(numSamples, callback);
        }

        private void generate(int numSamples, Callback2d callback) {
            for (int i2 = 0; i2 < numSamples; ++i2) {
                float r2 = this.rnd.nextFloat();
                float a2 = this.rnd.nextFloat() * 2.0f * (float)java.lang.Math.PI;
                float sqrtR = Math.sqrt(r2);
                float x2 = sqrtR * (float)Math.sin_roquen_9((double)a2 + 1.5707963267948966);
                float y2 = sqrtR * (float)Math.sin_roquen_9(a2);
                callback.onNewSample(x2, y2);
            }
        }
    }
}

