/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.datastructures;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.core.api.util.functions.IntTernaryConsumer;
import org.valkyrienskies.core.util.datastructures.IBlockPosSet;

@JsonDeserialize(using=SmallBlockPosSetDeserializer.class)
@JsonSerialize(using=SmallBlockPosSetSerializer.class)
public class SmallBlockPosSet
implements IBlockPosSet {
    private static final int BOT_12_BITS = 4095;
    private static final int BOT_8_BITS = 255;
    @Nonnull
    private final IntList compressedBlockPosList = new IntArrayList();
    @Nonnull
    private final Int2IntMap listValueToIndex = new Int2IntOpenHashMap();
    private final int centerX;
    private final int centerY;
    private final int centerZ;

    public SmallBlockPosSet(int centerX, int centerY, int centerZ) {
        this.centerX = centerX;
        this.centerY = centerY;
        this.centerZ = centerZ;
    }

    @Override
    public boolean add(int x2, int y2, int z2) {
        if (!this.canStore(x2, y2, z2)) {
            throw new IllegalArgumentException("Cannot store block position at <" + x2 + "," + y2 + "," + z2 + "> into SmallBlockPosSet centered at <" + this.centerX + "," + this.centerY + "," + this.centerZ + ">");
        }
        int n2 = this.compress(x2, y2, z2);
        if (this.listValueToIndex.containsKey(n2)) {
            return false;
        }
        this.compressedBlockPosList.add(n2);
        this.listValueToIndex.put(n2, this.compressedBlockPosList.size() - 1);
        return true;
    }

    @Override
    public boolean remove(int x2, int y2, int z2) {
        if (!this.canStore(x2, y2, z2)) {
            throw new IllegalArgumentException("Cannot remove block position at <" + x2 + "," + y2 + "," + z2 + ">");
        }
        int n2 = this.compress(x2, y2, z2);
        if (!this.listValueToIndex.containsKey(n2)) {
            return false;
        }
        int n3 = this.listValueToIndex.get(n2);
        if (n3 == this.compressedBlockPosList.size() - 1) {
            this.compressedBlockPosList.removeInt(n3);
        } else {
            int n4 = this.compressedBlockPosList.removeInt(this.compressedBlockPosList.size() - 1);
            this.compressedBlockPosList.set(n3, n4);
            this.listValueToIndex.put(n4, n3);
        }
        this.listValueToIndex.remove(n2);
        return true;
    }

    @Override
    public boolean contains(int x2, int y2, int z2) {
        if (!this.canStore(x2, y2, z2)) {
            return false;
        }
        return this.listValueToIndex.containsKey(this.compress(x2, y2, z2));
    }

    @Override
    public boolean canStore(int x2, int y2, int z2) {
        int n2 = x2 - this.centerX;
        int n3 = y2 - this.centerY;
        int n4 = z2 - this.centerZ;
        return !(n3 < -128 | n3 > 127 | n2 < -2048 | n2 > 2047 | n4 < -2048 | n4 > 2047);
    }

    @Override
    public int size() {
        return this.compressedBlockPosList.size();
    }

    @Override
    @Nonnull
    public Iterator<Vector3ic> iterator() {
        return new SmallBlockPosIterator((IntIterator)this.compressedBlockPosList.iterator());
    }

    @Override
    public void forEach(@Nonnull IntTernaryConsumer action) {
        IntListIterator intListIterator = this.compressedBlockPosList.iterator();
        while (intListIterator.hasNext()) {
            int n2 = intListIterator.nextInt();
            int n3 = n2 >> 20;
            int n4 = n2 >> 12 & 0xFF;
            if ((n4 & 0x80) != 0) {
                n4 |= 0xFFFFFF00;
            }
            int n5 = (n2 & 0xFFF) << 20 >> 20;
            action.accept(n5 + this.centerX, n4 + this.centerY, n3 + this.centerZ);
        }
    }

    @Override
    public void clear() {
        this.compressedBlockPosList.clear();
        this.listValueToIndex.clear();
    }

    @Nonnull
    private Vector3ic decompress(int compressed) {
        return this.decompressMutable(compressed, new Vector3i());
    }

    private Vector3i decompressMutable(int compressed, Vector3i mutableBlockPos) {
        int n2 = compressed >> 20;
        int n3 = compressed >> 12 & 0xFF;
        if ((n3 & 0x80) != 0) {
            n3 |= 0xFFFFFF00;
        }
        int n4 = (compressed & 0xFFF) << 20 >> 20;
        mutableBlockPos.set(n4 + this.centerX, n3 + this.centerY, n2 + this.centerZ);
        return mutableBlockPos;
    }

    private int compress(int x2, int y2, int z2) {
        int n2 = x2 - this.centerX & 0xFFF;
        int n3 = y2 - this.centerY & 0xFF;
        int n4 = z2 - this.centerZ & 0xFFF;
        return n2 | n3 << 12 | n4 << 20;
    }

    @Override
    public void forEachUnsafe(@Nonnull IntTernaryConsumer action) {
        Vector3i vector3i = new Vector3i();
        for (int i2 = 0; this.compressedBlockPosList.size() >= i2; ++i2) {
            try {
                int n2 = this.compressedBlockPosList.get(i2);
                this.decompressMutable(n2, vector3i);
                action.accept(vector3i.x(), vector3i.y(), vector3i.z());
                continue;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public int getCenterZ() {
        return this.centerZ;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IBlockPosSet) {
            return ((IBlockPosSet)other).size() == this.size() && ((IBlockPosSet)other).containsAll(this);
        }
        return false;
    }

    private class SmallBlockPosIterator
    implements Iterator<Vector3ic> {
        private final IntIterator iterator;

        SmallBlockPosIterator(IntIterator intIterator) {
            this.iterator = intIterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Vector3ic next() {
            return SmallBlockPosSet.this.decompress(this.iterator.next());
        }
    }

    public static class SmallBlockPosSetDeserializer
    extends StdDeserializer<SmallBlockPosSet> {
        public SmallBlockPosSetDeserializer() {
            super((Class)null);
        }

        @Override
        public SmallBlockPosSet deserialize(JsonParser p2, DeserializationContext ctxt) {
            JsonNode jsonNode = (JsonNode)p2.getCodec().readTree(p2);
            int n2 = jsonNode.get("centerX").asInt();
            int n3 = jsonNode.get("centerY").asInt();
            int n4 = jsonNode.get("centerZ").asInt();
            SmallBlockPosSet smallBlockPosSet = new SmallBlockPosSet(n2, n3, n4);
            for (JsonNode jsonNode2 : jsonNode.get("positions")) {
                int n5 = jsonNode2.asInt();
                smallBlockPosSet.compressedBlockPosList.add(n5);
                smallBlockPosSet.listValueToIndex.put(n5, smallBlockPosSet.compressedBlockPosList.size() - 1);
            }
            return smallBlockPosSet;
        }
    }

    public static class SmallBlockPosSetSerializer
    extends StdSerializer<SmallBlockPosSet> {
        public SmallBlockPosSetSerializer() {
            super((Class)null);
        }

        @Override
        public void serialize(SmallBlockPosSet value, JsonGenerator gen, SerializerProvider provider) {
            gen.writeStartObject();
            gen.writeFieldName("positions");
            gen.writeStartArray(value.compressedBlockPosList, value.compressedBlockPosList.size());
            IntListIterator intListIterator = value.compressedBlockPosList.iterator();
            while (intListIterator.hasNext()) {
                gen.writeNumber(intListIterator.nextInt());
            }
            gen.writeEndArray();
            gen.writeNumberField("centerX", value.centerX);
            gen.writeNumberField("centerY", value.centerY);
            gen.writeNumberField("centerZ", value.centerZ);
            gen.writeEndObject();
        }
    }
}

