/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.core.impl.util.names;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.valkyrienskies.core.impl.util.names.NameGenerator;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0003\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00058\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\r"}, d2={"Lorg/valkyrienskies/core/impl/util/names/NounListNameGenerator;", "Lorg/valkyrienskies/core/impl/util/names/NameGenerator;", "", "generateName", "()Ljava/lang/String;", "", "numberOfNouns", "(I)Ljava/lang/String;", "DEFAULT_NOUNS_PER_NAME", "I", "NOUN_LIST_LENGTH", "", "nouns", "Ljava/util/List;", "<init>", "()V"})
public final class NounListNameGenerator
implements NameGenerator {
    public static final NounListNameGenerator INSTANCE = new NounListNameGenerator();
    private static final int NOUN_LIST_LENGTH = 6801;
    private static final int DEFAULT_NOUNS_PER_NAME = 3;
    private static final List<String> nouns;

    private NounListNameGenerator() {
    }

    @Override
    public String generateName() {
        return this.generateName(3);
    }

    public final String generateName(int numberOfNouns) {
        String string = ThreadLocalRandom.current().ints(numberOfNouns, 0, nouns.size()).mapToObj(NounListNameGenerator::generateName$lambda$0).collect(Collectors.joining("-"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    private static final String generateName$lambda$0(int index) {
        return nouns.get(index);
    }

    static {
        ClassLoader classLoader = INSTANCE.getClass().getClassLoader();
        Intrinsics.checkNotNull((Object)classLoader);
        InputStream inputStream = classLoader.getResourceAsStream("nounlist.txt");
        Intrinsics.checkNotNull((Object)inputStream);
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n2 = 8192;
        List list = (reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n2)).lines().collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        nouns = list;
    }
}

