/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.mod_compat.create;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.IAirCurrentSource;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.entity.handling.DefaultShipyardEntityHandler;
import org.valkyrienskies.mod.common.entity.handling.VSEntityManager;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.compat.create.AdvancedAirCurrentSegment;
import org.valkyrienskies.mod.compat.create.AirFlowClipContext;
import org.valkyrienskies.mod.mixinducks.mod_compat.create.IExtendedAirCurrentSource;
import org.valkyrienskies.mod.util.AdvancedBlockWalker;

@Mixin(value={AirCurrent.class})
public abstract class MixinAirCurrent {
    @Shadow
    @Final
    public IAirCurrentSource source;
    @Shadow
    public class_2350 direction;
    @Shadow
    public boolean pushing;
    @Shadow
    public float maxDistance;
    @Shadow
    protected List<Pair<TransportedItemStackHandlerBehaviour, FanProcessingType>> affectedItemHandlers;
    @Unique
    private double shipScale = 1.0;
    @Unique
    private List<AdvancedAirCurrentSegment> segments = new ArrayList<AdvancedAirCurrentSegment>();

    @Shadow
    private static boolean shouldAlwaysPass(class_2680 state) {
        return false;
    }

    @Shadow
    protected abstract int getLimit();

    @Unique
    private Ship getShip() {
        IAirCurrentSource iAirCurrentSource = this.source;
        if (iAirCurrentSource instanceof IExtendedAirCurrentSource) {
            IExtendedAirCurrentSource se2 = (IExtendedAirCurrentSource)iAirCurrentSource;
            return se2.getShip();
        }
        if (this.source.getAirCurrentWorld() != null) {
            return VSGameUtilsKt.getShipManagingPos(this.source.getAirCurrentWorld(), this.source.getAirCurrentPos());
        }
        return null;
    }

    @Inject(method={"getFlowLimit"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private static void clipFlowLimit(class_1937 level, class_2338 start, float originalMax, class_2350 facing, CallbackInfoReturnable<Float> cir) {
        float flowLimit = ((Float)cir.getReturnValue()).floatValue();
        Ship ship = VSGameUtilsKt.getShipManagingPos(level, start);
        if (ship != null) {
            Vector3d startVec = new Vector3d(start.method_10263(), start.method_10264(), start.method_10260());
            Vector3d direction = VectorConversionsMCKt.toJOMLD(facing.method_10163());
            startVec.add(0.5, 0.5, 0.5).add(direction.mul(0.5, new Vector3d()));
            ship.getTransform().getShipToWorld().transformPosition(startVec);
            ship.getTransform().getShipToWorld().transformDirection(direction);
            Vector3dc scaling = ship.getTransform().getShipToWorldScaling();
            double shipScale = facing.method_10166().method_10172(scaling.x(), scaling.y(), scaling.z());
            direction.mul(flowLimit);
            class_243 startPos = VectorConversionsMCKt.toMinecraft(startVec);
            class_243 endPos = VectorConversionsMCKt.toMinecraft(startVec.add(direction.x, direction.y, direction.z));
            class_3965 result2 = level.method_17742((class_3959)new AirFlowClipContext(level, start, startPos, endPos, MixinAirCurrent::shouldAlwaysPass));
            cir.setReturnValue((Object)Float.valueOf((float)(result2.method_17784().method_1022(startPos) / shipScale + 2.0E-6)));
            return;
        }
        class_2338 end = start.method_10079(facing, (int)Math.ceil(flowLimit));
        if (VSGameUtilsKt.getShipsIntersecting(level, new class_238((double)start.method_10263(), (double)start.method_10264(), (double)start.method_10260(), (double)(end.method_10263() + 1), (double)(end.method_10264() + 1), (double)(end.method_10260() + 1))).iterator().hasNext()) {
            class_243 startPos = class_243.method_24953((class_2382)start).method_1031((double)facing.method_10148() * 0.5, (double)facing.method_10164() * 0.5, (double)facing.method_10165() * 0.5);
            class_243 endPos = class_243.method_24953((class_2382)end).method_1031((double)facing.method_10148() * 0.5, (double)facing.method_10164() * 0.5, (double)facing.method_10165() * 0.5);
            class_3965 result3 = level.method_17742((class_3959)new AirFlowClipContext(level, start, startPos, endPos, MixinAirCurrent::shouldAlwaysPass));
            cir.setReturnValue((Object)Float.valueOf(Math.min((float)(result3.method_17784().method_1022(startPos) + 2.0E-6), flowLimit)));
        }
    }

    @Inject(method={"rebuild"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/fan/IAirCurrentSource;getAirCurrentWorld()Lnet/minecraft/world/level/Level;", remap=true)}, remap=false)
    private void calcScaling(CallbackInfo ci2) {
        Ship ship = this.getShip();
        if (ship != null) {
            Vector3dc scaling = ship.getTransform().getShipToWorldScaling();
            this.shipScale = this.direction.method_10166().method_10172(scaling.x(), scaling.y(), scaling.z());
        }
    }

    @Inject(method={"rebuild"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/fan/AirCurrent;findAffectedHandlers()V")}, remap=false)
    private void calcSegments(CallbackInfo ci2) {
        this.segments.clear();
        class_1937 level = this.source.getAirCurrentWorld();
        class_2338 start = this.source.getAirCurrentPos();
        AdvancedAirCurrentSegment currentSegment = null;
        FanProcessingType type = null;
        int limit = this.getLimit();
        class_243 delta = new class_243((double)this.direction.method_10148() * 0.5, (double)this.direction.method_10164() * 0.5, (double)this.direction.method_10165() * 0.5);
        class_243 startPos = start.method_46558().method_1019(delta);
        class_243 endPos = start.method_10079(this.direction, limit).method_46558().method_1019(delta);
        AdvancedBlockWalker walker = new AdvancedBlockWalker(level, startPos, endPos, !this.pushing);
        while (walker.hasNext()) {
            AdvancedBlockWalker.BlockPosWithDistance data = walker.next();
            FanProcessingType newType = FanProcessingType.getAt((class_1937)level, (class_2338)data.pos());
            double dist = data.distance();
            if (dist < 2.147483647E9 && Math.abs(dist - (double)((int)dist)) < 1.0E-6) {
                dist = (int)dist;
            }
            if (newType != null) {
                type = newType;
            }
            if (currentSegment == null) {
                currentSegment = new AdvancedAirCurrentSegment();
                currentSegment.startOffset = dist;
                currentSegment.type = type;
                continue;
            }
            if (currentSegment.type == type) continue;
            currentSegment.endOffset = dist;
            this.segments.add(currentSegment);
            currentSegment = new AdvancedAirCurrentSegment();
            currentSegment.startOffset = dist;
            currentSegment.type = type;
        }
        if (currentSegment != null) {
            currentSegment.endOffset = this.pushing ? (double)limit : 0.0;
            this.segments.add(currentSegment);
        }
    }

    @WrapOperation(method={"tickAffectedEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;position()Lnet/minecraft/world/phys/Vec3;")})
    private class_243 transformEntityPos(class_1297 instance, Operation<class_243> original) {
        class_243 result2 = (class_243)original.call(new Object[]{instance});
        Ship ship = this.getShip();
        if (ship == null || VSEntityManager.INSTANCE.getHandler(instance) instanceof DefaultShipyardEntityHandler) {
            return result2;
        }
        Vector3d sourcePos = VectorConversionsMCKt.toJOML(this.source.getAirCurrentPos().method_46558());
        Vector3d naiveEntityPos = ship.getWorldToShip().transformPosition(VectorConversionsMCKt.toJOML(result2));
        Vector3d distanceFromSource = VectorConversionsMCKt.toJOML(this.source.getAirCurrentPos().method_46558()).sub(naiveEntityPos);
        Vector3d adjustedEntityPos = sourcePos.sub(distanceFromSource.div(this.shipScale, new Vector3d()), new Vector3d());
        return VectorConversionsMCKt.toMinecraft(adjustedEntityPos);
    }

    @ModifyArg(method={"tickAffectedEntities"}, at=@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/fan/processing/FanProcessingType;spawnProcessingParticles(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;)V"), index=1)
    private class_243 useRealEntityPosition(class_243 pos, @Local class_1297 entity) {
        return entity.method_19538();
    }

    @Redirect(method={"tickAffectedEntities"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/phys/AABB;intersects(Lnet/minecraft/world/phys/AABB;)Z"))
    private boolean redirectIntersects(class_238 entityAABB, class_238 boundsAABB) {
        Ship ship = this.getShip();
        if (ship == null) {
            return entityAABB.method_994(boundsAABB);
        }
        AABBd entityInShipAABB = VectorConversionsMCKt.toJOML(entityAABB).transform(ship.getWorldToShip());
        AABBd boundsInWorldAABB = VectorConversionsMCKt.toJOML(boundsAABB).transform(ship.getShipToWorld());
        return boundsAABB.method_1003(entityInShipAABB.minX, entityInShipAABB.minY, entityInShipAABB.minZ, entityInShipAABB.maxX, entityInShipAABB.maxY, entityInShipAABB.maxZ) && entityAABB.method_1003(boundsInWorldAABB.minX, boundsInWorldAABB.minY, boundsInWorldAABB.minZ, boundsInWorldAABB.maxX, boundsInWorldAABB.maxY, boundsInWorldAABB.maxZ);
    }

    @WrapOperation(method={"tickAffectedEntities"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V")})
    private void redirectSetDeltaMovement(class_1297 instance, class_243 motion, Operation<Void> original, @Local(ordinal=2) float acceleration, @Local(ordinal=3) float maxAcceleration, @Local(ordinal=0) class_2382 flow) {
        Ship ship = this.getShip();
        if (ship != null && !(VSEntityManager.INSTANCE.getHandler(instance) instanceof DefaultShipyardEntityHandler)) {
            Vector3d tempVec = new Vector3d();
            ship.getTransform().getShipToWorld().transformDirection((double)flow.method_10263(), (double)flow.method_10264(), (double)flow.method_10260(), tempVec);
            class_243 transformedFlow = VectorConversionsMCKt.toMinecraft(tempVec);
            class_243 previousMotion = instance.method_18798();
            double xIn = class_3532.method_15350((double)(transformedFlow.field_1352 * (double)acceleration - previousMotion.field_1352), (double)(-maxAcceleration), (double)maxAcceleration);
            double yIn = class_3532.method_15350((double)(transformedFlow.field_1351 * (double)acceleration - previousMotion.field_1351), (double)(-maxAcceleration), (double)maxAcceleration);
            double zIn = class_3532.method_15350((double)(transformedFlow.field_1350 * (double)acceleration - previousMotion.field_1350), (double)(-maxAcceleration), (double)maxAcceleration);
            motion = previousMotion.method_1019(new class_243(xIn, yIn, zIn).method_1021(0.125));
        }
        original.call(new Object[]{instance, motion});
    }

    @Inject(method={"findAffectedHandlers"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void findAffectedHandlers(CallbackInfo ci2) {
        FanProcessingType type;
        TransportedItemStackHandlerBehaviour behaviour;
        class_2338 pos;
        ci2.cancel();
        this.affectedItemHandlers.clear();
        class_1937 level = this.source.getAirCurrentWorld();
        class_2338 start = this.source.getAirCurrentPos();
        int limit = this.getLimit();
        ArrayList<AdvancedBlockWalker.BlockPosWithDistance> datas = new ArrayList<AdvancedBlockWalker.BlockPosWithDistance>();
        class_243 delta = new class_243((double)this.direction.method_10148() * 0.5, (double)this.direction.method_10164() * 0.5, (double)this.direction.method_10165() * 0.5);
        class_243 startPos = start.method_46558().method_1019(delta);
        class_243 endPos = start.method_10079(this.direction, limit).method_46558().method_1019(delta);
        AdvancedBlockWalker walker = new AdvancedBlockWalker(level, startPos, endPos, !this.pushing);
        while (walker.hasNext()) {
            datas.add(walker.next());
        }
        HashSet<class_2338> processed = new HashSet<class_2338>();
        for (AdvancedBlockWalker.BlockPosWithDistance data : datas) {
            pos = data.pos();
            behaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((class_1922)level, (class_2338)pos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
            if (behaviour == null || !processed.add(pos)) continue;
            type = FanProcessingType.getAt((class_1937)level, (class_2338)pos);
            if (type == null) {
                type = this.getTypeAt0(data.distance());
            }
            this.affectedItemHandlers.add((Pair<TransportedItemStackHandlerBehaviour, FanProcessingType>)Pair.of((Object)behaviour, (Object)type));
        }
        for (AdvancedBlockWalker.BlockPosWithDistance data : datas) {
            pos = data.pos().method_10074();
            behaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((class_1922)level, (class_2338)pos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
            if (behaviour == null || !processed.add(pos)) continue;
            type = FanProcessingType.getAt((class_1937)level, (class_2338)pos);
            if (type == null) {
                type = this.getTypeAt0(data.distance());
            }
            this.affectedItemHandlers.add((Pair<TransportedItemStackHandlerBehaviour, FanProcessingType>)Pair.of((Object)behaviour, (Object)type));
        }
    }

    @Inject(method={"getTypeAt"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void getTypeAt(float offset, CallbackInfoReturnable<FanProcessingType> cir) {
        cir.setReturnValue((Object)this.getTypeAt0(offset));
    }

    @Unique
    private FanProcessingType getTypeAt0(double offset) {
        if (offset < 2.147483647E9 && Math.abs(offset - (double)((int)offset)) < 1.0E-6) {
            offset = (int)offset;
        }
        if (offset < 0.0 || offset > (double)this.maxDistance) {
            return null;
        }
        if (this.pushing) {
            for (AdvancedAirCurrentSegment segment : this.segments) {
                if (!(offset <= segment.endOffset)) continue;
                return segment.type;
            }
        } else {
            for (AdvancedAirCurrentSegment segment : this.segments) {
                if (!(offset >= segment.endOffset)) continue;
                return segment.type;
            }
        }
        return null;
    }
}

