/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.mod.mixin.server.world;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_3193;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.Wing;
import org.valkyrienskies.core.api.ships.WingManager;
import org.valkyrienskies.core.apigame.world.ServerShipWorldCore;
import org.valkyrienskies.core.apigame.world.chunks.TerrainUpdate;
import org.valkyrienskies.mod.common.IShipObjectWorldServerProvider;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.ValkyrienSkiesMod;
import org.valkyrienskies.mod.common.block.WingBlock;
import org.valkyrienskies.mod.common.util.VSServerLevel;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;
import org.valkyrienskies.mod.mixin.accessors.server.level.ChunkMapAccessor;
import org.valkyrienskies.mod.mixin.accessors.server.level.DistanceManagerAccessor;

@Mixin(value={class_3218.class})
public abstract class MixinServerLevel
implements IShipObjectWorldServerProvider,
VSServerLevel {
    @Shadow
    @Final
    private class_3215 field_24624;
    @Unique
    private final Map<class_1923, List<Vector3ic>> vs$knownChunks = new HashMap<class_1923, List<Vector3ic>>();
    @Unique
    private final Long2LongOpenHashMap vs$chunksToUnload = new Long2LongOpenHashMap();
    @Unique
    private static final long VS$CHUNK_UNLOAD_THRESHOLD = 100L;

    @Shadow
    @NotNull
    public abstract MinecraftServer method_8503();

    @Override
    @Nullable
    public ServerShipWorldCore getShipObjectWorld() {
        return ((IShipObjectWorldServerProvider)this.method_8503()).getShipObjectWorld();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    void onInit(CallbackInfo ci2) {
        if (this.getShipObjectWorld() != null) {
            this.getShipObjectWorld().addDimension(VSGameUtilsKt.getDimensionId((class_1937)((class_3218)this)), VSGameUtilsKt.getYRange((class_1937)((class_3218)this)));
        }
    }

    @WrapOperation(method={"sendParticles(Lnet/minecraft/server/level/ServerPlayer;ZDDDLnet/minecraft/network/protocol/Packet;)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;closerToCenterThan(Lnet/minecraft/core/Position;D)Z")})
    private boolean includeShipsInParticleDistanceCheck(class_2338 player, class_2374 particle, double distance, Operation<Boolean> closerToCenterThan) {
        class_3218 self = (class_3218)class_3218.class.cast(this);
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos(self, (int)particle.method_10216() >> 4, (int)particle.method_10215() >> 4);
        if (ship == null) {
            return (Boolean)closerToCenterThan.call(new Object[]{player, particle, distance});
        }
        Vector3d posInWorld = ship.getShipToWorld().transformPosition(VectorConversionsMCKt.toJOML(particle));
        return posInWorld.distanceSquared(player.method_10263(), player.method_10264(), player.method_10260()) < distance * distance;
    }

    @Unique
    private void vs$loadChunk(@NotNull class_2791 worldChunk, List<TerrainUpdate> voxelShapeUpdates) {
        this.vs$chunksToUnload.remove(worldChunk.method_12004().method_8324());
        if (!this.vs$knownChunks.containsKey(worldChunk.method_12004())) {
            ArrayList<Vector3i> voxelChunkPositions = new ArrayList<Vector3i>();
            int chunkX = worldChunk.method_12004().field_9181;
            int chunkZ = worldChunk.method_12004().field_9180;
            class_2826[] chunkSections = worldChunk.method_12006();
            for (int sectionY = 0; sectionY < chunkSections.length; ++sectionY) {
                class_2826 chunkSection = chunkSections[sectionY];
                Vector3i chunkPos = new Vector3i(chunkX, worldChunk.method_31604(sectionY), chunkZ);
                voxelChunkPositions.add(chunkPos);
                if (chunkSection != null && !chunkSection.method_38292()) {
                    TerrainUpdate voxelShapeUpdate2 = VSGameUtilsKt.toDenseVoxelUpdate(chunkSection, chunkPos);
                    voxelShapeUpdates.add(voxelShapeUpdate2);
                    class_3218 thisAsLevel = (class_3218)class_3218.class.cast(this);
                    LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos(thisAsLevel, chunkX, chunkZ);
                    if (ship == null) continue;
                    WingManager shipAsWingManager = ship.getAttachment(WingManager.class);
                    class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                    for (int x2 = 0; x2 < 16; ++x2) {
                        for (int y2 = 0; y2 < 16; ++y2) {
                            for (int z2 = 0; z2 < 16; ++z2) {
                                class_2680 blockState = chunkSection.method_12254(x2, y2, z2);
                                int posX = (chunkX << 4) + x2;
                                int posY = worldChunk.method_31607() + (sectionY << 4) + y2;
                                int posZ = (chunkZ << 4) + z2;
                                if (!(blockState.method_26204() instanceof WingBlock)) continue;
                                mutableBlockPos.method_10103(posX, posY, posZ);
                                Wing wing = ((WingBlock)blockState.method_26204()).getWing((class_1937)thisAsLevel, (class_2338)mutableBlockPos, blockState);
                                if (wing == null) continue;
                                shipAsWingManager.setWing(shipAsWingManager.getFirstWingGroupId(), posX, posY, posZ, wing);
                            }
                        }
                    }
                    continue;
                }
                TerrainUpdate emptyVoxelShapeUpdate = ValkyrienSkiesMod.getVsCore().newEmptyVoxelShapeUpdate(chunkPos.x(), chunkPos.y(), chunkPos.z(), true);
                voxelShapeUpdates.add(emptyVoxelShapeUpdate);
            }
            this.vs$knownChunks.put(worldChunk.method_12004(), voxelChunkPositions);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void postTick(BooleanSupplier shouldKeepTicking, CallbackInfo ci2) {
        class_3218 self = (class_3218)class_3218.class.cast(this);
        ServerShipWorldCore shipObjectWorld = VSGameUtilsKt.getShipObjectWorld(self);
        ChunkMapAccessor chunkMapAccessor = (ChunkMapAccessor)this.field_24624.field_17254;
        ArrayList<TerrainUpdate> voxelShapeUpdates = new ArrayList<TerrainUpdate>();
        DistanceManagerAccessor distanceManagerAccessor = (DistanceManagerAccessor)this.field_24624.field_17254.method_17263();
        for (class_3193 chunkHolder : chunkMapAccessor.callGetChunks()) {
            Optional worldChunkOptional = chunkHolder.method_16145().getNow(class_3193.field_16427).left();
            if (!worldChunkOptional.isPresent() || !distanceManagerAccessor.getTickets().containsKey(chunkHolder.method_13994().method_8324())) continue;
            class_2818 worldChunk = (class_2818)worldChunkOptional.get();
            this.vs$loadChunk((class_2791)worldChunk, voxelShapeUpdates);
        }
        Iterator<Map.Entry<class_1923, List<Vector3ic>>> knownChunkPosIterator = this.vs$knownChunks.entrySet().iterator();
        while (knownChunkPosIterator.hasNext()) {
            Map.Entry<class_1923, List<Vector3ic>> knownChunkPosEntry = knownChunkPosIterator.next();
            long chunkPos = knownChunkPosEntry.getKey().method_8324();
            if (distanceManagerAccessor.getTickets().containsKey(chunkPos) && chunkMapAccessor.callGetVisibleChunkIfPresent(chunkPos) != null) continue;
            long ticksWaitingToUnload = this.vs$chunksToUnload.getOrDefault(chunkPos, 0L);
            if (ticksWaitingToUnload > 100L) {
                for (Vector3ic unloadedChunk : knownChunkPosEntry.getValue()) {
                    TerrainUpdate deleteVoxelShapeUpdate = ValkyrienSkiesMod.getVsCore().newDeleteTerrainUpdate(unloadedChunk.x(), unloadedChunk.y(), unloadedChunk.z());
                    voxelShapeUpdates.add(deleteVoxelShapeUpdate);
                }
                knownChunkPosIterator.remove();
                this.vs$chunksToUnload.remove(chunkPos);
                continue;
            }
            this.vs$chunksToUnload.put(chunkPos, ticksWaitingToUnload + 1L);
        }
        shipObjectWorld.addTerrainUpdates(VSGameUtilsKt.getDimensionId((class_1937)self), voxelShapeUpdates);
    }

    @Override
    public void removeChunk(int chunkX, int chunkZ) {
        class_1923 chunkPos = new class_1923(chunkX, chunkZ);
        this.vs$knownChunks.remove(chunkPos);
    }
}

