/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import it.unimi.dsi.fastutil.ints.IntList;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.valkyrienskies.physics_api.PhysicsWorldReference;
import org.valkyrienskies.physics_api.UsingDeletedReferenceException;
import org.valkyrienskies.physics_api_krunch.KrunchNativePhysicsWorldReference;

public class KrunchNativePhysicsWorldIsland
implements PhysicsWorldReference.PhysicsWorldIsland {
    private final int islandId;
    @NotNull
    private final IntList bodies;
    @NotNull
    private final KrunchNativePhysicsWorldReference krunchPhysicsWorld;

    protected KrunchNativePhysicsWorldIsland(int islandId, @NotNull IntList bodies, @NotNull KrunchNativePhysicsWorldReference krunchPhysicsWorld) {
        this.islandId = islandId;
        this.bodies = bodies;
        this.krunchPhysicsWorld = krunchPhysicsWorld;
    }

    @Override
    @NotNull
    public IntList getBodies() throws UsingDeletedReferenceException {
        return this.bodies;
    }

    @Override
    public void preStep(@NotNull Vector3dc gravity, double timeStep) throws UsingDeletedReferenceException {
        this.krunchPhysicsWorld.ensureResourcesNotDeleted();
        KrunchNativePhysicsWorldIsland.preStep(this.krunchPhysicsWorld.getPhysicsWorldPointer(), this.islandId, gravity.x(), gravity.y(), gravity.z(), timeStep);
    }

    @Override
    public void subStep(@NotNull Vector3dc gravity, double timeStep, double partialTimeStep) throws UsingDeletedReferenceException {
        this.krunchPhysicsWorld.ensureResourcesNotDeleted();
        KrunchNativePhysicsWorldIsland.subStep(this.krunchPhysicsWorld.getPhysicsWorldPointer(), this.islandId, gravity.x(), gravity.y(), gravity.z(), timeStep, partialTimeStep);
    }

    @Override
    public void postStep() throws UsingDeletedReferenceException {
        this.krunchPhysicsWorld.ensureResourcesNotDeleted();
        KrunchNativePhysicsWorldIsland.postStep(this.krunchPhysicsWorld.getPhysicsWorldPointer(), this.islandId);
    }

    private static native void preStep(long var0, int var2, double var3, double var5, double var7, double var9);

    private static native void subStep(long var0, int var2, double var3, double var5, double var7, double var9, double var11);

    private static native void postStep(long var0, int var2);
}

