/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.valkyrienskies.physics_api.CollisionShapeReference;
import org.valkyrienskies.physics_api.PhysicsWorldReference;
import org.valkyrienskies.physics_api.UsingDeletedReferenceException;
import org.valkyrienskies.physics_api.constraints.ConstraintAndId;
import org.valkyrienskies.physics_api_krunch.ConstraintEncoder;
import org.valkyrienskies.physics_api_krunch.KrunchNativePhysicsWorldIslandEncoder;
import org.valkyrienskies.physics_api_krunch.KrunchNativeRigidBodyReference;
import org.valkyrienskies.physics_api_krunch.KrunchNativeVoxelShapeReference;
import org.valkyrienskies.physics_api_krunch.KrunchPhysicsWorldSettingsc;
import org.valkyrienskies.physics_api_krunch.KrunchShapeReference;

class KrunchNativePhysicsWorldReference
implements PhysicsWorldReference {
    private static final long DELETED_PHYSICS_WORLD_POINTER = 0L;
    private static final int CREATE_RIGID_BODY_FAILED = -1;
    private long physicsWorldPointer = KrunchNativePhysicsWorldReference.createKrunchNativePhysicsWorld();
    private boolean hasBeenDeleted = false;

    protected KrunchNativePhysicsWorldReference() throws OutOfMemoryError {
    }

    @Override
    @NotNull
    public List<PhysicsWorldReference.PhysicsWorldIsland> preStep(@NotNull Vector3dc gravity, double timeStep) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        byte[] islandsAsBytes = KrunchNativePhysicsWorldReference.preStep(this.physicsWorldPointer, gravity.x(), gravity.y(), gravity.z(), timeStep);
        ByteBuffer islandsAsByteBuffer = ByteBuffer.wrap(islandsAsBytes).order(ByteOrder.LITTLE_ENDIAN);
        return KrunchNativePhysicsWorldIslandEncoder.decodeIslands(islandsAsByteBuffer, this);
    }

    @Override
    public void postStep() throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        KrunchNativePhysicsWorldReference.postStep(this.physicsWorldPointer);
    }

    public void setSettings(@NotNull KrunchPhysicsWorldSettingsc settingsWrapper) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        KrunchNativePhysicsWorldReference.setSettings(this.physicsWorldPointer, settingsWrapper.getSubSteps(), settingsWrapper.getIterations(), settingsWrapper.getSolverIterationWeight(), settingsWrapper.getCollisionCompliance(), settingsWrapper.getCollisionRestitutionCompliance(), settingsWrapper.getDynamicFrictionCompliance(), settingsWrapper.getSpeculativeContactDistance(), settingsWrapper.getSolverType().getSolverName(), settingsWrapper.getMaxCollisionPoints(), settingsWrapper.getMaxCollisionPointDepth(), settingsWrapper.getMaxDePenetrationSpeed(), settingsWrapper.getMaxVoxelShapeCollisionPoints());
    }

    @Override
    public void deletePhysicsWorldResources() {
        if (!this.hasBeenDeleted) {
            KrunchNativePhysicsWorldReference.deleteKrunchNativePhysicsWorld(this.physicsWorldPointer);
            this.physicsWorldPointer = 0L;
            this.hasBeenDeleted = true;
        }
    }

    @Override
    public boolean deleteRigidBody(int rigidBodyId) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        return KrunchNativePhysicsWorldReference.deleteRigidBody(this.physicsWorldPointer, rigidBodyId);
    }

    @Override
    public boolean hasBeenDeleted() {
        return this.hasBeenDeleted;
    }

    @Override
    public boolean addConstraint(@NotNull ConstraintAndId constraintAndId) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        byte[] bytesRaw = ConstraintEncoder.encodeConstraintAndId(constraintAndId);
        return KrunchNativePhysicsWorldReference.addConstraintAndId(this.physicsWorldPointer, bytesRaw);
    }

    @Override
    @NotNull
    public List<ConstraintAndId> getConstraints() throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        byte[] bytesRaw = KrunchNativePhysicsWorldReference.getConstraints(this.physicsWorldPointer);
        return ConstraintEncoder.decodeConstraints(bytesRaw);
    }

    @Override
    @NotNull
    public List<ConstraintAndId> getConstraintsBrokenLastTick() throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        byte[] bytesRaw = KrunchNativePhysicsWorldReference.getConstraintsBrokenLastTick(this.physicsWorldPointer);
        return ConstraintEncoder.decodeConstraints(bytesRaw);
    }

    @Override
    @NotNull
    public List<ConstraintAndId> getConstraintsRemovedFromDeletedBodiesLastTick() throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        byte[] bytesRaw = KrunchNativePhysicsWorldReference.getConstraintsRemovedFromDeletedBodiesLastTick(this.physicsWorldPointer);
        return ConstraintEncoder.decodeConstraints(bytesRaw);
    }

    @Override
    public boolean removeConstraint(int constraintId) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        return KrunchNativePhysicsWorldReference.removeConstraint(this.physicsWorldPointer, constraintId);
    }

    @Override
    public boolean updateConstraint(@NotNull ConstraintAndId constraintAndId) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        byte[] bytesRaw = ConstraintEncoder.encodeConstraintAndId(constraintAndId);
        return KrunchNativePhysicsWorldReference.updateConstraint(this.physicsWorldPointer, bytesRaw);
    }

    @NotNull
    public <T extends CollisionShapeReference> KrunchNativeRigidBodyReference<T> createRigidBody(@NotNull T shape) throws UsingDeletedReferenceException {
        this.ensureResourcesNotDeleted();
        KrunchShapeReference krunchShapeReference = (KrunchShapeReference)((Object)shape);
        int rigidBodyUniqueId = KrunchNativePhysicsWorldReference.createRigidBody(this.physicsWorldPointer, krunchShapeReference.getShapeShapeAddress(), krunchShapeReference instanceof KrunchNativeVoxelShapeReference);
        if (rigidBodyUniqueId == -1) {
            throw new UsingDeletedReferenceException("Create rigid body failed because shape with id " + ((KrunchShapeReference)((Object)shape)).getShapeShapeAddress() + " was deleted!");
        }
        return new KrunchNativeRigidBodyReference<T>(this, rigidBodyUniqueId, shape);
    }

    @Override
    public void disableCollisionBetweenBodies(int body0, int body1) {
        this.ensureResourcesNotDeleted();
        KrunchNativePhysicsWorldReference.disableCollisionBetweenBodies(this.physicsWorldPointer, body0, body1);
    }

    @Override
    public void enableCollisionBetweenBodies(int body0, int body1) {
        this.ensureResourcesNotDeleted();
        KrunchNativePhysicsWorldReference.enableCollisionBetweenBodies(this.physicsWorldPointer, body0, body1);
    }

    protected void ensureResourcesNotDeleted() throws UsingDeletedReferenceException {
        if (this.hasBeenDeleted()) {
            throw new UsingDeletedReferenceException("The underlying physics world has already been deleted!");
        }
    }

    protected long getPhysicsWorldPointer() {
        return this.physicsWorldPointer;
    }

    private static native long createKrunchNativePhysicsWorld() throws OutOfMemoryError;

    private static native void deleteKrunchNativePhysicsWorld(long var0);

    private static native void setSettings(long var0, int var2, int var3, double var4, double var6, double var8, double var10, double var12, String var14, int var15, double var16, double var18, int var20);

    private static native boolean deleteRigidBody(long var0, int var2);

    private static native boolean addConstraintAndId(long var0, @NotNull byte[] var2);

    private static native byte[] getConstraints(long var0);

    private static native byte[] getConstraintsBrokenLastTick(long var0);

    private static native byte[] getConstraintsRemovedFromDeletedBodiesLastTick(long var0);

    private static native boolean removeConstraint(long var0, int var2);

    private static native boolean updateConstraint(long var0, @NotNull byte[] var2);

    private static native int createRigidBody(long var0, long var2, boolean var4);

    private static native byte[] preStep(long var0, double var2, double var4, double var6, double var8);

    private static native void postStep(long var0);

    private static native void disableCollisionBetweenBodies(long var0, int var2, int var3);

    private static native void enableCollisionBetweenBodies(long var0, int var2, int var3);
}

