/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.physics_api_krunch;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.primitives.AABBi;
import org.valkyrienskies.physics_api.Lod1BlockRegistry;
import org.valkyrienskies.physics_api.ShapeInUseException;
import org.valkyrienskies.physics_api.UsingDeletedReferenceException;
import org.valkyrienskies.physics_api.VoxelShapeReference;
import org.valkyrienskies.physics_api.voxel.UnsafeVoxelChunk16Reference;
import org.valkyrienskies.physics_api.voxel.VoxelChunk16;
import org.valkyrienskies.physics_api_krunch.KrunchShapeReference;
import org.valkyrienskies.physics_api_krunch.voxel.KrunchLod1BlockRegistry;
import org.valkyrienskies.physics_api_krunch.voxel.KrunchUnsafeVoxelChunk16Reference;
import org.valkyrienskies.physics_api_krunch.voxel.KrunchVoxelChunk16;

class KrunchNativeVoxelShapeReference
implements VoxelShapeReference,
KrunchShapeReference {
    private static final long CHUNK_DOES_NOT_EXIST_PTR = 0L;
    public static final int VOXEL_STATE_UNLOADED = -2;
    private static final long DELETED_SHAPE_ADDRESS = -1L;
    private long shapeAddress;
    private final KrunchLod1BlockRegistry lod1BlockRegistry;

    protected KrunchNativeVoxelShapeReference(long shapeAddress, @NotNull KrunchLod1BlockRegistry lod1BlockRegistry) {
        this.shapeAddress = shapeAddress;
        this.lod1BlockRegistry = lod1BlockRegistry;
    }

    @Override
    public void close() {
        this.ensureNotDeleted();
        boolean deleteSuccessful = KrunchNativeVoxelShapeReference.deleteVoxelShape(this.shapeAddress);
        if (!deleteSuccessful) {
            throw new ShapeInUseException("Delete voxel shape failed! This shape is currently in use!");
        }
        this.shapeAddress = -1L;
    }

    protected void finalize() {
        if (this.shapeAddress != -1L) {
            this.close();
        }
    }

    @Override
    public boolean isVoxelTerrainFullyLoaded() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        return KrunchNativeVoxelShapeReference.getIsVoxelTerrainFullyLoaded(this.shapeAddress);
    }

    @Override
    public void setVoxelTerrainFullyLoaded(boolean isVoxelTerrainFullyLoaded) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        KrunchNativeVoxelShapeReference.setIsVoxelTerrainFullyLoaded(this.shapeAddress, isVoxelTerrainFullyLoaded);
    }

    @Override
    public boolean getVoxelShapeAABB(@NotNull AABBi outputBB) {
        this.ensureNotDeleted();
        int[] output = new int[6];
        boolean success = KrunchNativeVoxelShapeReference.getVoxelShapeAABB(this.shapeAddress, output);
        if (!success) {
            return false;
        }
        outputBB.minX = output[0];
        outputBB.minY = output[1];
        outputBB.minZ = output[2];
        outputBB.maxX = output[3];
        outputBB.maxY = output[4];
        outputBB.maxZ = output[5];
        return true;
    }

    @Override
    public long getShapeShapeAddress() {
        this.ensureNotDeleted();
        return this.shapeAddress;
    }

    @Override
    public void bakeVoxelShape() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        KrunchNativeVoxelShapeReference.bakeVoxelShape(this.shapeAddress);
    }

    @Override
    @Nullable
    public VoxelChunk16 copyVoxel16Chunk(int chunkX, int chunkY, int chunkZ) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        long copyPtr = KrunchNativeVoxelShapeReference.copyVoxel16Chunk(this.shapeAddress, chunkX, chunkY, chunkZ);
        if (copyPtr != 0L) {
            return new KrunchVoxelChunk16(copyPtr, this.lod1BlockRegistry);
        }
        return null;
    }

    @Override
    public boolean voxel16ChunkExists(int chunkX, int chunkY, int chunkZ) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        return KrunchNativeVoxelShapeReference.voxel16ChunkExists(this.shapeAddress, chunkX, chunkY, chunkZ);
    }

    @Override
    @Nullable
    public VoxelChunk16 insertChunkReturnOld(int chunkX, int chunkY, int chunkZ, @NotNull VoxelChunk16 voxelChunk16) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        long oldChunk = KrunchNativeVoxelShapeReference.insertChunk(this.shapeAddress, chunkX, chunkY, chunkZ, ((KrunchVoxelChunk16)voxelChunk16).getChunkAddress(), true);
        if (oldChunk != 0L) {
            return new KrunchVoxelChunk16(oldChunk, this.lod1BlockRegistry);
        }
        return null;
    }

    @Override
    public void insertChunk(int chunkX, int chunkY, int chunkZ, @NotNull VoxelChunk16 voxelChunk16) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        long oldChunk = KrunchNativeVoxelShapeReference.insertChunk(this.shapeAddress, chunkX, chunkY, chunkZ, ((KrunchVoxelChunk16)voxelChunk16).getChunkAddress(), false);
        if (oldChunk != 0L) {
            throw new IllegalStateException("This should not be possible!");
        }
    }

    @Override
    @Nullable
    public VoxelChunk16 insertAirChunkReturnOld(int chunkX, int chunkY, int chunkZ) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        long oldChunk = KrunchNativeVoxelShapeReference.insertAirChunk(this.shapeAddress, chunkX, chunkY, chunkZ, true);
        if (oldChunk != 0L) {
            return new KrunchVoxelChunk16(oldChunk, this.lod1BlockRegistry);
        }
        return null;
    }

    @Override
    public void insertAirChunk(int chunkX, int chunkY, int chunkZ) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        long oldChunk = KrunchNativeVoxelShapeReference.insertAirChunk(this.shapeAddress, chunkX, chunkY, chunkZ, false);
        if (oldChunk != 0L) {
            throw new IllegalStateException("This should not be possible!");
        }
    }

    @Override
    @Nullable
    public VoxelChunk16 deleteChunkReturnOld(int chunkX, int chunkY, int chunkZ) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        long oldChunk = KrunchNativeVoxelShapeReference.deleteChunk(this.shapeAddress, chunkX, chunkY, chunkZ, true);
        if (oldChunk != 0L) {
            return new KrunchVoxelChunk16(oldChunk, this.lod1BlockRegistry);
        }
        return null;
    }

    @Override
    public void deleteChunk(int chunkX, int chunkY, int chunkZ) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        long oldChunk = KrunchNativeVoxelShapeReference.deleteChunk(this.shapeAddress, chunkX, chunkY, chunkZ, false);
        if (oldChunk != 0L) {
            throw new IllegalStateException("This should not be possible!");
        }
    }

    @Override
    public boolean isBaked() throws UsingDeletedReferenceException {
        return KrunchNativeVoxelShapeReference.getIsBaked(this.shapeAddress);
    }

    @Override
    @NotNull
    public Lod1BlockRegistry getLod1BlockRegistry() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        return this.lod1BlockRegistry;
    }

    @Override
    @Nullable
    public UnsafeVoxelChunk16Reference getUnsafeVoxelChunk16Reference(int chunkX, int chunkY, int chunkZ) {
        this.ensureNotDeleted();
        long copyPtr = KrunchNativeVoxelShapeReference.getVoxel16ChunkPtrUnsafe(this.shapeAddress, chunkX, chunkY, chunkZ);
        if (copyPtr != 0L) {
            return new KrunchUnsafeVoxelChunk16Reference(copyPtr, this.lod1BlockRegistry);
        }
        return null;
    }

    @Override
    public void setDefinedAABB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        KrunchNativeVoxelShapeReference.setDefinedAABBNative(this.shapeAddress, minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public int getVoxelChunkCount() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        return KrunchNativeVoxelShapeReference.getVoxelChunkCountNative(this.shapeAddress);
    }

    private static native boolean getIsVoxelTerrainFullyLoaded(long var0);

    private static native void setIsVoxelTerrainFullyLoaded(long var0, boolean var2);

    private static native boolean getIsBaked(long var0);

    private static native boolean getVoxelShapeAABB(long var0, @NotNull int[] var2);

    private static native void bakeVoxelShape(long var0);

    private static native long deleteChunk(long var0, int var2, int var3, int var4, boolean var5);

    private static native long insertChunk(long var0, int var2, int var3, int var4, long var5, boolean var7);

    private static native long insertAirChunk(long var0, int var2, int var3, int var4, boolean var5);

    private static native long copyVoxel16Chunk(long var0, int var2, int var3, int var4);

    private static native boolean voxel16ChunkExists(long var0, int var2, int var3, int var4);

    private static native boolean deleteVoxelShape(long var0);

    private static native long getVoxel16ChunkPtrUnsafe(long var0, int var2, int var3, int var4);

    private static native void setDefinedAABBNative(long var0, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native int getVoxelChunkCountNative(long var0);

    protected int getSolidVoxelState(int posX, int posY, int posZ) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        return KrunchNativeVoxelShapeReference.getSolidVoxelState(this.shapeAddress, posX, posY, posZ);
    }

    protected int getLiquidVoxelState(int posX, int posY, int posZ) throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        return KrunchNativeVoxelShapeReference.getLiquidVoxelState(this.shapeAddress, posX, posY, posZ);
    }

    protected List<Vector3ic> getSolidSetVoxels() throws UsingDeletedReferenceException {
        this.ensureNotDeleted();
        int voxelsSize = KrunchNativeVoxelShapeReference.getSolidSetVoxelsSize(this.shapeAddress);
        int[] setVoxels = new int[voxelsSize * 3];
        KrunchNativeVoxelShapeReference.getSolidSetVoxels(this.shapeAddress, setVoxels);
        ArrayList<Vector3ic> toReturn = new ArrayList<Vector3ic>(voxelsSize);
        for (int i2 = 0; i2 < voxelsSize; ++i2) {
            toReturn.add(new Vector3i(setVoxels[i2 * 3], setVoxels[i2 * 3 + 1], setVoxels[i2 * 3 + 2]));
        }
        return toReturn;
    }

    @Override
    public boolean hasBeenDeleted() {
        return this.shapeAddress == -1L;
    }

    private void ensureNotDeleted() {
        if (this.hasBeenDeleted()) {
            throw new UsingDeletedReferenceException("This shape has been deleted!");
        }
    }

    private static native int getSolidVoxelState(long var0, int var2, int var3, int var4);

    private static native int getLiquidVoxelState(long var0, int var2, int var3, int var4);

    private static native int getSolidSetVoxelsSize(long var0);

    private static native void getSolidSetVoxels(long var0, @NotNull int[] var2);
}

